-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_INSTANCE (
    ID                             decimal(20) NOT NULL
    , UNIQUE_NAME                    varchar(256)    NOT NULL
    , OM_ID                          decimal(20)     NOT NULL
    , MODIFY_TS                      decimal(20)         NULL
    , REMOVE_TS                      decimal(20)         NULL
    , CREATOR_U_ID                   decimal(20)     NOT NULL
    , CREATE_TS                      decimal(20)     NOT NULL
    , CHANGER_U_ID                   decimal(20)     NOT NULL
    , CHANGE_TS                      decimal(20)     NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_INSTANCE
ON OBJECT_INSTANCE(ID);
CREATE VIEW SCI_OBJECT_INSTANCE AS
SELECT 
    ID 
    , UNIQUE_NAME                    AS UNIQUE_NAME
    , OM_ID                          AS OM_ID
    , timestamptz 'epoch' + cast(to_char(mod(MODIFY_TS, 1125899906842624)/1000, '999999999999') as interval) AS MODIFY_TS
    , timestamptz 'epoch' + cast(to_char(mod(REMOVE_TS, 1125899906842624)/1000, '999999999999') as interval) AS REMOVE_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamptz 'epoch' + cast(to_char(mod(CREATE_TS, 1125899906842624)/1000, '999999999999') as interval) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamptz 'epoch' + cast(to_char(mod(CHANGE_TS, 1125899906842624)/1000, '999999999999') as interval) AS CHANGE_TS
  FROM OBJECT_INSTANCE;
