/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.SDMSApp;

import de.independit.scheduler.SDMSApp.Options;
import de.independit.scheduler.SDMSApp.RetryException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputError;
import de.independit.scheduler.shell.SDMSServerConnection;
import java.io.IOException;
import java.util.Date;

public class App {
    public static final String __version = "@(#) $Id: App.java,v 1.21.4.2 2013/03/15 12:17:20 ronald Exp $";
    public static final String HOST = "HOST";
    public static final String PORT = "PORT";
    public static final String USER = "USER";
    public static final String PASS = "PASS";
    public static final String JID = "JID";
    public static final String KEY = "KEY";
    public static final String SILENT = "SILENT";
    public static final String AUTH = "AUTH";
    public static final String BASIC = "BASIC";
    public static final String WINSSO = "WINSSO";
    public static final String SPN = "SPN";
    public static final String VERBOSE = "VERBOSE";
    public static final String TIMEOUT = "TIMEOUT";
    public static final String CONNTIMEOUT = "CONNTIMEOUT";
    public static final String CYCLE = "CYCLE";
    public static final String TLS = "TLS";
    public static final String INI = "INI";
    public static final String HELP = "HELP";
    public static final String KEYSTORE = "KEYSTORE";
    public static final String TRUSTSTORE = "TRUSTSTORE";
    public static final String KEYSTOREPW = "KEYSTOREPW";
    public static final String TRUSTSTOREPW = "TRUSTSTOREPW";
    public static final String SUSPEND = "SUSPEND";
    public static final String DELAY = "DELAY";
    public static final String UNIT = "UNIT";
    public static final String AT = "AT";
    public static final String WARNING = "WARNING";
    public static final String INFO = "INFO";
    static App app;
    protected SDMSServerConnection serverConnection = null;
    public static String userName;
    public static String auth;
    public Options options;
    public int executions;
    public boolean silent = false;
    public boolean verbose = false;

    public void addOption(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, String string7) {
        this.options.add(string, string2, string3, string4, string5, string6, bl, string7);
    }

    private void addStandardOptions() {
        boolean bl = this.userOnly();
        this.addOption("h", "host", "Host", HOST, null, "hostname", true, "BICsuite!server Host");
        this.addOption("p", "port", "Port", PORT, "2506", "portnumber", false, "BICsuite!server Port (defaults to 2506)");
        this.addOption("a", "auth", "Auhentication", AUTH, BASIC, "authcode", false, "User Authentication Method (defaults to 'BASIC') allowed are 'BASIC','WINSSO'");
        this.addOption("P", "spn", SPN, SPN, null, "spn", false, "Service Pricipal Name of BICsuite service when using WINSSO Authentication");
        this.addOption("u", "user", "User", USER, null, "username", bl, "Username (user or jid must be specified)");
        this.addOption("w", "pass", "Password", PASS, null, "password", bl, "Password (must be specified if user is specified)");
        if (!bl) {
            this.addOption("j", "jid", null, JID, null, "jobid", false, "Job Id (user or jid must be specified)");
            this.addOption("k", "key", null, KEY, null, "jobkey", false, "Job Key (must be specified if user is not specified)");
        }
        this.addOption("s", "silent", "Silent", SILENT, null, null, false, "[No] (error) messages, feedbacks and additional messages are printed");
        this.addOption("v", "verbose", "Verbose", VERBOSE, null, null, false, "[No] commands are printed");
        if (this.canRetry()) {
            this.addOption("t", "timeout", "Timeout", TIMEOUT, null, "minutes", false, "Number of minutes to retry on connection problems. 0 disables retry (default is wait forever)");
            this.addOption("c", "cycle", "Cycle", CYCLE, "1", "minutes", false, "Number of minutes to wait between retries. Minimal value and default is 1 minute");
        }
        this.addOption("ini", "ini", null, INI, null, "inifile", false, "Use inifile for configuration of standard options");
        this.addOption("tls", "tls", TLS, TLS, null, null, false, "Use SSL/TLS Connection");
        this.addOption(null, "help", null, HELP, null, null, false, "Displays this help");
        this.addOption(null, null, "KeyStore", KEYSTORE, null, "keystore", false, "Keystore to use for TLS/SSL encrypted communication");
        this.addOption(null, null, "TrustStore", TRUSTSTORE, null, "truststore", false, "Truststore to use for TLS/SSL encrypted communication");
        this.addOption(null, null, "KeyStorePassword", KEYSTOREPW, null, "keystorepw", false, "Keystore password to use for TLS/SSL encrypted communication");
        this.addOption(null, null, "TrustStorePassword", TRUSTSTOREPW, null, "truststorepw", false, "Truststore password to use for TLS/SSL encrypted communication");
        this.addOption(null, "info", "Info", INFO, null, "sessioninfo", false, "Additional information for identifying the session");
    }

    private boolean validateStandardOptions() {
        if (this.options.isSet(AUTH)) {
            switch (auth = this.options.getValue(AUTH)) {
                case "BASIC": {
                    break;
                }
                case "WINSSO": {
                    break;
                }
                default: {
                    if (!this.silent) {
                        System.err.println("auth option must be 'BASIC' or 'WINSSO' if given");
                    }
                    return false;
                }
            }
        }
        try {
            int n = Integer.parseInt(this.options.getValue(PORT));
        }
        catch (Exception exception) {
            if (!this.silent) {
                System.err.println("port must be an integer !");
            }
            return false;
        }
        if (!(this.options.isSet(USER) || this.options.isSet(JID) || auth.equals(WINSSO))) {
            if (!this.silent) {
                System.err.println("Either user or jid option must be given !");
            }
            return false;
        }
        if (this.options.isSet(USER) && !this.options.isSet(PASS) && !auth.equals(WINSSO)) {
            if (!this.silent) {
                System.err.println("user option requires pass option !");
            }
            return false;
        }
        if (this.options.isSet(USER) && this.options.isSet(KEY)) {
            if (!this.silent) {
                System.err.println("user option and key option not compatible !");
            }
            return false;
        }
        if (!this.options.isSet(USER) && this.options.isSet(JID) && !this.options.isSet(KEY)) {
            if (!this.silent) {
                System.err.println("jid option without user option requires key option !");
            }
            return false;
        }
        if (this.options.isSet(JID)) {
            try {
                long l = Long.parseLong(this.options.getValue(JID));
            }
            catch (Exception exception) {
                if (!this.silent) {
                    System.err.println("jid must be a (long)integer !");
                }
                return false;
            }
        }
        if (this.canRetry()) {
            if (this.options.isSet(TIMEOUT)) {
                try {
                    int n = Integer.parseInt(this.options.getValue(TIMEOUT));
                }
                catch (Exception exception) {
                    if (!this.silent) {
                        System.err.println("timeout must be an integer !");
                    }
                    return false;
                }
            }
            try {
                int n = Integer.parseInt(this.options.getValue(CYCLE));
                if (n < 1) {
                    if (!this.silent) {
                        System.err.println("cycle must be >= 1 !");
                    }
                    return false;
                }
            }
            catch (Exception exception) {
                if (!this.silent) {
                    System.err.println("cycle must be an integer !");
                }
                return false;
            }
        }
        if (this.silent && this.verbose) {
            System.err.println("silent and verbose options cannot be used together !");
            return false;
        }
        if (this.options.isSet(KEYSTORE)) {
            String string = this.options.getValue(KEYSTORE);
            if (string == null) {
                string = System.getProperty("javax.net.ssl.keyStore");
            }
            if (string != null) {
                System.setProperty("javax.net.ssl.keyStore", string);
            }
        }
        if (this.options.isSet(TRUSTSTORE)) {
            String string = this.options.getValue(TRUSTSTORE);
            if (string == null) {
                string = System.getProperty("javax.net.ssl.trustStore");
            }
            if (string != null) {
                System.setProperty("javax.net.ssl.trustStore", string);
            }
        }
        if (this.options.isSet(KEYSTOREPW)) {
            String string = this.options.getValue(KEYSTOREPW);
            if (string == null) {
                string = System.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (string != null) {
                System.setProperty("javax.net.ssl.keyStorePassword", string);
            }
        }
        if (this.options.isSet(TRUSTSTOREPW)) {
            String string = this.options.getValue(TRUSTSTOREPW);
            if (string == null) {
                string = System.getProperty("javax.net.ssl.trustStorePassword");
            }
            if (string != null) {
                System.setProperty("javax.net.ssl.trustStorePassword", string);
            }
        }
        return true;
    }

    public void addOptions() {
    }

    public int go() throws RetryException {
        return 0;
    }

    public String getName() {
        return "?";
    }

    public String getUsageArguments() {
        return "";
    }

    public boolean validateOptions() {
        return true;
    }

    public boolean canRetry() {
        return false;
    }

    public boolean userOnly() {
        return false;
    }

    public boolean specificParse() {
        return true;
    }

    public void render(SDMSOutput sDMSOutput) throws SDMSException {
    }

    public boolean setupApp() {
        return true;
    }

    private String getUsage() {
        return "\nusage: " + this.getName() + " { options } " + this.getUsageArguments() + "\n\noptions are:\n" + this.options.list();
    }

    public boolean isRetryError(String string) {
        return string.equals("Desktop-0001") || string.equals("Desktop-0002") || string.equals("Desktop-0003") || string.equals("Desktop-0004") || string.equals("03202081740") || string.equals("03202081739");
    }

    private boolean connect() throws RetryException {
        int n = Integer.parseInt(this.options.getValue(PORT));
        if (this.options.isSet(USER)) {
            this.serverConnection = new SDMSServerConnection(this.options);
        } else {
            userName = this.options.getValue(JID);
            this.serverConnection = new SDMSServerConnection(this.options.getValue(HOST), n, this.options.getValue(JID), this.options.getValue(KEY), 0, this.options.isSet(TLS) ? this.options.getOption(TLS).getBValue() : false);
        }
        try {
            SDMSOutput sDMSOutput = this.serverConnection.connect(this.options);
            if (sDMSOutput.error != null) {
                if (!this.silent) {
                    System.err.println("Connect Error: " + sDMSOutput.error.code + ", " + sDMSOutput.error.message);
                }
                if (this.isRetryError(sDMSOutput.error.code)) {
                    throw new RetryException();
                }
                return false;
            }
            if (!this.silent) {
                this.render(sDMSOutput);
            }
        }
        catch (IOException iOException) {
            if (!this.silent) {
                System.err.println("Connect Error: " + iOException.toString());
            }
            throw new RetryException();
        }
        catch (SDMSException sDMSException) {
            if (!this.silent) {
                System.err.println("Render Error: " + sDMSException.toString());
            }
            throw new RetryException();
        }
        return true;
    }

    public SDMSOutput execute(String string) throws RetryException {
        if (this.verbose) {
            System.err.println("Executing command:\n" + string);
        }
        SDMSOutput sDMSOutput = this.serverConnection.execute(string);
        if (sDMSOutput.error != null) {
            if (this.isRetryError(sDMSOutput.error.code)) {
                if (this.canRetry() && this.verbose) {
                    this.printError(sDMSOutput.error, "RETRY");
                }
                throw new RetryException();
            }
        } else if (this.verbose && !this.silent) {
            System.err.println("Feedback: " + sDMSOutput.feedback);
        }
        return sDMSOutput;
    }

    public void printError(SDMSOutputError sDMSOutputError) {
        this.printError(sDMSOutputError, "ERROR");
    }

    public void printError(SDMSOutputError sDMSOutputError, String string) {
        if (!this.silent) {
            System.err.println(string + ":" + sDMSOutputError.code + "," + sDMSOutputError.message);
        }
    }

    private int doTry() throws RetryException {
        int n = 1;
        if (this.connect()) {
            n = this.go();
            try {
                this.serverConnection.finish();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    private int reTry() {
        long l = 0L;
        int n = 0;
        int n2 = 0;
        if (this.canRetry()) {
            if (this.options.isSet(TIMEOUT)) {
                l = new Date().getTime();
                try {
                    n2 = Integer.parseInt(this.options.getValue(TIMEOUT));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                n = Integer.parseInt(this.options.getValue(CYCLE));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.executions = 0;
        boolean bl = true;
        while (bl) {
            ++this.executions;
            bl = false;
            try {
                return this.doTry();
            }
            catch (RetryException retryException) {
                long l2;
                if (!this.canRetry()) continue;
                bl = true;
                if (this.options.isSet(TIMEOUT) && (l2 = new Date().getTime()) > l + (long)(n2 * 60 * 1000)) {
                    if (!this.silent) {
                        System.err.println("Timeout reached !");
                    }
                    bl = false;
                }
                if (!bl) continue;
                try {
                    Thread.sleep(n * 60 * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return 1;
    }

    public int run(String[] stringArray) {
        String string;
        String[] stringArray2 = null;
        this.options = new Options();
        this.addStandardOptions();
        this.addOptions();
        this.options.parse(stringArray);
        if (this.options.isSet(KEY)) {
            stringArray2 = new String[]{this.options.getOption((String)USER).iniopt, this.options.getOption((String)PASS).iniopt};
        }
        if (this.options.isSet(INI)) {
            string = this.options.getValue(INI);
            this.options.evaluateInifile(string, false, stringArray2);
        }
        if ((string = System.getenv("HOME")) != null) {
            this.options.evaluateInifile(string + "/.sdmshrc", true, stringArray2);
        }
        if ((string = System.getenv("BICSUITECONFIG")) != null) {
            this.options.evaluateInifile(string + "/sdmshrc", true, stringArray2);
        } else {
            string = System.getenv("BICSUITEHOME");
            if (string == null) {
                if (!this.silent) {
                    System.err.println("BICSUITEHOME is not set");
                }
                return 1;
            }
            this.options.evaluateInifile(string + "/etc/sdmshrc", true, stringArray2);
        }
        this.silent = this.options.getOption((String)SILENT).bvalue;
        this.verbose = this.options.getOption((String)VERBOSE).bvalue;
        if (!this.specificParse()) {
            if (!this.silent) {
                System.err.println(this.getUsage());
            }
            return 1;
        }
        this.silent = this.options.getOption((String)SILENT).bvalue;
        this.verbose = this.options.getOption((String)VERBOSE).bvalue;
        if (this.options.isSet(HELP) && this.options.getOption((String)HELP).bvalue) {
            System.out.println(this.getUsage());
            return 0;
        }
        if (!this.options.validate()) {
            if (!this.silent) {
                System.err.println(this.getUsage());
            }
            return 1;
        }
        if (!this.validateStandardOptions()) {
            if (!this.silent) {
                System.err.println(this.getUsage());
            }
            return 1;
        }
        if (!this.validateOptions()) {
            if (!this.silent) {
                System.err.println(this.getUsage());
            }
            return 1;
        }
        if (!this.setupApp()) {
            if (!this.silent) {
                System.err.println("An error occurred while initializing application");
            }
            return 1;
        }
        int n = this.reTry();
        return n;
    }

    public static void main(String[] stringArray) {
        System.exit(new App().run(stringArray));
    }

    static {
        userName = "UNKNOWN";
        auth = BASIC;
    }
}

