/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.SDMSApp;

import de.independit.scheduler.SDMSApp.Option;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class Options {
    public static final String __version = "@(#) $Id: Options.java,v 1.13.4.1 2013/03/14 10:24:03 ronald Exp $";
    static final int OPT_WIDTH = 36;
    int DOC_WIDTH = 43;
    private Vector options = new Vector();
    public Vector rest = new Vector();

    public Options() {
        String string = System.getenv("COLUMNS");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (n < 80) {
                    n = 80;
                }
                this.DOC_WIDTH = n - 1 - 36;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void add(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, String string7) {
        boolean bl2 = false;
        Option option = new Option(string, string2, string3, string4, string5, string6, bl, string7);
        for (int i = 0; i < this.options.size(); ++i) {
            if (!((Option)this.options.elementAt((int)i)).key.equals(string4)) continue;
            this.options.setElementAt(option, i);
            bl2 = true;
        }
        if (!bl2) {
            this.options.add(option);
        }
    }

    public StringBuffer formatDoc(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer(string);
        while (stringBuffer2.length() > this.DOC_WIDTH) {
            int n = stringBuffer2.lastIndexOf(" ", this.DOC_WIDTH);
            stringBuffer.append(stringBuffer2.substring(0, n));
            stringBuffer.append("\n                                   ");
            stringBuffer2.delete(0, n);
        }
        stringBuffer.append(stringBuffer2);
        return stringBuffer;
    }

    public StringBuffer formatIniEntry(Option option) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append(option.iniopt);
        stringBuffer.append(" = ");
        if (option.valuestring != null) {
            stringBuffer.append(option.valuestring);
        } else {
            stringBuffer.append("<true|false>");
        }
        do {
            stringBuffer.append(" ");
        } while (stringBuffer.length() < 36);
        stringBuffer.append(this.formatDoc(option.doc));
        stringBuffer.append("\n");
        return stringBuffer;
    }

    public String list() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = this.options.size();
        for (int i = 0; i < n; ++i) {
            Option option = (Option)this.options.get(i);
            if (option.longopt == null && option.shortopt == null) {
                stringBuffer3.append(this.formatIniEntry(option));
                continue;
            }
            StringBuffer stringBuffer4 = new StringBuffer(option.mandatory ? "  " : "[ ");
            String string = "";
            if (option.isBoolean) {
                string = "[no]";
            }
            if (option.longopt != null) {
                stringBuffer4.append("--");
                stringBuffer4.append(string);
                stringBuffer4.append(option.longopt);
            }
            if (option.shortopt != null) {
                if (option.longopt != null) {
                    stringBuffer4.append("/");
                }
                stringBuffer4.append("-");
                stringBuffer4.append(string);
                stringBuffer4.append(option.shortopt);
            }
            if (option.valuestring != null) {
                stringBuffer4.append(" ");
                stringBuffer4.append(option.valuestring);
            }
            stringBuffer4.append(option.mandatory ? "  " : " ]");
            while (stringBuffer4.length() < 36) {
                stringBuffer4.append(" ");
            }
            stringBuffer.append(stringBuffer4);
            stringBuffer.append(this.formatDoc(option.doc));
            if (option.iniopt != null) {
                stringBuffer.append(" (*)");
                stringBuffer2.append(this.formatIniEntry(option));
            }
            stringBuffer.append("\n");
        }
        if (stringBuffer2.length() + stringBuffer3.length() > 0) {
            if (stringBuffer2.length() > 0) {
                stringBuffer.append("\nThe options marked with (*) can also be specified in a configuration\n");
                stringBuffer.append("file. The following (case sensitive) entries are recognized:\n");
                stringBuffer.append(stringBuffer2);
            }
            if (stringBuffer3.length() > 0) {
                stringBuffer.append("\nThe following configuration entries are only valid in configuration\nfiles:\n");
                stringBuffer.append(stringBuffer3);
            }
            stringBuffer.append("\n");
            stringBuffer.append("The configuration files are evaluated in the following order:\n");
            stringBuffer.append("$BICSUITECONFIG/sdmshrc, $HOME/.sdmshrc and the file specified\n");
            stringBuffer.append("on the commandline.\n");
            stringBuffer.append("The first two files need not exist. If a file is specified, it must exist\n\n");
            stringBuffer.append("Options specified on the commandline take precedence over the same options\n");
            stringBuffer.append("specified in configuration files.\n");
            stringBuffer.append("Options marked mandatory must not occur on the command line, if they are\n");
            stringBuffer.append("specified in a configuration file.\n");
        }
        return stringBuffer.toString();
    }

    public boolean validate() {
        for (Option option : this.options) {
            if (option.mandatory && !option.set) {
                System.err.println("Missing mandatory " + option.longopt + " option !");
                return false;
            }
            if (option.set && option.valuestring != null && option.value == null) {
                System.err.println("Option " + option.longopt + " requires a value !");
                return false;
            }
            if (option.set || option.defaultvalue == null) continue;
            option.set = true;
            option.value = option.defaultvalue;
        }
        return true;
    }

    public Vector getRest() {
        return this.rest;
    }

    public String getValue(String string) {
        for (Option option : this.options) {
            if (!option.key.equals(string)) continue;
            return option.value;
        }
        return null;
    }

    public Option getOption(String string) {
        for (Option option : this.options) {
            if (!option.key.equals(string)) continue;
            return option;
        }
        return null;
    }

    public boolean isSet(String string) {
        for (Option option : this.options) {
            if (!option.key.equals(string)) continue;
            return option.set;
        }
        return false;
    }

    public void evaluateInifile(String string, boolean bl, String[] stringArray) {
        block6: {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                Object var7_8 = null;
                block2: while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (string2.equals(stringArray[i])) continue block2;
                        }
                    }
                    for (Option option : this.options) {
                        if (!string2.equals(option.iniopt) || option.set) continue;
                        option.set = true;
                        option.value = properties.getProperty(string2);
                        if (!option.isBoolean) continue block2;
                        option.bvalue = Boolean.parseBoolean(properties.getProperty(string2));
                        continue block2;
                    }
                }
            }
            catch (IOException iOException) {
                if (bl) break block6;
                System.err.println("FATAL ERROR while processing startupfile " + string);
                System.exit(1);
            }
        }
    }

    public void parse(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            String string = stringArray[i];
            for (Option option : this.options) {
                if (option.isBoolean) {
                    if (string.equals("-" + option.shortopt) || string.equals("--" + option.longopt)) {
                        option.set = true;
                        option.value = "true";
                        option.bvalue = true;
                        bl = true;
                        break;
                    }
                    if (!string.equals("-no" + option.shortopt) && !string.equals("--no" + option.longopt)) continue;
                    option.set = true;
                    option.value = "false";
                    option.bvalue = false;
                    bl = true;
                    break;
                }
                if (!string.equals("-" + option.shortopt) && !string.equals("--" + option.longopt)) continue;
                option.set = true;
                if (++i < stringArray.length) {
                    option.value = stringArray[i];
                }
                bl = true;
                break;
            }
            if (bl) continue;
            this.rest.add(string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Option option : this.options) {
            stringBuffer.append(option.toShortString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("Rest:\n");
        for (int i = 0; i < this.rest.size(); ++i) {
            stringBuffer.append("\t" + this.rest.get(i) + "\n");
        }
        return stringBuffer.toString();
    }
}

