/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler;

import de.independit.scheduler.server.Server;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class TestConfig {
    private static String inifile;
    private static boolean adminMode;
    private static boolean protectMode;
    public static String programLevel;
    private static final String ADMIN_OPTION = "-admin";
    private static final String PROTECT_OPTION = "-protected";
    private static SystemEnvironment env;

    private static void say_hello(String[] stringArray) {
        SDMSThread.doTrace(null, "**************************************************************************", 0);
        try {
            URL uRL = new TestConfig().getClass().getResource("TestConfig.class");
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            Manifest manifest = jarURLConnection.getManifest();
            Map<String, Attributes> map = manifest.getEntries();
            Attributes attributes = manifest.getMainAttributes();
            for (Attributes.Name name : attributes.keySet()) {
                String string = attributes.getValue(name);
                SDMSThread.doTrace(null, name + " : " + string, 0);
            }
            programLevel = attributes.getValue("Level");
        }
        catch (Exception exception) {
            SDMSThread.doTrace(null, exception.toString(), 0);
        }
        SDMSThread.doTrace(null, "**************************************************************************", 0);
        SDMSThread.doTrace(null, "** BICsuite Configuration Test", 0);
        SDMSThread.doTrace(null, "** Version 2.9", 0);
        SDMSThread.doTrace(null, "** Copyright (C) 2015 independIT Integrative Technologies GmbH", 0);
        SDMSThread.doTrace(null, "**************************************************************************", 0);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0) {
                SDMSThread.doTrace(null, "Commandline Start Options:", 0);
            }
            SDMSThread.doTrace(null, "\t" + stringArray[i], 0);
        }
    }

    private static void scan_args(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].toLowerCase().equals(ADMIN_OPTION)) {
                SDMSThread.doTrace(null, "Server will start in admin mode, logins disabled", 0);
                if (bl) {
                    SDMSThread.doTrace(null, "Duplicate option: -admin", 0);
                }
                adminMode = true;
                bl = true;
                continue;
            }
            if (stringArray[i].toLowerCase().equals(PROTECT_OPTION)) {
                SDMSThread.doTrace(null, "Server will start in protected mode, logins and internal threads disabled", 0);
                if (bl2) {
                    SDMSThread.doTrace(null, "Duplicate option: -protected", 0);
                }
                protectMode = true;
                adminMode = true;
                bl2 = true;
                continue;
            }
            if (bl3) {
                SDMSThread.doTrace(null, "Duplicate specification of configurationfile, effective : " + inifile, 0);
                continue;
            }
            inifile = stringArray[i];
            bl3 = true;
        }
        if (!bl3) {
            SDMSThread.doTrace(null, "Missing specification of configurationfile", -2);
        }
    }

    public static void main(String[] stringArray) {
        TestConfig.say_hello(stringArray);
        TestConfig.scan_args(stringArray);
        TestConfig.readConfig(inifile, programLevel);
    }

    public static void readConfig(String string, String string2) {
        String string3;
        Properties properties = new Properties();
        InputStream inputStream = TestConfig.class.getResourceAsStream(string);
        try {
            if (inputStream == null) {
                inputStream = new FileInputStream(string);
            }
            properties.load(inputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            SDMSThread.doTrace(null, "Properties File not found : " + fileNotFoundException, -2);
        }
        catch (IOException iOException) {
            SDMSThread.doTrace(null, "Error loading Properties file: " + iOException, -2);
        }
        Object object = properties.propertyNames();
        while (object.hasMoreElements()) {
            string3 = (String)object.nextElement();
            if (string3.equals("DbPasswd") || string3.equals("SysPasswd") || string3.equals("KeyStorePassword") || string3.equals("TrustStorePassword")) continue;
            SDMSThread.doTrace(null, string3 + "=" + properties.getProperty(string3), 0);
        }
        env = new SystemEnvironment(properties, string2);
        try {
            object = Server.connectToDB(env);
            try {
                string3 = object.getMetaData().getDriverName();
                SDMSThread.doTrace(null, "JDBC Driver Name =" + string3, 0);
            }
            catch (SQLException sQLException) {
                SDMSThread.doTrace(null, "Cannot determine JDBC Driver Name", 1);
            }
            try {
                object.close();
            }
            catch (Exception exception) {}
        }
        catch (SDMSException sDMSException) {
            System.out.println("Connection failed ... :-(");
            System.out.println(sDMSException.toString());
        }
    }

    private TestConfig() {
    }

    static {
        adminMode = false;
        protectMode = false;
        programLevel = null;
    }
}

