/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.jobserver;

import de.independit.scheduler.jobserver.Config;
import de.independit.scheduler.jobserver.Descr;
import de.independit.scheduler.jobserver.EiThread;
import de.independit.scheduler.jobserver.Feil;
import de.independit.scheduler.jobserver.HttpThread;
import de.independit.scheduler.jobserver.Notifier;
import de.independit.scheduler.jobserver.ProcessInfo;
import de.independit.scheduler.jobserver.RepoIface;
import de.independit.scheduler.jobserver.Trace;
import de.independit.scheduler.jobserver.Utils;
import de.independit.scheduler.jobserver.WakeupThread;
import de.independit.scheduler.server.exception.CommonErrorException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class Server {
    public static final String __version = "@(#) $Id: Server.java,v 2.19.2.1 2013/03/14 10:24:07 ronald Exp $";
    private static final String[] FINAL_STATES = new String[]{"FINISHED", "BROKEN_FINISHED", "ERROR", "CHILD_ERROR"};
    private final Config cfg;
    private final RepoIface ri;
    private WakeupThread wecker = null;
    private HttpThread httpserver = null;
    private int fullFullBreed = 0;
    private static HashMap feilMap = null;
    private Vector<String> jidsToBreed;
    private HashSet<String> jidsWithEiThread;
    public static boolean notified = true;
    private HashSet<String> jidsAwaitRunning;
    HashMap<String, Long> startTimes = null;
    private int errorCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJidToBreed(String string) {
        Vector<String> vector = this.jidsToBreed;
        synchronized (vector) {
            this.jidsToBreed.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJidWithEiThread(String string) {
        HashSet<String> hashSet = this.jidsWithEiThread;
        synchronized (hashSet) {
            this.jidsWithEiThread.remove(string);
        }
    }

    public Server(String string) throws CommonErrorException {
        this.cfg = new Config(string);
        this.ri = new RepoIface(this.cfg);
        this.jidsToBreed = new Vector();
        this.jidsWithEiThread = new HashSet();
        this.jidsAwaitRunning = new HashSet();
    }

    public static final String getVersionInfo() {
        return "Jobserver (server) " + Utils.getVersion() + " (" + Utils.getProtocol() + ")\n" + Utils.getCopyright() + " " + Utils.getCompany() + "\nAll rights reserved";
    }

    public static final synchronized Feil getFeil(Config config, String string) {
        Feil feil;
        if (feilMap == null) {
            feilMap = new HashMap();
        }
        if (feilMap.containsKey(string)) {
            feil = (Feil)feilMap.get(string);
        } else {
            feil = new Feil((File)config.get("JOBFILEPREFIX"), string);
            Trace.debug("Adding feil for jid " + string);
            feilMap.put(string, feil);
        }
        return feil;
    }

    public static final synchronized void removeFeil(String string) {
        Trace.debug("Removing feil for jid " + string);
        if (!feilMap.containsKey(string)) {
            return;
        }
        Feil feil = (Feil)feilMap.get(string);
        if (feil.doEmergencyRename) {
            feil.emergency_rename();
        } else {
            feil.remove();
        }
        feilMap.remove(string);
    }

    public static final synchronized boolean feilExists(String string) {
        return feilMap.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] getJobFileIds() {
        File file = (File)this.cfg.get("JOBFILEPREFIX");
        File file2 = file.getParentFile();
        String string = file.getName();
        int n = string.length();
        String[] stringArray = file2.list();
        int n2 = stringArray != null ? stringArray.length : 0;
        this.fullFullBreed = (this.fullFullBreed + 1) % 100;
        Trace.debug("Server:breeding " + (this.fullFullBreed == 0 ? "all files" : "files not in jidsWithEiThread only"));
        Vector<String> vector = new Vector<String>();
        String[] stringArray2 = this.jidsWithEiThread;
        synchronized (this.jidsWithEiThread) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                String string2;
                if (!stringArray[n3].startsWith(string) || stringArray[n3].endsWith("_ERROR") || this.jidsWithEiThread.contains(string2 = stringArray[n3].substring(n)) && this.fullFullBreed != 0) continue;
                vector.add(string2);
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            stringArray2 = new String[vector.size()];
            for (n3 = 0; n3 < vector.size(); ++n3) {
                stringArray2[n3] = (String)vector.get(n3);
            }
            return stringArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doRestart() {
        HashMap<String, Long> hashMap = ProcessInfo.getStartTimes(this.cfg, null);
        String[] stringArray = this.getJobFileIds();
        for (int i = 0; i < stringArray.length; ++i) {
            Feil feil;
            Feil feil2 = feil = Server.getFeil(this.cfg, stringArray[i]);
            synchronized (feil2) {
                try {
                    feil.open();
                }
                catch (IOException iOException) {
                    feil.close();
                    this.ri.notifyError(RepoIface.NONFATAL, "(04301271508) Open() failed on jobfile " + feil.getFilename() + ": " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
                    continue;
                }
                feil.scan();
                if (feil.getIncomplete() && !feil.getComplete()) {
                    Trace.warning("Cleaning up incomplete task file " + feil.getFilename());
                    Server.removeFeil(stringArray[i]);
                    continue;
                }
                if (!feil.getStatus().equals("STARTED") || feil.getExecPid() != null && !feil.getExecPid().equals("") && ProcessInfo.isAlive(feil.getExecPid(), hashMap)) {
                    feil.close();
                    continue;
                }
                switch (this.ri.reassureJob(feil)) {
                    case 1: {
                        feil.close();
                        HashSet<String> hashSet = this.jidsWithEiThread;
                        synchronized (hashSet) {
                            this.jidsWithEiThread.add(stringArray[i]);
                        }
                        new EiThread(this.ri, this.cfg, stringArray[i]).start();
                        break;
                    }
                    case 3: {
                        Server.removeFeil(stringArray[i]);
                        break;
                    }
                    case 2: {
                        feil.close();
                        return false;
                    }
                    default: {
                        Utils.abortProgram(this.ri, "(04301271509) Internal error");
                    }
                }
                continue;
            }
        }
        return true;
    }

    private final void breed() {
        this.startTimes = ProcessInfo.getStartTimes(this.cfg, null);
        String[] stringArray = this.getJobFileIds();
        for (int i = 0; i < stringArray.length; ++i) {
            Trace.debug("Server:breeding jid " + stringArray[i] + " from breed()");
            if (!this.breed(stringArray[i], this.startTimes, true)) continue;
            Trace.message("A BROKEN_FINISHED condition was detected for jid " + stringArray[i]);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.breed(stringArray[i], this.startTimes, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean breed(String string, HashMap<String, Long> hashMap, boolean bl) {
        Feil feil = Server.getFeil(this.cfg, string);
        boolean bl2 = false;
        IOException iOException = null;
        Feil feil2 = feil;
        synchronized (feil2) {
            block49: {
                try {
                    feil.open();
                }
                catch (IOException iOException2) {
                    this.ri.notifyError(RepoIface.NONFATAL, "(03210150800) Cannot open on jobfile " + feil.getFilename() + ": " + iOException2.getMessage() + " (" + iOException2.getClass().getName() + ")");
                    iOException = iOException2;
                }
                try {
                    if (iOException != null) {
                        throw iOException;
                    }
                    if (feil.length() == 0L) {
                        bl2 = true;
                        break block49;
                    }
                    feil.scan();
                    if (feil.getStatus().equals("RUNNING") || feil.getStatus().equals("BROKEN_ACTIVE")) {
                        boolean bl3;
                        boolean bl4 = bl3 = ProcessInfo.isAlive(feil.getExtPid(), hashMap) && ProcessInfo.isAlive(feil.getExecPid(), hashMap);
                        if (!bl3) {
                            Cloneable cloneable = ProcessInfo.getStartTimes(this.cfg, hashMap);
                        }
                    }
                    if (feil.getStatus().equals("RUNNING")) {
                        if (!ProcessInfo.isAlive(feil.getExecPid(), hashMap)) {
                            if (ProcessInfo.isAlive(feil.getExtPid(), hashMap)) {
                                feil.setStatus("BROKEN_ACTIVE");
                            } else {
                                if (bl) {
                                    feil.close();
                                    boolean bl5 = true;
                                    return bl5;
                                }
                                feil.setStatus("BROKEN_FINISHED");
                            }
                        }
                    } else if (feil.getStatus().equals("BROKEN_ACTIVE") && !ProcessInfo.isAlive(feil.getExtPid(), hashMap)) {
                        feil.setStatus("BROKEN_FINISHED");
                    }
                    if (!feil.getStatus().equals(feil.getStatus_Tx())) {
                        feil.close();
                        this.ri.reportState(feil);
                        feil.open();
                        feil.setStatus_Tx(feil.getStatus());
                    }
                    if (!feil.getStatus().equals("STARTED")) {
                        Trace.debug("Server:removing jid " + string + " from jidsAwaitRunning, state = " + feil.getStatus());
                        HashSet<String> hashSet = this.jidsAwaitRunning;
                        synchronized (hashSet) {
                            this.jidsAwaitRunning.remove(string);
                        }
                    }
                    if (Utils.isOneOf(feil.getStatus_Tx(), FINAL_STATES)) {
                        bl2 = true;
                    }
                }
                catch (EOFException eOFException) {
                    this.ri.notifyError(RepoIface.NONFATAL, "(03210150802) Unexpected End of File on jobfile " + feil.getFilename());
                }
                catch (IOException iOException3) {
                    this.ri.notifyError(RepoIface.NONFATAL, "(04302041618) Cannot operate on jobfile " + feil.getFilename() + ": " + iOException3.getMessage() + " (" + iOException3.getClass().getName() + ")");
                }
                finally {
                    if (bl2) {
                        Trace.debug("Server:removing jid " + string + " from jidsAwaitRunning, state = " + feil.getStatus());
                        HashSet<String> hashSet = this.jidsAwaitRunning;
                        synchronized (hashSet) {
                            this.jidsAwaitRunning.remove(string);
                        }
                        Server.removeFeil(string);
                    } else {
                        feil.close();
                    }
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createNewEi(Descr descr) {
        Feil feil = Server.getFeil(this.cfg, descr.id);
        Object object = feil;
        synchronized (object) {
            if (feil.exists()) {
                this.ri.notifyError(RepoIface.NONFATAL, "(04301271511) Job id " + descr.id + " already in process");
                return;
            }
            try {
                feil.create(descr, (Boolean)this.cfg.get("USEPATH"), (Boolean)this.cfg.get("VERBOSELOGS"));
            }
            catch (IOException iOException) {
                Server.removeFeil(descr.id);
                this.ri.notifyError(RepoIface.NONFATAL, "(04301271512) Cannot create job file " + feil.getFilename() + ": " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
                ++this.errorCount;
                Utils.sleep((long)this.errorCount * (Long)this.cfg.get("NOPDELAY"));
                return;
            }
            try {
                this.ri.reportState(feil);
                feil.open();
                feil.setStatus_Tx(feil.getStatus());
            }
            catch (EOFException eOFException) {
                this.ri.notifyError(RepoIface.NONFATAL, "(03210150802) Unexpected End of File on jobfile " + feil.getFilename());
            }
            catch (IOException iOException) {
                this.ri.notifyError(RepoIface.NONFATAL, "(04302041618) Cannot operate on jobfile " + feil.getFilename() + ": " + iOException.getMessage() + " (" + iOException.getClass().getName() + ")");
            }
            finally {
                feil.close();
            }
        }
        Trace.debug("Server:adding jid " + descr.id + " to jidsWithEiThread and jidsAwaitRunning");
        object = this.jidsWithEiThread;
        synchronized (object) {
            this.jidsWithEiThread.add(descr.id);
        }
        object = this.jidsAwaitRunning;
        synchronized (object) {
            this.jidsAwaitRunning.add(descr.id);
        }
        object = new EiThread(this.ri, this.cfg, descr.id, descr.env, descr.dir, descr.jobenv);
        ((Thread)object).start();
        this.errorCount = 0;
    }

    private final void startWakeupThread(Config config) {
        this.wecker = WakeupThread.getInstance(config);
        if (!this.wecker.isAlive()) {
            this.wecker.start();
        }
    }

    private final void startHttpThread(Config config) {
        this.httpserver = HttpThread.getInstance(config);
        if (!this.httpserver.isAlive()) {
            this.httpserver.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runServer() {
        boolean bl = false;
        Long l = new Long(0L);
        Thread thread = Thread.currentThread();
        this.startWakeupThread(this.cfg);
        this.startHttpThread(this.cfg);
        boolean bl2 = this.doRestart();
        long l2 = 0L;
        long l3 = 0L;
        while (bl2) {
            Vector<String> vector;
            boolean bl3 = false;
            Thread.interrupted();
            long l4 = System.currentTimeMillis();
            if (l4 - l2 - 5000L > 0L) {
                vector = this.jidsToBreed;
                synchronized (vector) {
                    this.jidsToBreed.clear();
                }
                Trace.debug("Server:running breed()");
                this.breed();
                l2 = l4;
            }
            vector = new Vector();
            Iterator<String> iterator = this.jidsToBreed;
            synchronized (iterator) {
                vector.addAll(this.jidsToBreed);
                this.jidsToBreed.clear();
            }
            for (String string : vector) {
                Trace.debug("Server:breeding jid " + string + " from jidsToBreed");
                if (!this.breed(string, this.startTimes, true)) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.breed(string, this.startTimes, false);
            }
            vector.clear();
            HashSet<String> object2 = this.jidsAwaitRunning;
            synchronized (object2) {
                vector.addAll(this.jidsAwaitRunning);
            }
            for (String string : vector) {
                Trace.debug("Server:breeding jid " + string + " from jidsAwaitRunning");
                if (!this.breed(string, this.startTimes, true)) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.breed(string, this.startTimes, false);
            }
            long l5 = (Long)this.cfg.get("NOPDELAY");
            if (notified || l4 - l3 - l5 > 0L) {
                notified = false;
                boolean bl4 = true;
                while (bl4) {
                    bl4 = false;
                    l4 = System.currentTimeMillis();
                    switch (this.ri.getNextCmd()) {
                        case 0: {
                            bl3 = true;
                            l3 = l4;
                            break;
                        }
                        case 1: {
                            Descr descr = this.ri.getJobData();
                            Trace.debug("Server:starting job " + descr.id);
                            this.createNewEi(descr);
                            bl4 = true;
                            break;
                        }
                        case 2: {
                            bl2 = false;
                            break;
                        }
                        default: {
                            Utils.abortProgram(this.ri, "(04504112210) Unexpected response");
                        }
                    }
                    if (l4 - l2 - 5000L <= 0L) continue;
                    break;
                }
            } else {
                bl3 = true;
            }
            Vector<String> bl4 = this.jidsToBreed;
            synchronized (bl4) {
                if (this.jidsToBreed.size() > 0) {
                    bl3 = false;
                }
            }
            if (!bl3) continue;
            try {
                Notifier.register(l, thread);
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Notifier.unregister(l);
        }
    }
}

