/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.Server;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RenewTicketThread
extends SDMSThread {
    public static final String __version = "@(#) $Id: RenewTicketThread.java,v 2.10.2.1 2013/03/14 10:24:09 ronald Exp $";
    public SystemEnvironment pSysEnv = null;
    private static final int NR = 888888888;
    private static final int TICKETINTERVAL = 60000;
    private static final int TICKET_TOO_OLD = 3;
    private long lastTicket = 0L;
    private long ticketMinTime = 3000L;
    private boolean postgres = false;
    private String updateString;
    private String selectString;
    private String insertString;
    private String deleteString;
    private String getTicketString;
    private String lockString;
    private String brokenPostgresSelect;
    private PreparedStatement pUpdate;
    private PreparedStatement pSelect;
    private PreparedStatement pGetTicket;
    private PreparedStatement pInsert;
    private PreparedStatement pDelete;
    private PreparedStatement pLock;
    private PreparedStatement pBPSelect;

    public RenewTicketThread(Server server) {
        super("TicketThread");
    }

    @Override
    public int id() {
        return -888888888;
    }

    public void initRenewTicketThread(SystemEnvironment systemEnvironment) throws SDMSException {
        try {
            this.pSysEnv = (SystemEnvironment)systemEnvironment.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new FatalException(new SDMSMessage(this.pSysEnv, "03302061654", "Cannot Clone SystemEnvironment"));
        }
        try {
            this.pSysEnv.dbConnection = Server.connectToDB(this.pSysEnv);
        }
        catch (SDMSException sDMSException) {
            RenewTicketThread.doTrace(null, "Error while unlocking repository (couldn't get database connection)", -1);
            throw sDMSException;
        }
        this.postgres = SystemEnvironment.isPostgreSQL;
        this.updateString = "UPDATE REPOSITORY_LOCK " + (this.postgres ? "SET TICKET = CAST (? AS DECIMAL) WHERE TS = CAST (? AS DECIMAL)" : " SET TICKET = ? WHERE TS = ?");
        this.selectString = "SELECT TICKET FROM REPOSITORY_LOCK " + (this.postgres ? "WHERE TS = CAST (? AS DECIMAL)" : "WHERE TS = ?");
        this.getTicketString = "SELECT TS, TICKET FROM REPOSITORY_LOCK";
        this.insertString = "INSERT INTO REPOSITORY_LOCK ( LOCKID, TS, TICKET ) VALUES ( 1 , ?, ?)";
        this.deleteString = "DELETE FROM REPOSITORY_LOCK";
        this.lockString = "UPDATE REPOSITORY_LOCK SET TS = TS+0";
        this.brokenPostgresSelect = "SELECT COUNT(*) FROM REPOSITORY_LOCK WHERE TS = CAST (? AS DECIMAL)";
    }

    public synchronized boolean checkTicket(SystemEnvironment systemEnvironment) throws SDMSException {
        long l = 0L;
        try {
            this.pSelect = systemEnvironment.dbConnection.prepareStatement(this.selectString);
            this.pSelect.clearParameters();
            if (this.postgres) {
                this.pSelect.setString(1, "" + SystemEnvironment.startTime);
            } else {
                this.pSelect.setLong(1, SystemEnvironment.startTime);
            }
            ResultSet resultSet = this.pSelect.executeQuery();
            while (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            this.pSelect.close();
        }
        catch (SQLException sQLException) {
            RenewTicketThread.doTrace(null, "Error while getting Ticket: " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "03302071708", "Error while getting Ticket"));
        }
        return l != 0L;
    }

    public synchronized void getTicket(SystemEnvironment systemEnvironment) throws SDMSException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            this.pGetTicket = systemEnvironment.dbConnection.prepareStatement(this.getTicketString);
            this.pInsert = systemEnvironment.dbConnection.prepareStatement(this.insertString);
            block8: while (true) {
                try {
                    SDMSThread.doTrace(null, "Acquire repository lock for " + SystemEnvironment.startTime, 0);
                    this.pInsert.clearParameters();
                    this.pInsert.setLong(1, SystemEnvironment.startTime);
                    this.pInsert.setLong(2, System.currentTimeMillis());
                    this.pInsert.executeUpdate();
                    this.pInsert.close();
                }
                catch (SQLException sQLException) {
                    try {
                        systemEnvironment.dbConnection.rollback();
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    SDMSThread.doTrace(null, "Lock Acquisition for " + SystemEnvironment.startTime + " failed", 0);
                    this.lockTicket(systemEnvironment);
                    int n = this.updateTicket(systemEnvironment);
                    if (n != 0) break;
                    ResultSet resultSet = this.pGetTicket.executeQuery();
                    while (resultSet.next()) {
                        l = resultSet.getLong(1);
                        l2 = resultSet.getLong(2);
                    }
                    SDMSThread.doTrace(null, "Ticket values Read: " + l + ", " + l2, 0);
                    if (l == 0L) continue;
                    if (!SystemEnvironment.singleServer) {
                        if (l3 != 0L) {
                            SDMSThread.doTrace(null, "old/new Ticket values : " + l3 + ", " + l2, 0);
                            if (l2 != l3) {
                                l3 = 0L;
                                continue;
                            }
                        } else {
                            systemEnvironment.dbConnection.commit();
                            l3 = l2;
                            long l4 = System.currentTimeMillis() + 180000L;
                            while (true) {
                                if (l4 <= System.currentTimeMillis()) continue block8;
                                try {
                                    RenewTicketThread.sleep(60000L);
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                    this.deleteTicket(systemEnvironment);
                    SDMSThread.doTrace(null, "ticket deleted ..... ", 0);
                    continue;
                }
                break;
            }
            systemEnvironment.dbConnection.commit();
        }
        catch (SQLException sQLException) {
            RenewTicketThread.doTrace(null, "Error while getting Ticket: " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "03302111630", "Error while getting Ticket"));
        }
    }

    private synchronized int lockTicket(SystemEnvironment systemEnvironment) throws SQLException {
        this.pLock = systemEnvironment.dbConnection.prepareStatement(this.lockString);
        this.pLock.clearParameters();
        int n = this.pLock.executeUpdate();
        this.pLock.close();
        return n;
    }

    private synchronized int deleteTicket(SystemEnvironment systemEnvironment) throws SQLException {
        this.pDelete = systemEnvironment.dbConnection.prepareStatement(this.deleteString);
        this.pDelete.clearParameters();
        int n = this.pDelete.executeUpdate();
        this.pDelete.close();
        return n;
    }

    private synchronized int updateTicket(SystemEnvironment systemEnvironment) throws SQLException {
        long l = System.currentTimeMillis();
        this.pUpdate = systemEnvironment.dbConnection.prepareStatement(this.updateString);
        this.pUpdate.clearParameters();
        if (this.postgres) {
            this.pUpdate.setString(1, "" + l);
            this.pUpdate.setString(2, "" + SystemEnvironment.startTime);
        } else {
            this.pUpdate.setLong(1, l);
            this.pUpdate.setLong(2, SystemEnvironment.startTime);
        }
        int n = this.pUpdate.executeUpdate();
        this.pUpdate.close();
        if (this.postgres) {
            this.pBPSelect = systemEnvironment.dbConnection.prepareStatement(this.brokenPostgresSelect);
            this.pBPSelect.setString(1, "" + SystemEnvironment.startTime);
            ResultSet resultSet = this.pBPSelect.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        return n;
    }

    public synchronized void renewTicket(SystemEnvironment systemEnvironment) throws SDMSException {
        long l = System.currentTimeMillis();
        if (l - this.lastTicket < this.ticketMinTime) {
            return;
        }
        this.lastTicket = l;
        try {
            int n = this.updateTicket(systemEnvironment);
            if (n == 0) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03302071040", "Error while setting Ticket (no rows updated)"));
            }
        }
        catch (SQLException sQLException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03302061656", "Error while setting Ticket: " + sQLException.toString()));
        }
    }

    @Override
    public void SDMSrun() {
        if (this.pSysEnv == null) {
            RenewTicketThread.doTrace(null, "Uninitialized Thread. Call to initRenewTicketThread() missing", -2);
        }
        try {
            while (this.run) {
                this.renewTicket(this.pSysEnv);
                try {
                    this.pSysEnv.dbConnection.commit();
                }
                catch (SQLException sQLException) {
                    throw new FatalException(new SDMSMessage(this.pSysEnv, "03302061657", "Error while committing transaction"));
                }
                try {
                    RenewTicketThread.sleep(60000L);
                }
                catch (Exception exception) {}
            }
        }
        catch (SDMSException sDMSException) {
            RenewTicketThread.doTrace(null, "Error occurred : " + sDMSException.toString(), -2);
        }
        try {
            this.pSysEnv.dbConnection.close();
        }
        catch (SQLException sQLException) {
            RenewTicketThread.doTrace(null, "Error while closing connection: " + sQLException.getMessage(), -1);
        }
    }
}

