/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Cleanup;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.DumpComment;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpResource;
import de.independit.scheduler.server.dump.DumpResourceTemplate;
import de.independit.scheduler.server.dump.DumpScheduledEvent;
import de.independit.scheduler.server.dump.DumpTrigger;
import de.independit.scheduler.server.dump.Output;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public abstract class Dump {
    public static final String __version = "@(#) $Id: Dump.java,v 2.14.14.2 2013/03/14 10:24:11 ronald Exp $";
    static final int EXIT_STATE_DEFINITION = 0;
    static final int EXIT_STATE_TRANSLATION_PROFILE = 1;
    static final int EXIT_STATE_MAPPING_PROFILE = 2;
    static final int EXIT_STATE_PROFILE = 3;
    static final int RESOURCE_STATE_DEFINITION = 4;
    static final int RESOURCE_STATE_PROFILE = 5;
    static final int RESOURCE_STATE_MAPPING_PROFILE = 6;
    public static final int GROUP = 7;
    static final int USER = 8;
    public static final int NAMED_RESOURCE = 9;
    static final int NAMED_ENVIRONMENT = 10;
    static final int FOOTPRINT = 11;
    public static final int FOLDER = 12;
    static final int SCHEDULING_ENTITY = 13;
    static final int SCHEDULING_ENTITY_REQUIRED = 14;
    static final int SCHEDULING_ENTITY_CHILDREN = 15;
    static final int SCHEDULING_ENTITY_PARAMETER = 16;
    public static final int SCOPE = 17;
    static final int RESOURCE = 18;
    static final int RESOURCE_TEMPLATE = 18;
    static final int TRIGGER = 19;
    static final int INTERVAL = 20;
    static final int INTERVAL_STRUCTURE = 21;
    public static final int SCHEDULE = 22;
    static final int EVENT = 23;
    static final int SCHEDULED_EVENT = 24;
    static final int GRANT = 25;
    private static final int NUM_OBJECT_TYPE = 26;
    private static final HashMap[] cache = new HashMap[26];
    static final HashMap[] maps = new HashMap[26];
    private static Output out;
    static final String PREFIX = "// dump ";
    static final char NOMAP_START = '\u0000';
    final int dumpType;
    final SDMSProxy sdmsObj;
    public final Long sdmsId;
    final String sdmsName;
    final DumpComment comments = new DumpComment();

    abstract String initialize(SystemEnvironment var1) throws SDMSException;

    abstract void collect(SystemEnvironment var1) throws SDMSException;

    abstract void render(String var1);

    static final Dump getRef(SystemEnvironment systemEnvironment, int n, SDMSProxy sDMSProxy) throws SDMSException {
        HashMap hashMap = cache[n];
        if (hashMap == null) {
            return null;
        }
        return (Dump)hashMap.get(sDMSProxy.getId(systemEnvironment));
    }

    Dump(SystemEnvironment systemEnvironment, int n, SDMSProxy sDMSProxy) throws SDMSException {
        this.dumpType = n;
        this.sdmsObj = sDMSProxy;
        this.sdmsId = sDMSProxy.getId(systemEnvironment);
        this.sdmsName = this.initialize(systemEnvironment);
        if (cache[n] == null) {
            Dump.cache[n] = new HashMap();
        }
        cache[n].put(this.sdmsId, this);
        this.collect(systemEnvironment);
    }

    public static final void clear() {
        for (int i = 0; i < 26; ++i) {
            if (cache[i] != null) {
                cache[i].clear();
            }
            maps[i].clear();
        }
    }

    public static final void addMapping(SystemEnvironment systemEnvironment, Object object, Object object2, int n) throws SDMSException {
        String string;
        String string2;
        switch (n) {
            case 9: {
                SDMSNamedResourceTable.getNamedResource(systemEnvironment, (Vector)object);
                string2 = Dump.quotedPath((Vector)object);
                string = Dump.quotedPath((Vector)object2);
                break;
            }
            case 12: {
                SDMSFolderTable.getFolder(systemEnvironment, (Vector)object);
                string2 = Dump.quotedPath((Vector)object);
                string = Dump.quotedPath((Vector)object2);
                break;
            }
            case 17: {
                SDMSScopeTable.getScope(systemEnvironment, (Vector)object);
                string2 = Dump.quotedPath((Vector)object);
                string = Dump.quotedPath((Vector)object2);
                break;
            }
            case 22: {
                SDMSScheduleTable.getSchedule(systemEnvironment, (Vector)object);
                string2 = Dump.quotedPath((Vector)object);
                string = Dump.quotedPath((Vector)object2);
                break;
            }
            case 7: {
                String string3 = string2 = Dump.quotedName(SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)object)), new Long(0L))).getId(systemEnvironment), (String)object);
                if (object2 != null) {
                    try {
                        string3 = Dump.quotedName(SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)object2)), new Long(0L))).getId(systemEnvironment), (String)object2);
                    }
                    catch (NotFoundException notFoundException) {
                        string3 = Dump.quotedString((String)object2);
                    }
                }
                string = string3;
                break;
            }
            default: {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04404010156", "unexpected mapping type: $1", (Object)new Integer(n)));
            }
        }
        maps[n].put(string2, string);
    }

    static final String quotedPath(Vector vector) {
        String string = vector.get(0).toString();
        int n = vector.size();
        for (int i = 1; i < n; ++i) {
            string = string + "." + Dump.quotedString((String)vector.get(i));
        }
        return string;
    }

    static final void print(char c) {
        out.print(Character.toString(c));
    }

    static final void print(String string) {
        out.print(string);
    }

    static final void println() {
        out.print("\n");
    }

    static final void println(char c) {
        out.print(c + "\n");
    }

    static final void println(String string) {
        out.print(string + "\n");
    }

    static final boolean isSystemObject(Long l) {
        long l2 = l;
        return l2 >= 0L && l2 < 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void render(SystemEnvironment systemEnvironment, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, HashSet hashSet, boolean bl5, boolean bl6, HashMap hashMap) throws SDMSException {
        Vector vector = new Vector(26);
        for (int i = 0; i < 26; ++i) {
            Vector vector2 = cache[i] == null ? new Vector() : new Vector(cache[i].values());
            Collections.sort(vector2, Compare.DumpObjects);
            vector.add(vector2);
        }
        out = new Output(string);
        out.open(systemEnvironment);
        try {
            Dump.println("// dump 2.9");
            if (bl) {
                Dump.println();
                Dump.println("begin_multicommand");
            }
            Dump.render(vector, bl2, bl3, bl4, hashSet);
            if (bl5) {
                new Cleanup(systemEnvironment, bl6, hashSet == null ? new HashSet() : hashSet, vector, hashMap).cleanup();
            }
            if (bl) {
                Dump.println();
                Dump.println("end_multicommand;");
            }
        }
        finally {
            out.close();
        }
    }

    private static final void render(Vector vector, boolean bl, boolean bl2, boolean bl3, HashSet hashSet) {
        for (int i = 0; i < 26; ++i) {
            if (i == 25 && !bl2 || i == 18 && !bl3) continue;
            Vector vector2 = (Vector)vector.get(i);
            int n = vector2.size();
            for (int j = 0; j < n; ++j) {
                Dump dump = (Dump)vector2.get(j);
                if (!Dump.toRender(dump, hashSet)) continue;
                boolean bl4 = Dump.isSystemObject(dump.sdmsId);
                Dump.println();
                if (bl4 && (i == 12 || i == 17)) {
                    dump.render("alter");
                } else {
                    if (bl4) {
                        Dump.print("/* ");
                    }
                    dump.render("create or alter");
                    if (bl4) {
                        Dump.println(" */");
                    }
                }
                if (!bl || i == 14 || i == 15 || i == 16 || i == 21) continue;
                dump.comments.render("create or alter");
            }
        }
    }

    private static final boolean toRender(Dump dump, HashSet hashSet) {
        Object object;
        int n = dump.dumpType;
        if (n == 25) {
            object = (DumpGrant)dump;
            if (!maps[7].isEmpty() && !maps[7].containsKey(((DumpGrant)object).group)) {
                return false;
            }
            if (hashSet != null) {
                return Dump.toRender(((DumpGrant)object).objectId, hashSet);
            }
        }
        if (hashSet == null) {
            return true;
        }
        switch (n) {
            case 18: {
                Long l;
                if (dump instanceof DumpResource) {
                    DumpResource dumpResource = (DumpResource)dump;
                    object = dumpResource.nrId;
                    l = dumpResource.scopeId;
                } else {
                    DumpResourceTemplate dumpResourceTemplate = (DumpResourceTemplate)dump;
                    object = dumpResourceTemplate.nrId;
                    l = dumpResourceTemplate.seId;
                }
                return Dump.toRender((Long)object, hashSet) && Dump.toRender(l, hashSet);
            }
            case 19: {
                DumpTrigger dumpTrigger = (DumpTrigger)dump;
                return hashSet.contains(dump.sdmsId) && Dump.toRender(dumpTrigger.fireId, hashSet);
            }
            case 24: {
                DumpScheduledEvent dumpScheduledEvent = (DumpScheduledEvent)dump;
                return Dump.toRender(dumpScheduledEvent.sceId, hashSet) && Dump.toRender(dumpScheduledEvent.evtId, hashSet);
            }
        }
        return hashSet.contains(dump.sdmsId);
    }

    private static final boolean toRender(Long l, HashSet hashSet) {
        for (int i = 0; i < 26; ++i) {
            if (cache[i] == null || !cache[i].containsKey(l)) continue;
            Dump dump = (Dump)cache[i].get(l);
            return Dump.toRender(dump, hashSet);
        }
        return false;
    }

    public final String getName() {
        return this.sdmsName;
    }

    public static final String quotedString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
            switch (stringBuffer.charAt(i)) {
                case '\'': 
                case '\\': {
                    stringBuffer.insert(i, '\\');
                }
            }
        }
        stringBuffer.insert(0, '\'');
        stringBuffer.append('\'');
        return new String(stringBuffer);
    }

    public static final String quotedName(Long l, String string) {
        return Dump.isSystemObject(l) ? string.toUpperCase() : Dump.quotedString(string);
    }

    static final String intervalText(Integer n, String string) {
        return (n.toString() + ' ' + string).toLowerCase();
    }

    public static final String join(String string, Vector vector) {
        if (vector == null) {
            return null;
        }
        if (vector.isEmpty()) {
            return "";
        }
        int n = vector.size();
        String string2 = vector.get(0).toString();
        for (int i = 1; i < n; ++i) {
            string2 = string2 + string + vector.get(i).toString();
        }
        return string2;
    }

    static final String renderList(Vector vector) {
        if (vector.isEmpty()) {
            return "none";
        }
        int n = vector.size();
        Vector vector2 = new Vector(n);
        for (int i = 0; i < n; ++i) {
            Object e = vector.get(i);
            if (e instanceof String) {
                vector2.add(e);
                continue;
            }
            vector2.add(Dump.join("\n\t\t\t\t", (Vector)e));
        }
        return "(\n\t\t\t" + Dump.join(",\n\t\t\t", vector2) + ')';
    }

    static {
        for (int i = 0; i < 26; ++i) {
            Dump.maps[i] = new HashMap();
        }
    }
}

