/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.DumpFolderGeneric;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpNamedEnvironment;
import de.independit.scheduler.server.dump.DumpParameters;
import de.independit.scheduler.server.dump.DumpResource;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import java.util.Vector;

public class DumpFolder
extends DumpFolderGeneric {
    public static final String __version = "@(#) $Id: DumpFolder.java,v 2.5.14.1 2013/03/14 10:24:12 ronald Exp $";
    private String envName;
    private Vector parmList;
    private String group;

    public static final DumpFolder loadDump(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getFolder(systemEnvironment, vector);
        DumpFolder dumpFolder = (DumpFolder)DumpFolder.getRef(systemEnvironment, 12, sDMSFolder);
        if (dumpFolder != null) {
            return dumpFolder;
        }
        return new DumpFolder(systemEnvironment, sDMSFolder);
    }

    DumpFolder(SystemEnvironment systemEnvironment, SDMSFolder sDMSFolder) throws SDMSException {
        super(systemEnvironment, sDMSFolder);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = super.initialize(systemEnvironment);
        Long l = this.f.getParentId(systemEnvironment);
        return l == null ? string : DumpFolder.getDumpedName(systemEnvironment, l) + '.' + string;
    }

    private final void collectResources(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, this.fId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSResource sDMSResource = (SDMSResource)vector.get(i);
            Long l = sDMSResource.getId(systemEnvironment);
            DumpResource.getDumpedName(systemEnvironment, l);
        }
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.f.getEnvId(systemEnvironment);
        this.envName = l != null ? DumpNamedEnvironment.getDumpedName(systemEnvironment, l) : "none";
        Long l2 = this.f.getOwnerId(systemEnvironment);
        this.group = DumpGroup.getDumpedName(systemEnvironment, l2);
        this.collectResources(systemEnvironment);
        DumpGrant.getDumpedList(systemEnvironment, this.fId);
        this.parmList = DumpParameters.getList(systemEnvironment, this.fId, this, "folder");
    }

    @Override
    final void render(String string) {
        DumpFolder.println(string + " folder " + this.getName());
        DumpFolder.println("\twith");
        DumpFolder.println("\t\tenvironment = " + this.envName + ',');
        if (this.parmList.isEmpty()) {
            DumpFolder.print("\t\tparameters = none");
        } else {
            DumpFolder.println("\t\tparameters = (");
            DumpFolder.print("\t\t\t" + DumpFolder.join(",\n\t\t\t", this.parmList) + ")");
        }
        DumpFolder.println(",\n\t\tgroup = " + this.group + ';');
    }
}

