/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.dump.DumpEvent;
import de.independit.scheduler.server.dump.DumpFolder;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpInterval;
import de.independit.scheduler.server.dump.DumpNamedEnvironment;
import de.independit.scheduler.server.dump.DumpNamedResource;
import de.independit.scheduler.server.dump.DumpResource;
import de.independit.scheduler.server.dump.DumpSchedule;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.dump.DumpScope;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.repository.SDMSEventProxyGeneric;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSGrant;
import de.independit.scheduler.server.repository.SDMSGrantTable;
import de.independit.scheduler.server.repository.SDMSIntervalProxyGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSScheduleProxyGeneric;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import java.text.DecimalFormat;
import java.util.Vector;

class DumpGrant
extends Dump {
    public static final String __version = "@(#) $Id: DumpGrant.java,v 2.6.14.1 2013/03/14 10:24:12 ronald Exp $";
    private static final DecimalFormat seqfmt = new DecimalFormat("00");
    Long objectId;
    private String type;
    private String name;
    private String[] privs;
    String group;
    SDMSGrant g;
    Long gId;

    static final void getDumpedList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSGrantTable.idx_objectId.getVector(systemEnvironment, l);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSGrant sDMSGrant = (SDMSGrant)vector.get(i);
            new DumpGrant(systemEnvironment, sDMSGrant);
        }
    }

    DumpGrant(SystemEnvironment systemEnvironment, SDMSGrant sDMSGrant) throws SDMSException {
        super(systemEnvironment, 25, sDMSGrant);
    }

    @Override
    String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        int n;
        this.g = (SDMSGrant)this.sdmsObj;
        this.gId = this.sdmsId;
        this.objectId = this.g.getObjectId(systemEnvironment);
        int n2 = this.g.getObjectType(systemEnvironment);
        switch (n2) {
            case 1: {
                n = 10;
                this.type = "environment";
                this.name = DumpNamedEnvironment.getDumpedName(systemEnvironment, this.objectId);
                break;
            }
            case 18: {
                n = 23;
                this.type = "event";
                this.name = DumpEvent.getDumpedName(systemEnvironment, this.objectId);
                break;
            }
            case 6: {
                n = 12;
                this.type = "folder";
                this.name = DumpFolder.getDumpedName(systemEnvironment, this.objectId);
                break;
            }
            case 19: {
                n = 20;
                this.type = "interval";
                this.name = DumpInterval.getDumpedName(systemEnvironment, this.objectId);
                break;
            }
            case 9: {
                n = 13;
                this.type = "job_definition";
                this.name = DumpSchedulingEntity.getDumpedName(systemEnvironment, this.objectId);
                break;
            }
            case 10: {
                n = 9;
                this.type = "named_resource";
                this.name = DumpNamedResource.getDumpedName(systemEnvironment, this.objectId);
                break;
            }
            case 20: {
                n = 22;
                this.type = "schedule";
                this.name = DumpSchedule.getDumpedName(systemEnvironment, this.objectId);
                break;
            }
            case 15: {
                n = 17;
                this.type = "scope";
                this.name = DumpScope.getDumpedName(systemEnvironment, this.objectId);
                break;
            }
            case 21: {
                n = 7;
                this.type = "group";
                this.name = DumpGroup.getDumpedName(systemEnvironment, this.objectId);
                break;
            }
            case 11: {
                n = 18;
                this.type = "resource";
                this.name = DumpResource.getDumpedName(systemEnvironment, this.objectId);
                break;
            }
            default: {
                throw new FatalException(new SDMSMessage(systemEnvironment, "04402181802", "Invalid/unexpected object type: $1", (Object)new Integer(n2)));
            }
        }
        boolean bl = false;
        Long l = null;
        switch (n2) {
            case 18: {
                bl = IntervalUtil.matchesQuotedIdName(this.name);
                if (!bl) break;
                comparable = SDMSEventTable.getObject(systemEnvironment, this.objectId);
                l = ((SDMSEventProxyGeneric)comparable).getSeId(systemEnvironment);
                break;
            }
            case 19: {
                bl = IntervalUtil.matchesQuotedIdName(this.name);
                if (!bl) break;
                comparable = SDMSIntervalTable.getObject(systemEnvironment, this.objectId);
                l = ((SDMSIntervalProxyGeneric)comparable).getSeId(systemEnvironment);
                break;
            }
            case 20: {
                comparable = SDMSScheduleTable.getObject(systemEnvironment, this.objectId);
                bl = IntervalUtil.matchesIdPath(((SDMSScheduleProxyGeneric)comparable).pathVector(systemEnvironment));
                if (!bl) break;
                l = ((SDMSScheduleProxyGeneric)comparable).getSeId(systemEnvironment);
            }
        }
        if (bl && l != null) {
            this.name = this.name + "\n\t\t(" + DumpSchedulingEntity.getDumpedName(systemEnvironment, l) + ')';
        }
        comparable = this.g.getGId(systemEnvironment);
        this.group = DumpGroup.getDumpedName(systemEnvironment, (Long)comparable);
        return seqfmt.format(n) + " " + this.name + " " + (this.group.startsWith("'") ? "~" : "") + this.group;
    }

    @Override
    void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSPrivilege sDMSPrivilege = new SDMSPrivilege();
        Long l = this.g.getPrivs(systemEnvironment);
        sDMSPrivilege.setPriv(systemEnvironment, l);
        this.privs = sDMSPrivilege.asString();
    }

    @Override
    void render(String string) {
        for (int i = 0; i < this.privs.length; ++i) {
            if (i > 0) {
                DumpGrant.println();
            }
            DumpGrant.println("grant " + this.privs[i].toLowerCase());
            DumpGrant.println("\ton " + this.type + " " + this.name);
            DumpGrant.println("\tto " + this.group + ";");
        }
    }
}

