/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpInterval;
import de.independit.scheduler.server.dump.DumpScheduleGeneric;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSSchedule;

class DumpSchedule
extends DumpScheduleGeneric {
    public static final String __version = "@(#) $Id: DumpSchedule.java,v 2.3.14.1 2013/03/14 10:24:14 ronald Exp $";
    String jobDefinition;
    private String ivalName;
    private String group;

    DumpSchedule(SystemEnvironment systemEnvironment, SDMSSchedule sDMSSchedule) throws SDMSException {
        super(systemEnvironment, sDMSSchedule);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = super.initialize(systemEnvironment);
        Long l = this.s.getParentId(systemEnvironment);
        return l == null ? string : DumpSchedule.getDumpedName(systemEnvironment, l) + '.' + string;
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        Long l2 = this.s.getSeId(systemEnvironment);
        if (l2 != null) {
            this.jobDefinition = DumpSchedulingEntity.getDumpedName(systemEnvironment, l2);
            this.comments.setJobDefinition(this.jobDefinition);
        }
        this.ivalName = (l = this.s.getIntId(systemEnvironment)) == null ? "none" : DumpInterval.getDumpedName(systemEnvironment, l);
        Long l3 = this.s.getOwnerId(systemEnvironment);
        this.group = DumpGroup.getDumpedName(systemEnvironment, l3);
        DumpGrant.getDumpedList(systemEnvironment, this.sId);
    }

    @Override
    final void render(String string) {
        DumpSchedule.println(string + " schedule " + this.getName());
        if (this.jobDefinition != null) {
            DumpSchedule.println("\t\t(" + this.jobDefinition + ')');
        }
        DumpSchedule.println("\twith");
        DumpSchedule.println("\t\tinterval = " + this.ivalName + ',');
        DumpSchedule.println("\t\tgroup = " + this.group + ';');
    }
}

