/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.dump.DumpExitStateDefinition;
import de.independit.scheduler.server.dump.DumpSchedulingEntity;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Collections;
import java.util.Vector;

class DumpSchedulingEntityRequired
extends Dump {
    public static final String __version = "@(#) $Id: DumpSchedulingEntityRequired.java,v 2.7.14.1 2013/03/14 10:24:15 ronald Exp $";
    private Vector ddList;
    private Long seId;
    private Vector requiredDefs;
    private SDMSDependencyDefinition dd;
    private Long ddId;
    private Vector reqDef;

    static final boolean getDumpedList(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, l).isEmpty()) {
            return false;
        }
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
        new DumpSchedulingEntityRequired(systemEnvironment, sDMSSchedulingEntity);
        return true;
    }

    DumpSchedulingEntityRequired(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        super(systemEnvironment, 14, sDMSSchedulingEntity);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        this.seId = this.sdmsId;
        this.ddList = SDMSDependencyDefinitionTable.idx_seDependentId.getVector(systemEnvironment, this.seId);
        return DumpSchedulingEntity.getDumpedName(systemEnvironment, this.seId);
    }

    private final void loadRequiredName(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.dd.getSeRequiredId(systemEnvironment);
        this.reqDef.add(DumpSchedulingEntity.getDumpedName(systemEnvironment, l));
    }

    private final void loadDependencyName(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.dd.getName(systemEnvironment);
        if (string != null) {
            this.reqDef.add("dependency " + DumpSchedulingEntityRequired.quotedName(this.ddId, string));
        }
    }

    private final void loadUnresolvedHandling(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.dd.getUnresolvedHandlingAsString(systemEnvironment);
        this.reqDef.add("unresolved = " + string.toLowerCase());
    }

    private final void loadMode(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.dd.getModeAsString(systemEnvironment);
        this.reqDef.add("mode = " + string.toLowerCase());
    }

    private final void loadCondition(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = this.dd.getCondition(systemEnvironment);
        if (string != null) {
            this.reqDef.add("condition = " + DumpSchedulingEntityRequired.quotedString(string));
        } else {
            this.reqDef.add("condition = none");
        }
    }

    private final void loadStates(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, this.ddId);
        if (vector.isEmpty()) {
            this.reqDef.add("states = none");
        } else {
            int n = vector.size();
            Vector<String> vector2 = new Vector<String>(n);
            for (int i = 0; i < n; ++i) {
                SDMSDependencyState sDMSDependencyState = (SDMSDependencyState)vector.get(i);
                Long l = sDMSDependencyState.getEsdId(systemEnvironment);
                String string = sDMSDependencyState.getCondition(systemEnvironment);
                if (string != null) {
                    vector2.add(DumpExitStateDefinition.getDumpedName(systemEnvironment, l) + " condition = " + DumpSchedulingEntityRequired.quotedString(string));
                    continue;
                }
                vector2.add(DumpExitStateDefinition.getDumpedName(systemEnvironment, l));
            }
            Collections.sort(vector2, Compare.ObjectNames);
            this.reqDef.add(vector2);
        }
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        int n = this.ddList.size();
        this.requiredDefs = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.dd = (SDMSDependencyDefinition)this.ddList.get(i);
            this.ddId = this.dd.getId(systemEnvironment);
            this.reqDef = new Vector();
            this.loadRequiredName(systemEnvironment);
            this.loadDependencyName(systemEnvironment);
            this.loadUnresolvedHandling(systemEnvironment);
            this.loadMode(systemEnvironment);
            this.loadCondition(systemEnvironment);
            this.loadStates(systemEnvironment);
            this.requiredDefs.add(this.reqDef);
        }
        Collections.sort(this.requiredDefs, Compare.Lexically_Vect0);
    }

    @Override
    final void render(String string) {
        int n = this.requiredDefs.size();
        Vector<String> vector = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            Vector vector2 = (Vector)this.requiredDefs.get(i);
            Object e = vector2.get(n2 = vector2.size() - 1);
            if (e instanceof Vector) {
                vector2.set(n2, "states = (\n\t\t\t\t\t" + DumpSchedulingEntityRequired.join(",\n\t\t\t\t\t", (Vector)e) + ')');
            }
            vector.add(DumpSchedulingEntityRequired.join("\n\t\t\t\t", vector2));
        }
        DumpSchedulingEntityRequired.println("alter job_definition " + this.getName());
        DumpSchedulingEntityRequired.println("\twith");
        DumpSchedulingEntityRequired.println("\t\trequired = (");
        DumpSchedulingEntityRequired.println("\t\t\t" + DumpSchedulingEntityRequired.join(",\n\t\t\t", vector) + ");");
    }
}

