/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.locking;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.DeadlockException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.NotMyDeadlockException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.locking.ObjectLock;
import de.independit.scheduler.server.locking.SyncLock;
import de.independit.scheduler.server.repository.SDMSIndexBucket;
import de.independit.scheduler.server.repository.SDMSIndexMap;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSVersions;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class LockingSystemSynchronized {
    private static HashMap<SDMSThread, HashMap<Object, ObjectLock>> threads = new HashMap();
    private static HashMap<Object, ObjectLock> objectLocks = new HashMap();
    private static HashMap<SDMSThread, ObjectLock> waits = new HashMap();

    public static synchronized boolean isWait(SDMSThread sDMSThread) {
        return waits.get(sDMSThread) != null;
    }

    public static synchronized String waitInfo(SDMSThread sDMSThread) {
        ObjectLock objectLock = waits.get(sDMSThread);
        if (objectLock == null) {
            return "";
        }
        return objectLock.objectToShortString();
    }

    protected static synchronized Vector<ObjectLock> release(SystemEnvironment systemEnvironment) throws FatalException {
        HashMap<Object, ObjectLock> hashMap = threads.get(systemEnvironment.thread);
        if (hashMap == null) {
            return null;
        }
        Iterator<ObjectLock> iterator = hashMap.values().iterator();
        Vector<ObjectLock> vector = null;
        String string = null;
        String string2 = null;
        if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_RELEASE)) != 0) {
            string = Thread.currentThread().getName() + ":Release:";
            string2 = "";
        }
        while (iterator.hasNext()) {
            Vector<ObjectLock> vector2;
            ObjectLock objectLock = iterator.next();
            if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_RELEASE)) != 0) {
                string = string + string2 + objectLock.objectToShortString();
                string2 = ", ";
            }
            if ((vector2 = LockingSystemSynchronized.releaseLock(systemEnvironment, objectLock, false)) == null) continue;
            if (vector == null) {
                vector = new Vector<ObjectLock>();
            }
            vector.addAll(vector2);
        }
        if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_RELEASE)) != 0) {
            System.out.println(string);
            string = Thread.currentThread().getName() + ": Notify:";
            string2 = "";
            if (vector == null) {
                System.out.println(string + "none");
            } else {
                for (ObjectLock objectLock : vector) {
                    string = string + string2 + objectLock.objectToShortString();
                    string2 = ", ";
                }
                System.out.println(string);
            }
        }
        threads.put(systemEnvironment.thread, null);
        return vector;
    }

    protected static synchronized Vector<ObjectLock> releaseSubTxLocks(SystemEnvironment systemEnvironment, long l) throws FatalException {
        ObjectLock[] objectLockArray = systemEnvironment.tx.subTxLocks.toArray(new ObjectLock[0]);
        Vector<ObjectLock> vector = null;
        String string = null;
        String string2 = null;
        if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_RELEASE)) != 0) {
            string = Thread.currentThread().getName() + ":releaseSubTxLocks:";
            string2 = "";
        }
        for (int i = 0; i < objectLockArray.length; ++i) {
            Vector<ObjectLock> vector2;
            ObjectLock objectLock = objectLockArray[i];
            if (objectLock.createCp <= l) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03511100813", "bad lock in subTxLocks with createCp (" + objectLock.createCp + ") <= checkPoint (" + l + "):" + objectLock.objectToShortString()));
            }
            if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_RELEASE)) != 0) {
                string = string + string2 + objectLock.objectToShortString();
                string2 = ", ";
            }
            if ((vector2 = LockingSystemSynchronized.releaseLock(systemEnvironment, objectLock, true)) == null) continue;
            if (vector == null) {
                vector = new Vector<ObjectLock>();
            }
            vector.addAll(vector2);
        }
        return vector;
    }

    private static synchronized void removeLockFromSubTxStack(SystemEnvironment systemEnvironment, ObjectLock objectLock) {
        block1: {
            HashSet hashSet;
            if (systemEnvironment.tx.subTxLocks == null || systemEnvironment.tx.subTxLocks.remove(objectLock)) break block1;
            Iterator iterator = systemEnvironment.tx.lockStack.iterator();
            while (iterator.hasNext() && ((hashSet = (HashSet)iterator.next()) == null || !hashSet.remove(objectLock))) {
            }
        }
    }

    protected static synchronized Vector<ObjectLock> release(SystemEnvironment systemEnvironment, Object object) throws FatalException {
        ObjectLock objectLock = LockingSystemSynchronized.getLockForThread(systemEnvironment.thread, object);
        Vector<ObjectLock> vector = null;
        if (objectLock != null) {
            vector = LockingSystemSynchronized.releaseLock(systemEnvironment, objectLock, true);
            LockingSystemSynchronized.removeLockFromSubTxStack(systemEnvironment, objectLock);
        }
        return vector;
    }

    protected static synchronized Vector<ObjectLock> releaseToCheckPoint(SystemEnvironment systemEnvironment, Object object, long l) throws FatalException {
        ObjectLock objectLock = LockingSystemSynchronized.getLockForThread(systemEnvironment.thread, object);
        Vector<ObjectLock> vector = null;
        if (objectLock != null) {
            if (objectLock.createCp <= l) {
                return null;
            }
            vector = LockingSystemSynchronized.releaseLock(systemEnvironment, objectLock, true);
            LockingSystemSynchronized.removeLockFromSubTxStack(systemEnvironment, objectLock);
        }
        return vector;
    }

    protected static synchronized void resetWait(SDMSThread sDMSThread) {
        waits.put(sDMSThread, null);
    }

    public static ObjectLock getLockForThread(SDMSThread sDMSThread, Object object) {
        HashMap<Object, ObjectLock> hashMap = threads.get(sDMSThread);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(object);
    }

    private static void clearLockForThread(SDMSThread sDMSThread, ObjectLock objectLock) {
        HashMap<Object, ObjectLock> hashMap = threads.get(sDMSThread);
        if (hashMap == null) {
            return;
        }
        hashMap.remove(objectLock.object);
        if (hashMap.isEmpty()) {
            threads.put(sDMSThread, null);
        }
    }

    private static void registerLockForThread(SDMSThread sDMSThread, Object object, ObjectLock objectLock) {
        HashMap<Object, ObjectLock> hashMap = threads.get(sDMSThread);
        if (hashMap == null) {
            hashMap = new HashMap();
            threads.put(sDMSThread, hashMap);
        }
        hashMap.put(object, objectLock);
    }

    protected static synchronized ObjectLock getLock(SystemEnvironment systemEnvironment, Object object, int n) throws DeadlockException {
        Object object2;
        if (object == null) {
            throw new RuntimeException();
        }
        ObjectLock objectLock = LockingSystemSynchronized.getLockForThread(systemEnvironment.thread, object);
        boolean bl = false;
        if (objectLock != null) {
            object2 = objectLock;
            while (object2 != null) {
                if (((ObjectLock)object2).wait && !((ObjectLock)object2).notify) {
                    System.out.println("Assertion failed for Thread " + Thread.currentThread().getName());
                    System.out.println("Trying to lock ( mode = " + n + " ) Object:" + objectLock.objectToShortString());
                    System.out.println("Locks held on object " + objectLock.objectToShortString());
                    ObjectLock objectLock2 = objectLocks.get(object);
                    while (objectLock2 != null) {
                        System.out.println("    Thread[" + objectLock2.thread.getName() + "] mode = " + objectLock2.mode + " wait = " + objectLock2.wait);
                        objectLock2 = objectLock2.next;
                    }
                    throw new RuntimeException();
                }
                object2 = ((ObjectLock)object2).prev;
            }
            if (n == 1 && objectLock.mode == 0) {
                if ((LockingSystem.debug & LockingSystem.DEBUG_ALL) != 0) {
                    System.out.println(Thread.currentThread().getName() + ":Lock Escalation on Object[" + ObjectLock.objectToShortString(object) + "]");
                }
                if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_STACK_TRACES)) != 0) {
                    System.out.println("Lock Escalation Start Stacktrace on " + objectLock.objectToShortString() + ":\n" + objectLock.stackTrace + "Lock Escalation End Stacktrace:\n");
                }
                objectLock.mode = 1;
                objectLock.escalated = true;
                object2 = objectLock;
                while (((ObjectLock)object2).next != null) {
                    if (((ObjectLock)object2).next.mode == 1) {
                        if (!((ObjectLock)object2).next.escalated) break;
                        if ((LockingSystem.debug & LockingSystem.DEBUG_ALL) != 0) {
                            System.out.println(Thread.currentThread().getName() + ":Escalate Deadlock Detected on Object[" + ObjectLock.objectToShortString(object) + "]");
                        }
                        bl = true;
                        break;
                    }
                    if (((ObjectLock)object2).next.wait && !((ObjectLock)object2).next.notify) {
                        throw new RuntimeException();
                    }
                    object2 = ((ObjectLock)object2).next;
                }
                if (objectLock != object2) {
                    if (objectLock.prev != null) {
                        objectLock.prev.next = objectLock.next;
                    } else {
                        objectLocks.put(object, objectLock.next);
                    }
                    objectLock.next.prev = objectLock.prev;
                    objectLock.prev = object2;
                    objectLock.next = ((ObjectLock)object2).next;
                    ((ObjectLock)object2).next = objectLock;
                    if (objectLock.next != null) {
                        objectLock.next.prev = objectLock;
                    }
                }
                if (objectLock.prev != null) {
                    objectLock.wait = true;
                }
            }
        } else {
            objectLock = ObjectLock.getObjectLock(systemEnvironment.thread, object, n, systemEnvironment.getLockCp());
            if (systemEnvironment.tx.subTxLocks != null) {
                systemEnvironment.tx.subTxLocks.add(objectLock);
            }
            LockingSystemSynchronized.registerLockForThread(systemEnvironment.thread, object, objectLock);
            object2 = objectLocks.get(object);
            if (object2 == null) {
                objectLocks.put(object, objectLock);
            } else {
                if (n == 1) {
                    objectLock.wait = true;
                }
                Object object3 = object2;
                while (true) {
                    if (((ObjectLock)object3).mode == 1) {
                        objectLock.wait = true;
                    }
                    if (((ObjectLock)object3).next == null) break;
                    object3 = ((ObjectLock)object3).next;
                }
                ((ObjectLock)object3).next = objectLock;
                objectLock.prev = object3;
            }
        }
        if (objectLock.wait) {
            if (objectLock.object == null) {
                throw new RuntimeException();
            }
            waits.put(systemEnvironment.thread, objectLock);
        }
        if ((LockingSystem.debug & LockingSystem.DEBUG_ALL) != 0) {
            System.out.println(Thread.currentThread().getName() + ":getLock() returned " + objectLock.toString());
        }
        if (bl) {
            if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_STACK_TRACES)) != 0) {
                System.out.println("Escalation Deadlock Start Stacktrace on " + objectLock.objectToShortString() + ":\n" + objectLock.stackTrace + "Escalation Deadlock End Stacktrace:\n");
            }
            object2 = ObjectLock.getStackTrace();
            DeadlockException.countAndTraceDeadlock((String)object2);
            throw new DeadlockException();
        }
        return objectLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Vector<ObjectLock> releaseLock(SystemEnvironment systemEnvironment, ObjectLock objectLock, boolean bl) throws FatalException {
        if (!objectLock.releaseAllowed(systemEnvironment)) {
            SDMSThread.doTrace(null, "Invalid attempt to release lock:" + objectLock.objectToShortString() + "\n" + objectLock.getStackTrace(), -2);
            throw new FatalException(new SDMSMessage(systemEnvironment, "03511021603", "Invalid attempt to release lock:" + objectLock.objectToShortString()));
        }
        Vector<ObjectLock> vector = null;
        if (objectLock.next != null && objectLock.next.wait && (objectLock.prev == null || objectLock.prev.mode == 0 && !objectLock.prev.wait && objectLock.next.mode == 0)) {
            ObjectLock objectLock2 = objectLock.next;
            while (objectLock2 != null) {
                if (objectLock2 == objectLock.next || objectLock2.mode != 1) {
                    SyncLock syncLock = objectLock2.syncLock;
                    synchronized (syncLock) {
                        if (objectLock2.wait && !objectLock2.notify) {
                            if (vector == null) {
                                vector = new Vector<ObjectLock>();
                            }
                            objectLock2.notify = true;
                            objectLock2.wait = false;
                            vector.add(objectLock2);
                        }
                    }
                }
                if (objectLock2.mode == 1) break;
                objectLock2 = objectLock2.next;
            }
        }
        if (objectLock.prev == null) {
            if (objectLock.object == null) {
                if (objectLock.freeStackTrace != null) {
                    System.out.println("Lock has been freed at:\n" + objectLock.freeStackTrace);
                    System.out.println("Current Stack Trace:");
                    System.out.println(ObjectLock.getStackTrace());
                }
                throw new RuntimeException();
            }
            objectLocks.put(objectLock.object, objectLock.next);
        } else {
            objectLock.prev.next = objectLock.next;
        }
        if (objectLock.next != null) {
            objectLock.next.prev = objectLock.prev;
        }
        if (bl) {
            LockingSystemSynchronized.clearLockForThread(systemEnvironment.thread, objectLock);
        }
        objectLock.syncLock.freeObjectLock(systemEnvironment);
        return vector;
    }

    public static ObjectLock getObjectLocks(Object object) {
        return objectLocks.get(object);
    }

    protected static synchronized void deadlockDetection(SystemEnvironment systemEnvironment, SDMSThread sDMSThread, HashSet<SDMSThread> hashSet) throws DeadlockException, NotMyDeadlockException {
        ObjectLock objectLock = waits.get(sDMSThread);
        if (objectLock == null) {
            return;
        }
        if (!objectLock.wait) {
            return;
        }
        if (hashSet.contains(sDMSThread)) {
            if (sDMSThread == systemEnvironment.thread) {
                throw new DeadlockException();
            }
            throw new NotMyDeadlockException();
        }
        hashSet.add(sDMSThread);
        LockingSystemSynchronized.deadlockDetection(systemEnvironment, objectLock.object, hashSet);
    }

    private static synchronized void deadlockDetection(SystemEnvironment systemEnvironment, Object object, HashSet<SDMSThread> hashSet) throws DeadlockException, NotMyDeadlockException {
        ObjectLock objectLock = objectLocks.get(object);
        while (objectLock != null && !objectLock.wait) {
            try {
                LockingSystemSynchronized.deadlockDetection(systemEnvironment, objectLock.thread, hashSet);
            }
            catch (DeadlockException deadlockException) {
                if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_DEADLOCK_DETECTION)) != 0) {
                    System.out.println(objectLock.objectToShortString() + " " + objectLock.dumpLockList());
                }
                throw deadlockException;
            }
            catch (NotMyDeadlockException notMyDeadlockException) {
                if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_DEADLOCK_DETECTION)) != 0) {
                    System.out.println(objectLock.objectToShortString() + " " + objectLock.dumpLockList());
                }
                throw notMyDeadlockException;
            }
            objectLock = objectLock.next;
        }
    }

    public static synchronized void checkAndDump() {
        boolean bl = true;
        for (SDMSThread sDMSThread : waits.keySet()) {
            ObjectLock objectLock = waits.get(sDMSThread);
            if (objectLock != null) continue;
            bl = false;
            break;
        }
        if (bl) {
            LockingSystemSynchronized.dump();
        }
    }

    public static synchronized StringBuilder strDump() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder.append("= LockingSystem.dump() ==========================================================");
        stringBuilder.append("\n");
        stringBuilder.append("------- Locks per thread --------------------------------------------------------");
        stringBuilder.append("\n");
        for (SDMSThread object2 : threads.keySet()) {
            Object object3 = threads.get(object2);
            int n = 0;
            if (object3 == null) {
                stringBuilder2.append("    No Locks held");
                stringBuilder2.append("\n");
            } else {
                for (ObjectLock objectLock : ((HashMap)object3).values()) {
                    String string = objectLock.object instanceof SDMSObject ? ((SDMSObject)objectLock.object).toShortString() : (objectLock.object instanceof SDMSVersions ? ((SDMSVersions)objectLock.object).toShortString() : (objectLock.object instanceof SDMSIndexBucket ? ((SDMSIndexBucket)objectLock.object).toShortString() : (objectLock.object instanceof SDMSIndexMap ? ((SDMSIndexMap)objectLock.object).toShortString() : (objectLock.object != null ? objectLock.object.toString() : "Oops! lock.object == null!"))));
                    stringBuilder2.append("    Object[" + string + "] mode = " + objectLock.mode + ", wait = " + objectLock.wait + ", waiting = " + objectLock.waiting + ", escalated=" + objectLock.escalated + ", notify=" + objectLock.notify);
                    stringBuilder2.append("\n");
                    ++n;
                }
            }
            stringBuilder.append("Locks (" + n + ") held by thread " + object2.getName());
            stringBuilder.append("\n");
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder2.setLength(0);
        }
        stringBuilder.append("------- Locks per object --------------------------------------------------------");
        stringBuilder.append("\n");
        for (Object object3 : objectLocks.keySet()) {
            ObjectLock sDMSThread = objectLocks.get(object3);
            if (sDMSThread == null) continue;
            object = sDMSThread.object instanceof SDMSObject ? ((SDMSObject)sDMSThread.object).toShortString() : (sDMSThread.object instanceof SDMSVersions ? ((SDMSVersions)sDMSThread.object).toShortString() : (sDMSThread.object instanceof SDMSIndexBucket ? ((SDMSIndexBucket)sDMSThread.object).toShortString() : (sDMSThread.object instanceof SDMSIndexMap ? ((SDMSIndexMap)sDMSThread.object).toShortString() : (sDMSThread.object != null ? sDMSThread.object.toString() : "Oops! lock.object == null!"))));
            stringBuilder.append("Locks held on object " + (String)object);
            stringBuilder.append("\n");
            while (sDMSThread != null) {
                stringBuilder.append("    Thread[" + sDMSThread.thread.getName() + "] id = " + sDMSThread.id + ", mode = " + sDMSThread.mode + ", wait = " + sDMSThread.wait + ", waiting = " + sDMSThread.waiting + ", escalated=" + sDMSThread.escalated + ", notify=" + sDMSThread.notify);
                stringBuilder.append("\n");
                sDMSThread = sDMSThread.next;
            }
        }
        stringBuilder.append("------- Lock waits --------------------------------------------------------------");
        stringBuilder.append("\n");
        for (SDMSThread sDMSThread : waits.keySet()) {
            ObjectLock objectLock;
            object = "Thread " + sDMSThread.getName() + " waits on ";
            objectLock = waits.get(sDMSThread);
            if (objectLock != null) {
                stringBuilder.append((String)object + objectLock.toString() + "\n" + objectLock.dumpLockList());
            } else {
                stringBuilder.append((String)object + "nothing");
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("=================================================================================");
        stringBuilder.append("\n");
        return stringBuilder;
    }

    public static void dump() {
        System.out.println(LockingSystemSynchronized.strDump());
    }
}

