/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolDistConfig;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigTable;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSPoolDistributionTable;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import java.util.Vector;

public class ActivateDistribution
extends Node {
    public static final String __version = "@(#) $Id: ActivateDistribution.java,v 2.1.14.3 2013/03/20 06:42:56 ronald Exp $";
    private final ObjectURL url;
    private final String name;
    private final boolean ignoreErrors;

    public ActivateDistribution(ObjectURL objectURL, String string, Boolean bl) {
        this.url = objectURL;
        this.name = string;
        this.ignoreErrors = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.checkFeatureAvailability("POOL");
        String string = "Distribution activated";
        try {
            SDMSPool sDMSPool = (SDMSPool)this.url.resolve(systemEnvironment);
            if (this.name.toUpperCase().compareTo("DEFAULT") != 0) {
                SDMSPoolDistribution sDMSPoolDistribution = SDMSPoolDistributionTable.idx_name_pId_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.name), this.url.objId));
                Long l = sDMSPoolDistribution.getId(systemEnvironment);
                sDMSPool.setDistId(systemEnvironment, l);
                Vector vector = SDMSPoolDistConfigTable.idx_pldId.getVector(systemEnvironment, l);
                for (int i = 0; i < vector.size(); ++i) {
                    SDMSPoolDistConfig sDMSPoolDistConfig = (SDMSPoolDistConfig)vector.get(i);
                    SDMSPooledResource sDMSPooledResource = SDMSPooledResourceTable.getObject(systemEnvironment, sDMSPoolDistConfig.getPrId(systemEnvironment));
                    sDMSPooledResource.setActIsManaged(systemEnvironment, sDMSPoolDistConfig.getIsManaged(systemEnvironment));
                    sDMSPooledResource.setActFreePct(systemEnvironment, sDMSPoolDistConfig.getFreePct(systemEnvironment));
                    sDMSPooledResource.setActMinPct(systemEnvironment, sDMSPoolDistConfig.getMinPct(systemEnvironment));
                    sDMSPooledResource.setActMaxPct(systemEnvironment, sDMSPoolDistConfig.getMaxPct(systemEnvironment));
                    sDMSPooledResource.setActNomPct(systemEnvironment, sDMSPoolDistConfig.getNomPct(systemEnvironment));
                }
            } else {
                sDMSPool.setDistId(systemEnvironment, null);
                Vector vector = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, sDMSPool.getId(systemEnvironment));
                for (int i = 0; i < vector.size(); ++i) {
                    SDMSPooledResource sDMSPooledResource = (SDMSPooledResource)vector.get(i);
                    sDMSPooledResource.setActIsManaged(systemEnvironment, sDMSPooledResource.getIsManaged(systemEnvironment));
                    sDMSPooledResource.setActFreePct(systemEnvironment, sDMSPooledResource.getFreePct(systemEnvironment));
                    sDMSPooledResource.setActMinPct(systemEnvironment, sDMSPooledResource.getMinPct(systemEnvironment));
                    sDMSPooledResource.setActMaxPct(systemEnvironment, sDMSPooledResource.getMaxPct(systemEnvironment));
                    sDMSPooledResource.setActNomPct(systemEnvironment, sDMSPooledResource.getNomPct(systemEnvironment));
                }
            }
        }
        catch (SerializationException serializationException) {
            throw serializationException;
        }
        catch (SDMSException sDMSException) {
            if (this.ignoreErrors) {
                string = "No distribution activated";
            }
            throw sDMSException;
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03603221400", string));
    }
}

