/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import java.util.Vector;

public class AlterComment
extends Node {
    public static final String __version = "@(#) $Id: AlterComment.java,v 2.4.12.1 2013/03/14 10:24:19 ronald Exp $";
    private int type;
    private ObjectURL obj;
    private WithHash with;
    private boolean noerr;

    public AlterComment(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.obj = objectURL;
        this.with = withHash;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n;
        String string = null;
        Vector vector = (Vector)this.with.get("TEXT");
        if (vector == null) {
            string = (String)this.with.get("URL");
            n = new Integer(1);
        } else {
            n = new Integer(0);
        }
        if (vector == null && (string == null || string.equals(""))) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03808040831", "Comment cannot be empty. Use the drop command to delete comments"));
        }
        this.obj.resolve(systemEnvironment);
        Vector vector2 = SDMSObjectCommentTable.idx_objectId_getSortedVector(systemEnvironment, this.obj.objId);
        if (vector2.size() == 0) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130114", "No Comment altered"));
                return;
            }
            throw new NotFoundException(new SDMSMessage(systemEnvironment, "03510130956", "Comment not found for object $1", (Object)this.obj.toString()));
        }
        SDMSObjectComment sDMSObjectComment = (SDMSObjectComment)vector2.get(0);
        if (sDMSObjectComment.getInfoType(systemEnvironment) == 1) {
            if (n == 1) {
                sDMSObjectComment.setDescription(systemEnvironment, string);
            } else {
                sDMSObjectComment.delete(systemEnvironment);
                for (int i = 0; i < vector.size(); ++i) {
                    Vector vector3 = (Vector)vector.get(i);
                    String string2 = (String)vector3.get(0);
                    string = (String)vector3.get(1);
                    SDMSObjectCommentTable.table.create(systemEnvironment, this.obj.objId, this.obj.objType, n, new Integer(i + 1), string2, string);
                }
            }
        } else if (n == 1) {
            for (int i = 0; i < vector2.size(); ++i) {
                sDMSObjectComment = (SDMSObjectComment)vector2.get(i);
                sDMSObjectComment.delete(systemEnvironment);
            }
            SDMSObjectCommentTable.table.create(systemEnvironment, this.obj.objId, this.obj.objType, n, new Integer(1), null, string);
        } else {
            String string3;
            Vector vector4;
            int n2;
            for (n2 = 0; n2 < vector2.size() && n2 < vector.size(); ++n2) {
                sDMSObjectComment = (SDMSObjectComment)vector2.get(n2);
                vector4 = (Vector)vector.get(n2);
                string3 = (String)vector4.get(0);
                string = (String)vector4.get(1);
                String string4 = sDMSObjectComment.getTag(systemEnvironment);
                String string5 = sDMSObjectComment.getDescription(systemEnvironment);
                if (string3 == null && string4 != null || string4 == null && string3 != null) {
                    sDMSObjectComment.setTag(systemEnvironment, string3);
                }
                if (string3 != null && string4 != null && !string3.equals(string4)) {
                    sDMSObjectComment.setTag(systemEnvironment, string3);
                }
                if (string.equals(string5)) continue;
                sDMSObjectComment.setDescription(systemEnvironment, string);
            }
            while (n2 < vector2.size()) {
                sDMSObjectComment = (SDMSObjectComment)vector2.get(n2);
                sDMSObjectComment.delete(systemEnvironment);
                ++n2;
            }
            while (n2 < vector.size()) {
                vector4 = (Vector)vector.get(n2);
                string3 = (String)vector4.get(0);
                string = (String)vector4.get(1);
                SDMSObjectCommentTable.table.create(systemEnvironment, this.obj.objId, this.obj.objType, n, new Integer(n2 + 1), string3, string);
                ++n2;
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03209241403", "Comment altered"));
    }
}

