/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolDistConfig;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigTable;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import java.util.HashSet;
import java.util.Vector;

public class AlterDistribution
extends Node {
    public static final String __version = "@(#) $Id: AlterDistribution.java,v 2.2.14.3 2013/03/20 06:42:57 ronald Exp $";
    private final ObjectURL url;
    private final Vector resList;
    private boolean ignoreErrors;
    private static final Integer zero = new Integer(0);

    public AlterDistribution(ObjectURL objectURL, Vector vector, Boolean bl) {
        this.url = objectURL;
        this.resList = vector;
        this.ignoreErrors = bl;
    }

    private void checkAndRepairDist(SystemEnvironment systemEnvironment, SDMSPoolDistribution sDMSPoolDistribution, HashSet hashSet) throws SDMSException {
        SDMSPool sDMSPool = SDMSPoolTable.getObject(systemEnvironment, sDMSPoolDistribution.getPId(systemEnvironment));
        Long l = sDMSPool.getDistId(systemEnvironment);
        Long l2 = sDMSPoolDistribution.getId(systemEnvironment);
        boolean bl = l2.equals(l);
        Long l3 = sDMSPool.getId(systemEnvironment);
        Vector vector = SDMSPoolDistConfigTable.idx_pldId.getVector(systemEnvironment, l2);
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            SDMSPoolDistConfig sDMSPoolDistConfig = (SDMSPoolDistConfig)vector.get(i);
            Long l4 = sDMSPoolDistConfig.getId(systemEnvironment);
            if (!hashSet.contains(l4)) {
                sDMSPoolDistConfig.setIsManaged(systemEnvironment, Boolean.FALSE);
                sDMSPoolDistConfig.setFreePct(systemEnvironment, zero);
                sDMSPoolDistConfig.setMinPct(systemEnvironment, zero);
                sDMSPoolDistConfig.setMaxPct(systemEnvironment, zero);
                sDMSPoolDistConfig.setNomPct(systemEnvironment, zero);
            }
            n += sDMSPoolDistConfig.getNomPct(systemEnvironment).intValue();
            if (!bl) continue;
            SDMSPooledResource sDMSPooledResource = SDMSPooledResourceTable.getObject(systemEnvironment, sDMSPoolDistConfig.getPrId(systemEnvironment));
            sDMSPooledResource.setActFreePct(systemEnvironment, sDMSPoolDistConfig.getFreePct(systemEnvironment));
            sDMSPooledResource.setActNomPct(systemEnvironment, sDMSPoolDistConfig.getNomPct(systemEnvironment));
            sDMSPooledResource.setActMinPct(systemEnvironment, sDMSPoolDistConfig.getMinPct(systemEnvironment));
            sDMSPooledResource.setActMaxPct(systemEnvironment, sDMSPoolDistConfig.getMaxPct(systemEnvironment));
            sDMSPooledResource.setActIsManaged(systemEnvironment, sDMSPoolDistConfig.getIsManaged(systemEnvironment));
        }
        if (n > 100) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221528", "The sum of NOMINALPCT should not be larger than 100%"));
        }
    }

    private Long alterPoolDistConfig(SystemEnvironment systemEnvironment, SDMSPoolDistConfig sDMSPoolDistConfig, WithHash withHash) throws SDMSException {
        Boolean bl = (Boolean)withHash.get("MANAGED");
        Boolean bl2 = sDMSPoolDistConfig.getIsManaged(systemEnvironment);
        if (bl == null) {
            bl = bl2;
        }
        sDMSPoolDistConfig.setIsManaged(systemEnvironment, bl);
        Integer n = (Integer)withHash.get("FREEPCT");
        Integer n2 = (Integer)withHash.get("MINPCT");
        Integer n3 = (Integer)withHash.get("MAXPCT");
        Integer n4 = (Integer)withHash.get("NOMINALPCT");
        if (bl.booleanValue()) {
            if (n == null) {
                n = sDMSPoolDistConfig.getFreePct(systemEnvironment);
            }
            if (n2 == null) {
                n2 = sDMSPoolDistConfig.getMinPct(systemEnvironment);
            }
            if (n3 == null) {
                n3 = sDMSPoolDistConfig.getMaxPct(systemEnvironment);
            }
            if (n4 == null) {
                n4 = sDMSPoolDistConfig.getNomPct(systemEnvironment);
            }
            if (n2 > n4) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221505", "MINPCT should not be larger than NOMINALPCT"));
            }
            if (n4 > n3) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221506", "NOMINALPCT should not be larger than MAXPCT"));
            }
            if (n3 > 100) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221507", "MAXPCT should not exceed 100%"));
            }
        } else {
            n = zero;
            n2 = zero;
            n3 = zero;
            n4 = zero;
        }
        sDMSPoolDistConfig.setFreePct(systemEnvironment, n);
        sDMSPoolDistConfig.setNomPct(systemEnvironment, n4);
        sDMSPoolDistConfig.setMinPct(systemEnvironment, n2);
        sDMSPoolDistConfig.setMaxPct(systemEnvironment, n3);
        return sDMSPoolDistConfig.getId(systemEnvironment);
    }

    private void alterPoolDistConfigs(SystemEnvironment systemEnvironment, SDMSPoolDistribution sDMSPoolDistribution) throws SDMSException {
        HashSet<Long> hashSet = new HashSet<Long>();
        Long l = sDMSPoolDistribution.getId(systemEnvironment);
        for (int i = 0; i < this.resList.size(); ++i) {
            WithHash withHash = (WithHash)this.resList.get(i);
            ObjectURL objectURL = (ObjectURL)withHash.get("RESOURCE");
            if (objectURL == null) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221500", "the pooled resource (or pool) is not specified"));
            }
            SDMSProxy sDMSProxy = objectURL.resolve(systemEnvironment);
            SDMSPooledResource sDMSPooledResource = SDMSPooledResourceTable.idx_pId_rId_getUnique(systemEnvironment, new SDMSKey(sDMSPoolDistribution.getPId(systemEnvironment), objectURL.objId));
            SDMSPoolDistConfig sDMSPoolDistConfig = SDMSPoolDistConfigTable.idx_pldId_prId_getUnique(systemEnvironment, new SDMSKey(l, sDMSPooledResource.getId(systemEnvironment)));
            if (hashSet.add(this.alterPoolDistConfig(systemEnvironment, sDMSPoolDistConfig, withHash))) continue;
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03603221508", "The same pooled resource (or pool) was specified multiple times"));
        }
        this.checkAndRepairDist(systemEnvironment, sDMSPoolDistribution, hashSet);
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "Distribution altered";
        systemEnvironment.checkFeatureAvailability("POOL");
        try {
            SDMSPoolDistribution sDMSPoolDistribution = (SDMSPoolDistribution)this.url.resolve(systemEnvironment);
            this.alterPoolDistConfigs(systemEnvironment, sDMSPoolDistribution);
        }
        catch (NotFoundException notFoundException) {
            if (this.ignoreErrors) {
                string = "No distribution altered";
            }
            throw notFoundException;
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03603201216", string));
    }
}

