/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.EsmMap;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMapping;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class AlterExitStateMapping
extends Node {
    public static final String __version = "@(#) $Id: AlterExitStateMapping.java,v 2.1.14.1 2013/03/14 10:24:20 ronald Exp $";
    private ObjectURL url;
    private Vector maps;
    private boolean noerr;

    public AlterExitStateMapping(ObjectURL objectURL, Vector vector, Boolean bl) {
        this.url = objectURL;
        this.maps = vector;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateMapping sDMSExitStateMapping2;
        SDMSExitStateMappingProfile sDMSExitStateMappingProfile;
        try {
            sDMSExitStateMappingProfile = (SDMSExitStateMappingProfile)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311122355", "No Exit State Mapping altered"));
                return;
            }
            throw notFoundException;
        }
        Vector vector = SDMSExitStateMappingTable.idx_esmpId.getVector(systemEnvironment, sDMSExitStateMappingProfile.getId(systemEnvironment));
        for (SDMSExitStateMapping sDMSExitStateMapping2 : vector) {
            sDMSExitStateMapping2.delete(systemEnvironment);
        }
        SDMSProxy sDMSProxy = null;
        Long l = sDMSExitStateMappingProfile.getId(systemEnvironment);
        int n = 0;
        int n2 = 0;
        for (EsmMap esmMap : this.maps) {
            if (n2 != 0) {
                if (n >= esmMap.from()) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02110260801", "Exit Code $1 out of sequence", (Object)esmMap.from()));
                }
                sDMSExitStateMapping2 = SDMSExitStateMappingTable.table.create(systemEnvironment, l, sDMSProxy.getId(systemEnvironment), new Integer(n), new Integer(esmMap.from() - 1));
            }
            ++n2;
            n = esmMap.from();
            sDMSProxy = SDMSExitStateDefinitionTable.idx_name_getUnique(systemEnvironment, esmMap.name());
        }
        sDMSExitStateMapping2 = SDMSExitStateMappingTable.table.create(systemEnvironment, l, sDMSProxy.getId(systemEnvironment), new Integer(n), new Integer(Integer.MAX_VALUE));
        Vector vector2 = SDMSExitStateProfileTable.idx_defaultEsmpId.getVector(systemEnvironment, l);
        for (SDMSExitStateProfile sDMSExitStateProfile : vector2) {
            sDMSExitStateProfile.validateMappingProfile(systemEnvironment, l);
            try {
                sDMSExitStateProfile.validateMappingProfile(systemEnvironment, l);
            }
            catch (CommonErrorException commonErrorException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112202121", "Default Exit State Mapping not compatible to Exit State Profile $1", (Object)sDMSExitStateProfile.getName(systemEnvironment)));
            }
        }
        Vector vector3 = SDMSSchedulingEntityTable.idx_esmpId.getVector(systemEnvironment, l);
        for (SDMSSchedulingEntity sDMSSchedulingEntity : vector3) {
            SDMSExitStateProfile sDMSExitStateProfile;
            Long l2 = sDMSSchedulingEntity.getEspId(systemEnvironment);
            sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l2);
            try {
                sDMSExitStateProfile.validateMappingProfile(systemEnvironment, l);
            }
            catch (CommonErrorException commonErrorException) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112202120", "Exit State Mapping not compatible to Exit State Profile $1 of Job $2", (Object)sDMSExitStateProfile.getName(systemEnvironment), (Object)sDMSSchedulingEntity.getName(systemEnvironment)));
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112157", "Exit State Mapping altered"));
    }
}

