/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class AlterFootprint
extends Node {
    private ObjectURL url;
    private Vector resources;
    private Boolean add;
    private boolean noerr;

    public AlterFootprint(ObjectURL objectURL, Vector vector, Boolean bl) {
        this.url = objectURL;
        this.resources = vector;
        this.add = null;
        this.noerr = bl;
    }

    public AlterFootprint(ObjectURL objectURL, Vector vector, boolean bl, Boolean bl2) {
        this.url = objectURL;
        this.resources = vector;
        this.add = new Boolean(bl);
        this.noerr = bl2;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFootprint sDMSFootprint;
        try {
            sDMSFootprint = (SDMSFootprint)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130021", "Footprint altered"));
                return;
            }
            throw notFoundException;
        }
        if (this.add != null && !this.add.booleanValue()) {
            this.deleteResourceRequirements(systemEnvironment, sDMSFootprint);
        } else {
            if (this.add == null) {
                Vector vector = SDMSResourceRequirementTable.idx_seId.getVector(systemEnvironment, sDMSFootprint.getId(systemEnvironment));
                for (int i = 0; i < vector.size(); ++i) {
                    ((SDMSResourceRequirement)vector.get(i)).delete(systemEnvironment);
                }
            }
            for (int i = 0; i < this.resources.size(); ++i) {
                WithHash withHash = (WithHash)this.resources.get(i);
                this.createResourceRequirement(systemEnvironment, withHash, sDMSFootprint);
            }
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03207161123", "Footprint altered"));
    }

    private void deleteResourceRequirements(SystemEnvironment systemEnvironment, SDMSFootprint sDMSFootprint) throws SDMSException {
        Long l = sDMSFootprint.getId(systemEnvironment);
        for (int i = 0; i < this.resources.size(); ++i) {
            Vector vector = (Vector)this.resources.get(i);
            Long l2 = SDMSNamedResourceTable.pathToId(systemEnvironment, vector);
            SDMSResourceRequirementTable.idx_seId_nrId_getUnique(systemEnvironment, new SDMSKey(l, l2)).delete(systemEnvironment);
            Vector vector2 = SDMSSchedulingEntityTable.idx_fpId.getVector(systemEnvironment, l);
            int n = 0;
            while (i < vector2.size()) {
                SDMSSchedulingEntity sDMSSchedulingEntity = (SDMSSchedulingEntity)vector2.get(n);
                if (sDMSSchedulingEntity.checkParameterRI(systemEnvironment, l2)) {
                    SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l2);
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "0340911291427", "A parameter of Resource $1 is referenced by $2", (Object)sDMSNamedResource.pathString(systemEnvironment), (Object)sDMSSchedulingEntity.pathString(systemEnvironment)));
                }
                ++n;
            }
        }
    }

    private void createResourceRequirement(SystemEnvironment systemEnvironment, WithHash withHash, SDMSFootprint sDMSFootprint) throws SDMSException {
        Integer n;
        Long l = sDMSFootprint.getId(systemEnvironment);
        Integer n2 = new Integer(255);
        Long l2 = null;
        Boolean bl = Boolean.FALSE;
        String string = null;
        Long l3 = null;
        Integer n3 = null;
        Integer n4 = null;
        Boolean bl2 = Boolean.FALSE;
        String string2 = null;
        Vector vector = (Vector)withHash.get("NAME");
        if (vector == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03203140030", "No resourcename specified"));
        }
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getNamedResource(systemEnvironment, vector);
        if (sDMSNamedResource.getUsage(systemEnvironment) != 2) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207161115", "Only system resources are allowed in footprints"));
        }
        Long l4 = sDMSNamedResource.getId(systemEnvironment);
        Integer n5 = (Integer)withHash.get("AMOUNT");
        if (n5 == null) {
            n5 = new Integer(0);
        }
        if ((n = (Integer)withHash.get("KEEP")) == null) {
            n = new Integer(0);
        }
        SDMSResourceRequirement sDMSResourceRequirement = SDMSResourceRequirementTable.table.create(systemEnvironment, l4, l, n5, n, bl, string, l3, l2, n3, n4, bl2, n2, string2);
        sDMSResourceRequirement.check(systemEnvironment);
    }
}

