/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.AlterNamedResource;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.PathVector;

public class CreateNamedResource
extends Node {
    public static final String __version = "@(#) $Id: CreateNamedResource.java,v 2.15.2.3 2013/03/19 10:03:52 ronald Exp $";
    private PathVector path;
    private Integer usage;
    private String rspName;
    private boolean replace;
    private String gName;
    private Long gId;
    private Float factor = null;
    private Long inheritPrivs;
    private WithHash with;
    private WithHash parms = null;
    private boolean allTypes = false;

    public CreateNamedResource(PathVector pathVector, WithHash withHash, Boolean bl) {
        this.path = pathVector;
        this.with = withHash;
        this.replace = bl;
    }

    private void evaluateWith(SystemEnvironment systemEnvironment) throws SDMSException {
        this.usage = (Integer)this.with.get("USAGE");
        if (this.usage == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03402041231", "You must specify the resource usage"));
        }
        if (this.usage == 4) {
            this.allTypes = true;
        }
        this.rspName = (String)this.with.get("STATUS_PROFILE");
        if (this.with.containsKey("GROUP") && this.with.containsKey("GROUP_CASCADE")) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03111091015", "It is not allowed to specify the group clause twice"));
        }
        this.gName = (String)this.with.get("GROUP");
        if (this.gName == null) {
            this.gName = (String)this.with.get("GROUP_CASCADE");
        }
        this.gId = this.gName != null ? SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)this.gName), new Long(0L))).getId(systemEnvironment) : SDMSUserTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid()).getDefaultGId(systemEnvironment);
        this.parms = (WithHash)this.with.get("PARAMETERS");
        int n = this.usage;
        if ((n == 8 || n == 3) && this.parms != null && this.parms.size() > 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409281206", "Parameters are not allowed for categories"));
        }
        this.factor = (Float)this.with.get("FACTOR");
        int n2 = this.usage;
        if (n2 == 1 || n2 == 8 || n2 == 1) {
            this.factor = null;
        } else if (this.factor == null) {
            this.factor = new Float(1.0);
        }
        if (this.with.containsKey("INHERIT")) {
            this.inheritPrivs = (Long)this.with.get("INHERIT");
            if (this.inheritPrivs == null) {
                this.inheritPrivs = new Long(0L);
            }
        } else {
            this.inheritPrivs = null;
        }
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        long l;
        Long l2;
        SDMSProxy sDMSProxy;
        this.evaluateWith(systemEnvironment);
        int n = this.usage;
        if (n == 3) {
            systemEnvironment.checkFeatureAvailability("RESOURCE_POOLS");
        }
        if (this.factor != null && !this.factor.equals(new Float(1.0))) {
            systemEnvironment.checkFeatureAvailability("RESOURCE_TRACING");
        }
        if (this.rspName != null) {
            sDMSProxy = SDMSResourceStateProfileTable.idx_name_getUnique(systemEnvironment, this.rspName);
            l2 = sDMSProxy.getId(systemEnvironment);
        } else {
            l2 = null;
        }
        String string = (String)this.path.remove(this.path.size() - 1);
        if (this.path.size() == 0) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061335", "The category RESOURCE cannot be created"));
        }
        sDMSProxy = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.path);
        Long l3 = sDMSProxy.getId(systemEnvironment);
        long l4 = l = this.inheritPrivs == null ? ((SDMSNamedResourceProxyGeneric)sDMSProxy).getPrivilegeMask() : this.inheritPrivs.longValue();
        if ((((SDMSNamedResourceProxyGeneric)sDMSProxy).getPrivilegeMask() & l) != l) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03202061331", "Incompatible grant"));
        }
        this.inheritPrivs = new Long(l);
        try {
            sDMSProxy = SDMSNamedResourceTable.table.create(systemEnvironment, string, this.gId, l3, this.usage, l2, this.factor, this.inheritPrivs);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            if (this.replace) {
                this.path.add(string);
                AlterNamedResource alterNamedResource = new AlterNamedResource(new ObjectURL(new Integer(473), this.path), this.with, Boolean.FALSE);
                alterNamedResource.setEnv(this.env);
                alterNamedResource.go(systemEnvironment);
                this.result = alterNamedResource.result;
                return;
            }
            throw duplicateKeyException;
        }
        if (n != 8 && n != 3) {
            ((SDMSNamedResource)sDMSProxy).createParameters(systemEnvironment, this.parms, this.allTypes);
        }
        SystemEnvironment.sched.notifyChange(systemEnvironment, (SDMSNamedResource)sDMSProxy, 1);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201212129", "Named Resource created"));
    }
}

