/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSExitStateTranslation;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import java.util.Vector;

public class DropExitStateTranslation
extends Node {
    public static final String __version = "@(#) $Id: DropExitStateTranslation.java,v 2.2.14.3 2013/03/20 06:42:58 ronald Exp $";
    private ObjectURL url;
    private boolean noerr;

    public DropExitStateTranslation(ObjectURL objectURL, Boolean bl) {
        this.url = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile;
        systemEnvironment.checkFeatureAvailability("EXIT_STATE_TRANSLATION");
        try {
            sDMSExitStateTranslationProfile = (SDMSExitStateTranslationProfile)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311130025", "No Exit State Translation dropped"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSExitStateTranslationProfile.getId(systemEnvironment);
        Vector vector = SDMSSchedulingHierarchyTable.idx_estpId.getVector(systemEnvironment, l);
        if (vector.size() != 0) {
            SDMSSchedulingHierarchy sDMSSchedulingHierarchy = (SDMSSchedulingHierarchy)vector.elementAt(0);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSchedulingHierarchy.getSeParentId(systemEnvironment));
            SDMSSchedulingEntity sDMSSchedulingEntity2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSchedulingHierarchy.getSeChildId(systemEnvironment));
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112171840", "Exit State Translation in use between parent $1 and child $2", (Object)sDMSSchedulingEntity.pathString(systemEnvironment), (Object)sDMSSchedulingEntity2.pathString(systemEnvironment)));
        }
        Vector vector2 = SDMSExitStateTranslationTable.idx_estpId.getVector(systemEnvironment, l);
        for (SDMSExitStateTranslation sDMSExitStateTranslation : vector2) {
            sDMSExitStateTranslation.delete(systemEnvironment);
        }
        sDMSExitStateTranslationProfile.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112215", "Exit State Translation dropped"));
    }
}

