/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class DropJobDefinition
extends Node {
    public static final String __version = "@(#) $Id: DropJobDefinition.java,v 2.7.4.2 2013/03/19 17:16:46 ronald Exp $";
    Vector path;
    String name;
    Boolean force;
    boolean ignoreNotFound;

    public DropJobDefinition(Vector vector, String string, Boolean bl, boolean bl2) {
        this.name = string;
        this.path = vector;
        this.force = bl;
        this.ignoreNotFound = bl2;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSFolder sDMSFolder = SDMSFolderTable.getFolder(systemEnvironment, this.path);
        SDMSSchedulingEntity sDMSSchedulingEntity = null;
        try {
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.idx_folderId_name_getUnique(systemEnvironment, new SDMSKey(sDMSFolder.getId(systemEnvironment), (Comparable)((Object)this.name)));
        }
        catch (NotFoundException notFoundException) {
            if (this.ignoreNotFound) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03301291253", "Job Definition dropped"));
                return;
            }
            throw notFoundException;
        }
        sDMSSchedulingEntity.delete(systemEnvironment, this.force);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204112232", "Job Definition dropped"));
    }
}

