/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMapping;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class DropRsm
extends Node {
    public static final String __version = "@(#) $Id: DropRsm.java,v 2.1.14.1 2013/03/14 10:24:31 ronald Exp $";
    private String name;
    private boolean noerr;

    public DropRsm(String string, Boolean bl) {
        this.name = string;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSResourceStateMappingProfile sDMSResourceStateMappingProfile;
        try {
            sDMSResourceStateMappingProfile = SDMSResourceStateMappingProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311122342", "No Resource State Mapping dropped"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSResourceStateMappingProfile.getId(systemEnvironment);
        if (SDMSResourceRequirementTable.idx_rsmpId.containsKey(systemEnvironment, l)) {
            String string;
            String string2;
            SDMSResourceRequirement sDMSResourceRequirement = (SDMSResourceRequirement)SDMSResourceRequirementTable.idx_rsmpId.getVector(systemEnvironment, l).get(0);
            Long l2 = sDMSResourceRequirement.getSeId(systemEnvironment);
            String string3 = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResourceRequirement.getNrId(systemEnvironment)).pathString(systemEnvironment);
            try {
                string2 = SDMSSchedulingEntityTable.getObject(systemEnvironment, l2).pathString(systemEnvironment);
                string = "job";
            }
            catch (NotFoundException notFoundException) {
                string2 = SDMSFootprintTable.getObject(systemEnvironment, l2).getName(systemEnvironment);
                string = "footprint";
            }
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03311041044", "Resource state mapping is in use by $1 $2 ($3)", string, string2, string3));
        }
        Vector vector = SDMSResourceStateMappingTable.idx_rsmpId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResourceStateMapping sDMSResourceStateMapping = (SDMSResourceStateMapping)vector.get(i);
            sDMSResourceStateMapping.delete(systemEnvironment);
        }
        sDMSResourceStateMappingProfile.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203301647", "Resource State Mapping dropped"));
    }
}

