/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Formatter;
import de.independit.scheduler.server.parser.ObjectFilter;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSProxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public abstract class HierarchyLister {
    public static final String __version = "@(#) $Id: HierarchyLister.java,v 2.11.2.3 2013/08/24 10:30:27 dieter Exp $";
    Vector startpoint;
    HashSet expandIds;
    Vector objectsToList;
    SDMSMessage title;
    Formatter formatter;
    int[] sortColumns;
    Vector filter;
    public ObjectFilter objFilter = new ObjectFilter();
    public boolean useFilter = false;

    protected void initLister(Vector vector, HashSet hashSet, Vector vector2, SDMSMessage sDMSMessage, Formatter formatter, Vector vector3) {
        this.startpoint = vector;
        this.expandIds = hashSet;
        this.objectsToList = vector2;
        this.title = sDMSMessage;
        this.sortColumns = new int[2];
        this.sortColumns[0] = 1;
        this.sortColumns[1] = 2;
        this.formatter = formatter;
        this.filter = vector3;
    }

    public HierarchyLister() {
        this.initLister(null, null, null, null, null, new Vector());
    }

    public HierarchyLister(Vector vector, HashSet hashSet) {
        this.initLister(vector, hashSet, null, null, null, new Vector());
    }

    public HierarchyLister(ObjectURL objectURL, HashSet hashSet) {
        this.initLister(objectURL.path, hashSet, null, null, null, new Vector());
    }

    public HierarchyLister(Vector vector, HashSet hashSet, Formatter formatter) {
        this.initLister(vector, hashSet, null, null, formatter, new Vector());
    }

    public HierarchyLister(Vector vector, HashSet hashSet, Formatter formatter, Vector vector2) {
        this.initLister(vector, hashSet, null, null, formatter, vector2);
    }

    public void setObjectsToList(Vector vector) {
        this.objectsToList = vector;
    }

    public void setStartpoint(Vector vector) {
        this.startpoint = vector;
    }

    public void setExpandIds(HashSet hashSet) {
        this.expandIds = hashSet;
    }

    public void setTitle(SDMSMessage sDMSMessage) {
        this.title = sDMSMessage;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public void setSortColumns(int[] nArray) {
        this.sortColumns = nArray;
    }

    public void setFilter(Vector vector) {
        this.filter = vector;
    }

    public abstract void setDefaultStartpoint(SystemEnvironment var1) throws SDMSException;

    public abstract SDMSProxy getStartObject(SystemEnvironment var1) throws SDMSException;

    public abstract SDMSProxy getObject(SystemEnvironment var1, Long var2) throws SDMSException;

    public abstract Vector getChildren(SystemEnvironment var1, Long var2) throws SDMSException;

    public abstract Vector getParents(SystemEnvironment var1, Long var2) throws SDMSException;

    public abstract boolean isLeaf(SystemEnvironment var1, SDMSProxy var2) throws SDMSException;

    public SDMSOutputContainer list(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.list(systemEnvironment, true);
    }

    public SDMSOutputContainer list(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        if (this.formatter == null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03207221510", "No formatter specified"));
        }
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, this.title, this.formatter.fillHeadInfo());
        boolean bl2 = this.objectsToList != null;
        boolean bl3 = false;
        if (!bl2) {
            if (this.startpoint == null) {
                this.setDefaultStartpoint(systemEnvironment);
            }
            SDMSProxy sDMSProxy = this.getStartObject(systemEnvironment);
            if (!bl || !sDMSProxy.checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402131330", "Insufficient Privileges"));
            }
            this.objectsToList = new Vector();
            this.objectsToList.add(sDMSProxy);
            bl3 = this.add_children(systemEnvironment, sDMSOutputContainer, sDMSProxy, bl);
        }
        if (bl2 || bl3) {
            this.listBottomUp(systemEnvironment, sDMSOutputContainer, bl);
        } else {
            for (SDMSProxy sDMSProxy : this.objectsToList) {
                Vector vector = this.formatter.fillVector(systemEnvironment, sDMSProxy, null);
                sDMSOutputContainer.addData(systemEnvironment, vector);
            }
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, this.sortColumns));
        return sDMSOutputContainer;
    }

    private void listBottomUp(SystemEnvironment systemEnvironment, SDMSOutputContainer sDMSOutputContainer, boolean bl) throws SDMSException {
        Iterator iterator = this.objectsToList.iterator();
        Vector<SDMSProxy> vector = new Vector<SDMSProxy>();
        HashSet<Long> hashSet = new HashSet<Long>();
        HashSet<Long> hashSet2 = new HashSet<Long>();
        while (iterator.hasNext()) {
            Long l;
            SDMSProxy sDMSProxy;
            Object e = iterator.next();
            SDMSProxy sDMSProxy2 = e instanceof Long ? this.getObject(systemEnvironment, (Long)e) : (SDMSProxy)e;
            Vector vector2 = this.getParents(systemEnvironment, sDMSProxy2.getId(systemEnvironment));
            int n = -1;
            if (bl) {
                for (n = vector2.size() - 1; n >= 0; --n) {
                    sDMSProxy = (SDMSProxy)vector2.get(n);
                    l = sDMSProxy.getId(systemEnvironment);
                    if (!sDMSProxy.checkPrivileges(systemEnvironment, 0x10000000L)) break;
                }
            }
            if (n >= 0) continue;
            for (n = vector2.size() - 1; n >= 0; --n) {
                sDMSProxy = (SDMSProxy)vector2.get(n);
                l = sDMSProxy.getId(systemEnvironment);
                if (!hashSet2.contains(l)) {
                    vector.addElement(sDMSProxy);
                    hashSet.add(l);
                    hashSet2.add(l);
                }
                if (this.expandIds != null && !this.expandIds.contains(l)) break;
            }
            if (n >= 0 || hashSet2.contains(l = sDMSProxy2.getId(systemEnvironment))) continue;
            vector.addElement(sDMSProxy2);
            hashSet2.add(l);
        }
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            sDMSOutputContainer.addData(systemEnvironment, this.formatter.fillVector(systemEnvironment, (SDMSProxy)iterator.next(), hashSet));
        }
    }

    private boolean add_children(SystemEnvironment systemEnvironment, SDMSOutputContainer sDMSOutputContainer, SDMSProxy sDMSProxy, boolean bl) throws SDMSException {
        Long l = sDMSProxy.getId(systemEnvironment);
        Vector vector = this.getChildren(systemEnvironment, l);
        boolean bl2 = false;
        for (int i = 0; i < vector.size(); ++i) {
            SDMSProxy sDMSProxy2 = (SDMSProxy)vector.get(i);
            SDMSPrivilege sDMSPrivilege = sDMSProxy2.getPrivileges(systemEnvironment);
            if (bl && !sDMSPrivilege.can(0x10000000L) && !sDMSPrivilege.can(4L)) continue;
            Long l2 = sDMSProxy2.getId(systemEnvironment);
            if (this.checkValid(systemEnvironment, sDMSProxy2) || this.checkChildren(systemEnvironment, sDMSProxy2, bl)) {
                this.objectsToList.add(sDMSProxy2);
            } else {
                bl2 = true;
            }
            if (this.expandIds != null && !this.expandIds.contains(l2) || bl && !sDMSPrivilege.can(0x10000000L) || !this.add_children(systemEnvironment, sDMSOutputContainer, sDMSProxy2, bl)) continue;
            bl2 = true;
        }
        return bl2;
    }

    private boolean checkChildren(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, boolean bl) throws SDMSException {
        Long l = sDMSProxy.getId(systemEnvironment);
        Vector vector = this.getChildren(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSProxy sDMSProxy2 = (SDMSProxy)vector.get(i);
            SDMSPrivilege sDMSPrivilege = sDMSProxy2.getPrivileges(systemEnvironment);
            if (bl && !sDMSPrivilege.can(0x10000000L) && !sDMSPrivilege.can(4L)) continue;
            Long l2 = sDMSProxy2.getId(systemEnvironment);
            if (!this.checkValid(systemEnvironment, sDMSProxy2) && !this.checkChildren(systemEnvironment, sDMSProxy2, bl)) continue;
            return true;
        }
        return false;
    }

    public boolean checkValid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        boolean bl = true;
        if (this.useFilter) {
            bl = this.objFilter.doFilter(systemEnvironment, sDMSProxy);
        }
        return bl;
    }
}

