/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ManipResource;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import java.util.HashSet;
import java.util.Vector;

public class LinkResource
extends ManipResource {
    public static final String __version = "@(#) $Id: LinkResource.java,v 2.4.4.1 2013/03/14 10:24:35 ronald Exp $";
    static final Float fzero = new Float(0.0f);
    private ObjectURL scope;
    private boolean force;

    public LinkResource(ObjectURL objectURL, ObjectURL objectURL2, Boolean bl) {
        super(objectURL, false);
        this.scope = objectURL2;
        this.force = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        boolean bl;
        SDMSResource sDMSResource;
        block7: {
            sDMSResource = (SDMSResource)this.resource.resolve(systemEnvironment);
            SDMSScope sDMSScope = (SDMSScope)this.scope.resolve(systemEnvironment);
            bl = false;
            this.online = Boolean.TRUE;
            Long l2 = sDMSResource.getOwnerId(systemEnvironment);
            HashSet hashSet = systemEnvironment.cEnv.gid();
            if (!hashSet.contains(l2) && !hashSet.contains(SDMSObject.adminGId)) {
                throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03402260151", "You cannot create a resource with a group you do not belong to"));
            }
            this.tag = null;
            this.traceInterval = null;
            this.traceBase = null;
            this.baseMultiplier = new Integer(600);
            Long l3 = sDMSResource.getNrId(systemEnvironment);
            l = sDMSScope.getId(systemEnvironment);
            this.check_link(systemEnvironment, sDMSResource, l);
            Long l4 = sDMSResource.getId(systemEnvironment);
            try {
                sDMSResource = SDMSResourceTable.table.create(systemEnvironment, l3, l, null, l2, l4, null, null, null, null, null, null, null, null, null, null, null, null, this.baseMultiplier, fzero, fzero, fzero, fzero, new Long(0L), new Long(0L));
            }
            catch (DuplicateKeyException duplicateKeyException) {
                if (!this.force) {
                    throw duplicateKeyException;
                }
                bl = true;
                sDMSResource = (SDMSResource)SDMSResourceTable.idx_nrId_scopeId.getUnique(systemEnvironment, new SDMSKey(l3, l));
                Vector vector = sDMSResource.getAllocations(systemEnvironment);
                if (vector.size() != 0) break block7;
                if (sDMSResource.getLinkId(systemEnvironment) != null) {
                    sDMSResource.setLinkId(systemEnvironment, l4);
                }
                sDMSResource.delete(systemEnvironment);
                sDMSResource = SDMSResourceTable.table.create(systemEnvironment, l3, l, null, l2, l4, null, null, null, null, null, null, null, null, null, null, null, null, this.baseMultiplier, fzero, fzero, fzero, fzero, new Long(0L), new Long(0L));
            }
        }
        SystemEnvironment.sched.notifyChange(systemEnvironment, sDMSResource, l, 1);
        if (bl) {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03202211126", "Resource replaced"));
        } else {
            this.result.setFeedback(new SDMSMessage(systemEnvironment, "03202211126", "Resource created"));
        }
    }

    private void check_link(SystemEnvironment systemEnvironment, SDMSResource sDMSResource, Long l) throws SDMSException {
        SDMSScope sDMSScope;
        Long l2 = sDMSResource.getScopeId(systemEnvironment);
        try {
            sDMSScope = SDMSScopeTable.getObject(systemEnvironment, sDMSResource.getScopeId(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03107151544", "The resource linked to must reside within a scope"));
        }
        if (l.equals(sDMSScope.getId(systemEnvironment))) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03107151545", "The resource linked to must reside within a different scope"));
        }
        Long l3 = sDMSResource.getLinkId(systemEnvironment);
        while (l3 != null) {
            SDMSResource sDMSResource2 = SDMSResourceTable.getObject(systemEnvironment, l3);
            Long l4 = sDMSResource2.getScopeId(systemEnvironment);
            if (l4.equals(l)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03108021409", "The resource link cycle detected"));
            }
            l3 = sDMSResource2.getLinkId(systemEnvironment);
        }
    }
}

