/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectFilter;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSCalendarTable;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.util.DateTime;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.Vector;

public class ListCalendar
extends Node {
    public static final String __version = "@(#) $Id: ListCalendar.java,v 2.14.2.2 2013/06/18 09:49:32 ronald Exp $";
    private WithHash with;
    private DateTime starttime = null;
    private DateTime endtime = null;
    private TimeZone tz = null;
    private ObjectFilter objFilter = new ObjectFilter();

    public ListCalendar(WithHash withHash) {
        this.with = withHash == null ? new WithHash() : withHash;
        this.txMode = 1;
        this.auditFlag = false;
    }

    protected void fillDetail(SystemEnvironment systemEnvironment, SDMSScheduledEvent sDMSScheduledEvent, SDMSEvent sDMSEvent, SDMSSchedulingEntity sDMSSchedulingEntity, SDMSOutputContainer sDMSOutputContainer) throws SDMSException {
        String string;
        Vector vector = SDMSCalendarTable.idx_scevId.getVector(systemEnvironment, sDMSScheduledEvent.getId(systemEnvironment));
        Long l = sDMSSchedulingEntity.getId(systemEnvironment);
        String string2 = sDMSSchedulingEntity.pathString(systemEnvironment);
        String string3 = sDMSSchedulingEntity.getTypeAsString(systemEnvironment);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSSchedulingEntity.getOwnerId(systemEnvironment));
        String string4 = sDMSGroup.getName(systemEnvironment);
        String string5 = sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString();
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, sDMSScheduledEvent.getSceId(systemEnvironment));
        String string6 = sDMSSchedule.pathString(systemEnvironment);
        String string7 = sDMSEvent.getName(systemEnvironment);
        Integer n = sDMSSchedulingEntity.getExpectedFinaltime(systemEnvironment);
        String string8 = string = n == null ? "" : n.toString();
        if (n == null) {
            n = new Integer(0);
        }
        GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
        TimeZone timeZone = SystemEnvironment.systemTimeZone;
        String string9 = this.tz.getID();
        for (int i = 0; i < vector.size(); ++i) {
            SDMSCalendar sDMSCalendar = (SDMSCalendar)vector.get(i);
            gregorianCalendar.setTimeZone(timeZone);
            gregorianCalendar.setTimeInMillis(sDMSCalendar.getStarttime(systemEnvironment) * 1000L);
            gregorianCalendar.setTimeZone(this.tz);
            DateTime dateTime = new DateTime(gregorianCalendar.getTimeInMillis() / 1000L);
            DateTime dateTime2 = new DateTime(new Long((gregorianCalendar.getTimeInMillis() + n.longValue() * 1000L) / 1000L));
            if (this.starttime != null && this.starttime.compareTo(dateTime2) > 0L || this.endtime != null && this.endtime.compareTo(dateTime) < 0L) continue;
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(sDMSCalendar.getId(systemEnvironment));
            vector2.add(string2);
            vector2.add(string3);
            vector2.add(l);
            vector2.add(string4);
            vector2.add(string5);
            vector2.add(string6);
            vector2.add(sDMSSchedule.isReallyActive(systemEnvironment));
            vector2.add(string7);
            vector2.add(dateTime.toString(this.tz, true));
            vector2.add(string);
            vector2.add(string9);
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
    }

    protected void collectCalendar(SystemEnvironment systemEnvironment, SDMSOutputContainer sDMSOutputContainer) throws SDMSException {
        Vector vector = this.with.containsKey("FILTER") ? this.objFilter.initialize_filter(systemEnvironment, (Vector)this.with.get("FILTER"), 0, true) : new Vector();
        Iterator iterator = SDMSScheduledEventTable.table.iterator(systemEnvironment);
        while (iterator.hasNext()) {
            SDMSEvent sDMSEvent;
            SDMSSchedulingEntity sDMSSchedulingEntity;
            SDMSScheduledEvent sDMSScheduledEvent = (SDMSScheduledEvent)iterator.next();
            if (!sDMSScheduledEvent.getIsCalendar(systemEnvironment).booleanValue() || !this.objFilter.doFilter(systemEnvironment, sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, (sDMSEvent = SDMSEventTable.getObject(systemEnvironment, sDMSScheduledEvent.getEvtId(systemEnvironment))).getSeId(systemEnvironment)), vector)) continue;
            this.fillDetail(systemEnvironment, sDMSScheduledEvent, sDMSEvent, sDMSSchedulingEntity, sDMSOutputContainer);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 9, 1));
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("SE_NAME");
        vector.add("SE_TYPE");
        vector.add("SE_ID");
        vector.add("SE_OWNER");
        vector.add("SE_PRIVS");
        vector.add("SCE_NAME");
        vector.add("SCE_ACTIVE");
        vector.add("EVT_NAME");
        vector.add("STARTTIME");
        vector.add("EXPECTED_FINAL_TIME");
        vector.add("TIME_ZONE");
        if (this.with.containsKey("STARTTIME")) {
            this.starttime = (DateTime)this.with.get("STARTTIME");
        }
        if (this.with.containsKey("ENDTIME")) {
            this.endtime = (DateTime)this.with.get("ENDTIME");
        }
        this.tz = this.with.containsKey("TIME") ? TimeZone.getTimeZone((String)this.with.get("TIME")) : TimeZone.getDefault();
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03909181034", "List of Calendars"), vector);
        this.collectCalendar(systemEnvironment, sDMSOutputContainer);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03909181035", "Calendar listed"));
    }
}

