/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.DuplicateKeyException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;

public class RenameUser
extends Node {
    public static final String __version = "@(#) $Id: RenameUser.java,v 2.1.4.1 2013/03/14 10:24:45 ronald Exp $";
    private ObjectURL url;
    private String name2;

    public RenameUser(ObjectURL objectURL, String string) {
        this.url = objectURL;
        this.name2 = string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSUser sDMSUser = (SDMSUser)this.url.resolve(systemEnvironment);
        try {
            sDMSUser.setName(systemEnvironment, this.name2);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            sDMSUser = SDMSUserTable.idx_name_getUnique(systemEnvironment, this.name2);
            if (sDMSUser.getDeleteVersion(systemEnvironment) == 0L) {
                throw duplicateKeyException;
            }
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03402191836", "A user with the same name previously existed"));
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203071348", "User renamed"));
    }
}

