/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Connect;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.bind.DatatypeConverter;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsAuthProviderImpl;

public class SSOConnect
extends Connect {
    private String token;
    private boolean firstTime;
    private static final String ADMIN = "ASDMIN";
    private static final String PUBLIC = "PUBLIC";
    private static final String ISDEFAULT = "ISDEFAULT";
    private static final String PROVIDER = "PROVIDER";

    public SSOConnect(WithHash withHash, boolean bl) {
        super(withHash);
        this.cmdtype = 7;
        this.txMode = 2;
        this.token = (String)withHash.get("TOKEN");
        this.firstTime = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        WindowsAuthProviderImpl windowsAuthProviderImpl = null;
        IWindowsSecurityContext iWindowsSecurityContext = null;
        boolean bl = false;
        if (this.firstTime) {
            systemEnvironment.cEnv.SSOInfo = new HashMap();
            try {
                windowsAuthProviderImpl = new WindowsAuthProviderImpl();
            }
            catch (Throwable throwable) {
                SDMSThread.doTrace(systemEnvironment.cEnv, throwable.toString(), 1);
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02709250926", "Single Sign On not supported in this installation"));
            }
            systemEnvironment.cEnv.SSOInfo.put(PROVIDER, windowsAuthProviderImpl);
        } else {
            windowsAuthProviderImpl = (WindowsAuthProviderImpl)systemEnvironment.cEnv.SSOInfo.get(PROVIDER);
        }
        try {
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)this.token);
            iWindowsSecurityContext = windowsAuthProviderImpl.acceptSecurityToken("server-connection", byArray, "Negotiate");
            byArray = iWindowsSecurityContext.getToken();
            this.token = byArray != null ? DatatypeConverter.printBase64Binary((byte[])byArray) : "null";
        }
        catch (Throwable throwable) {
            SDMSThread.doTrace(systemEnvironment.cEnv, throwable.toString(), 1);
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02709250928", "Single Sign On not supported in this installation"));
        }
        if (this.firstTime) {
            this.evaluateWith(systemEnvironment);
        } else {
            if (iWindowsSecurityContext.isContinue()) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02709201816", "SSO negotiation failed"));
            }
            this.user = iWindowsSecurityContext.getIdentity().getFqn();
            int n = this.user.indexOf(92);
            String string = "";
            if (n > 0) {
                string = this.user.substring(0, n);
                this.user = SystemEnvironment.includeDomainNames ? this.user.replace('\\', '_') : this.user.substring(n + 1);
            }
            if (SystemEnvironment.nameCase.equals(SystemEnvironment.CASE_UPPER)) {
                this.user = this.user.toUpperCase();
            } else if (SystemEnvironment.nameCase.equals(SystemEnvironment.CASE_LOWER)) {
                this.user = this.user.toLowerCase();
            }
            String string2 = (SystemEnvironment.bicsuitePrefix.length() > 0 ? SystemEnvironment.bicsuitePrefix + "_" : "") + (SystemEnvironment.serverName.length() > 0 ? SystemEnvironment.serverName + "_" : "");
            IWindowsAccount[] iWindowsAccountArray = iWindowsSecurityContext.getIdentity().getGroups();
            Vector<String> vector3 = new Vector<String>();
            boolean bl2 = false;
            String string3 = null;
            boolean bl3 = false;
            for (IWindowsAccount iWindowsAccount : iWindowsSecurityContext.getIdentity().getGroups()) {
                String string4 = iWindowsAccount.getFqn();
                int n2 = string4.indexOf(92);
                String string5 = string4.substring(0, n);
                if (n2 > 0) {
                    string4 = string4.substring(n2 + 1);
                }
                if (!string4.startsWith(string2)) continue;
                if (string4.endsWith("_ISDEFAULT")) {
                    bl3 = true;
                    string4 = string4.substring(0, string4.length() - "_ISDEFAULT".length());
                }
                bl2 = true;
                if (string4.equals(string2 + "_" + PUBLIC) || !SystemEnvironment.useAdGroups) continue;
                if (string4.equals(string2 + "_" + ADMIN)) {
                    string4 = ADMIN;
                } else {
                    string4 = string4.substring(string2.length());
                    if (SystemEnvironment.includeDomainNames) {
                        string4 = string5 + "_" + string4;
                    }
                    if (SystemEnvironment.nameCase.equals(SystemEnvironment.CASE_UPPER)) {
                        string4 = string4.toUpperCase();
                    } else if (SystemEnvironment.nameCase.equals(SystemEnvironment.CASE_LOWER)) {
                        string4 = string4.toLowerCase();
                    }
                }
                if (bl3) {
                    string3 = string4;
                }
                vector3.add(string4);
            }
            if (!bl2) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02709251459", "Permission denied"));
            }
            if (SystemEnvironment.useAdGroups) {
                this.initUser(systemEnvironment, vector3.toArray(new String[0]), false, SystemEnvironment.autoCreateUsers, SystemEnvironment.autoCreateGroups, string3);
            } else {
                this.initUser(systemEnvironment, null, false, SystemEnvironment.autoCreateUsers, SystemEnvironment.autoCreateGroups, string3);
            }
        }
        vector.add("CONNECT_TIME");
        vector2.add(systemEnvironment.systemDateFormat.format(new Date(System.currentTimeMillis())));
        if (this.firstTime) {
            vector.add("TOKEN");
            vector2.add(this.token);
        }
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03205141302", "Connect"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03709191436", this.firstTime ? "Connection in progress" : "Connected"));
    }
}

