/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.Formatter;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import java.util.HashSet;
import java.util.Vector;

class SfSeFormatter
implements Formatter {
    @Override
    public Vector fillHeadInfo() {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("SE_PATH");
        vector.add("TYPE");
        vector.add("HAS_CHILDREN");
        vector.add("PRIVS");
        return vector;
    }

    @Override
    public Vector fillVector(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy, HashSet hashSet) throws SDMSException {
        Vector vector = new Vector();
        if (sDMSProxy instanceof SDMSFolder) {
            this.fillFVector(systemEnvironment, (SDMSFolder)sDMSProxy, vector, hashSet);
        } else {
            this.fillSeVector(systemEnvironment, (SDMSSchedulingEntity)sDMSProxy, vector);
        }
        return vector;
    }

    private void fillSeVector(SystemEnvironment systemEnvironment, SDMSSchedulingEntity sDMSSchedulingEntity, Vector vector) throws SDMSException {
        vector.add(sDMSSchedulingEntity.getId(systemEnvironment));
        vector.add(sDMSSchedulingEntity.pathVector(systemEnvironment));
        vector.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
        vector.add(Boolean.TRUE);
        vector.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment).toString());
    }

    private void fillFVector(SystemEnvironment systemEnvironment, SDMSFolder sDMSFolder, Vector vector, HashSet hashSet) throws SDMSException {
        Long l = sDMSFolder.getId(systemEnvironment);
        vector.add(l);
        vector.add(sDMSFolder.pathVector(systemEnvironment));
        vector.add("FOLDER");
        if (hashSet.contains(l)) {
            vector.add(Boolean.TRUE);
        } else {
            vector.add(Boolean.FALSE);
        }
        vector.add(sDMSFolder.getPrivileges(systemEnvironment).toString());
    }
}

