/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolDistConfig;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigTable;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSPoolProxyGeneric;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.PathVector;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowDistribution
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowDistribution.java,v 2.3.14.4 2013/06/18 09:49:35 ronald Exp $";
    private final ObjectURL url;

    public ShowDistribution(ObjectURL objectURL) {
        this.url = objectURL;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        systemEnvironment.checkFeatureAvailability("POOL");
        SDMSPoolDistribution sDMSPoolDistribution = (SDMSPoolDistribution)this.url.resolve(systemEnvironment);
        if (!sDMSPoolDistribution.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03603201544", "Insufficient privileges"));
        }
        SDMSPool sDMSPool = SDMSPoolTable.getObject(systemEnvironment, sDMSPoolDistribution.getPId(systemEnvironment));
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSPool.getNrId(systemEnvironment));
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, sDMSPool.getScopeId(systemEnvironment));
        Long l = sDMSPoolDistribution.getId(systemEnvironment);
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("POOLNAME");
        vector.add("SCOPENAME");
        vector.add("IS_ACTIVE");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("RESOURCES");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSPoolDistribution.getName(systemEnvironment));
        vector2.add(sDMSNamedResource.pathVector(systemEnvironment));
        vector2.add(sDMSScope.pathVector(systemEnvironment));
        if (l.equals(sDMSPool.getDistId(systemEnvironment))) {
            vector2.add(Boolean.TRUE);
        } else {
            vector2.add(Boolean.FALSE);
        }
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSPoolDistribution.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSPoolDistribution.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSPoolDistribution.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSPoolDistribution.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSPoolDistribution.getPrivileges(systemEnvironment).toString());
        vector2.add(this.listResources(systemEnvironment, l));
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03603201552", "Pool Distribution"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03603161318", "Distribution shown"));
    }

    private SDMSOutputContainer listResources(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("RESOURCENAME");
        vector.add("RESOURCESCOPENAME");
        vector.add("TYPE");
        vector.add("IS_MANAGED");
        vector.add("NOMPCT");
        vector.add("FREEPCT");
        vector.add("MINPCT");
        vector.add("MAXPCT");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Vector vector2 = SDMSPoolDistConfigTable.idx_pldId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSProxy sDMSProxy;
            SDMSPoolDistConfig sDMSPoolDistConfig = (SDMSPoolDistConfig)vector2.get(i);
            SDMSPooledResource sDMSPooledResource = SDMSPooledResourceTable.getObject(systemEnvironment, sDMSPoolDistConfig.getPrId(systemEnvironment));
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSPoolDistConfig.getId(systemEnvironment));
            PathVector pathVector = null;
            PathVector pathVector2 = null;
            if (sDMSPooledResource.getIsPool(systemEnvironment).booleanValue()) {
                sDMSProxy = SDMSPoolTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
                pathVector = SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)sDMSProxy).getNrId(systemEnvironment)).pathVector(systemEnvironment);
                pathVector2 = SDMSScopeTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)sDMSProxy).getScopeId(systemEnvironment)).pathVector(systemEnvironment);
            } else {
                sDMSProxy = SDMSResourceTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
                pathVector = SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSResourceProxyGeneric)sDMSProxy).getNrId(systemEnvironment)).pathVector(systemEnvironment);
                pathVector2 = SDMSScopeTable.getObject(systemEnvironment, ((SDMSResourceProxyGeneric)sDMSProxy).getScopeId(systemEnvironment)).pathVector(systemEnvironment);
            }
            vector3.add(pathVector);
            vector3.add(pathVector2);
            vector3.add(sDMSPooledResource.getIsPool(systemEnvironment) != false ? "POOL" : "RESOURCE");
            vector3.add(sDMSPoolDistConfig.getIsManaged(systemEnvironment));
            vector3.add(sDMSPoolDistConfig.getNomPct(systemEnvironment));
            vector3.add(sDMSPoolDistConfig.getFreePct(systemEnvironment));
            vector3.add(sDMSPoolDistConfig.getMinPct(systemEnvironment));
            vector3.add(sDMSPoolDistConfig.getMaxPct(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2, 1));
        return sDMSOutputContainer;
    }
}

