/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowExitStateProfile
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowExitStateProfile.java,v 2.11.2.2 2013/06/18 09:49:35 ronald Exp $";
    private ObjectURL url;

    public ShowExitStateProfile(ObjectURL objectURL) {
        this.url = objectURL;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSExitStateProfile sDMSExitStateProfile = (SDMSExitStateProfile)this.url.resolve(systemEnvironment);
        if (!sDMSExitStateProfile.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411713", "Insufficient privileges"));
        }
        Long l = sDMSExitStateProfile.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("DEFAULT_ESM_NAME");
        vector.add("IS_VALID");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("STATES");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSExitStateProfile.getName(systemEnvironment));
        Long l2 = sDMSExitStateProfile.getDefaultEsmpId(systemEnvironment);
        if (l2 != null) {
            SDMSExitStateMappingProfile sDMSExitStateMappingProfile = SDMSExitStateMappingProfileTable.getObject(systemEnvironment, l2);
            vector2.add(sDMSExitStateMappingProfile.getName(systemEnvironment));
        } else {
            vector2.add("<null>");
        }
        vector2.add(sDMSExitStateProfile.getIsValid(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSExitStateProfile.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSExitStateProfile.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSExitStateProfile.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSExitStateProfile.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSExitStateProfile.getPrivileges(systemEnvironment).toString());
        Vector<String> vector3 = new Vector<String>();
        vector3.add("ID");
        vector3.add("PREFERENCE");
        vector3.add("TYPE");
        vector3.add("ESD_NAME");
        vector3.add("IS_UNREACHABLE");
        vector3.add("IS_BROKEN");
        vector3.add("IS_BATCH_DEFAULT");
        vector3.add("IS_DEPENDENCY_DEFAULT");
        SDMSOutputContainer sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, null, vector3);
        Vector vector4 = SDMSExitStateTable.idx_espId.getVector(systemEnvironment, l);
        for (SDMSExitState sDMSExitState : vector4) {
            Vector<Object> vector5 = new Vector<Object>();
            vector5.add(sDMSExitState.getId(systemEnvironment));
            vector5.add(sDMSExitState.getPreference(systemEnvironment));
            if (sDMSExitState.getIsFinal(systemEnvironment).booleanValue()) {
                vector5.add("FINAL");
            } else if (sDMSExitState.getIsRestartable(systemEnvironment).booleanValue()) {
                vector5.add("RESTARTABLE");
            } else {
                vector5.add("PENDING");
            }
            SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, sDMSExitState.getEsdId(systemEnvironment));
            vector5.add(sDMSExitStateDefinition.getName(systemEnvironment));
            vector5.add(sDMSExitState.getIsUnreachable(systemEnvironment));
            vector5.add(sDMSExitState.getIsBroken(systemEnvironment));
            vector5.add(sDMSExitState.getIsBatchDefault(systemEnvironment));
            vector5.add(sDMSExitState.getIsDependencyDefault(systemEnvironment));
            sDMSOutputContainer2.addData(systemEnvironment, vector5);
        }
        Collections.sort(sDMSOutputContainer2.dataset, sDMSOutputContainer2.getComparator(systemEnvironment, 1));
        vector2.add(sDMSOutputContainer2);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "02111082039", "Exit State Profile"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02111082040", "Exit State Profile shown"));
    }
}

