/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolDistConfig;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigTable;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSPoolDistributionTable;
import de.independit.scheduler.server.repository.SDMSPoolProxyGeneric;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSPooledResource;
import de.independit.scheduler.server.repository.SDMSPooledResourceTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.util.PathVector;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowPool
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowPool.java,v 2.17.4.5 2013/06/18 09:49:37 ronald Exp $";
    private final ObjectURL url;

    public ShowPool(ObjectURL objectURL) {
        this.url = objectURL;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Comparable comparable;
        Comparable comparable2;
        systemEnvironment.checkFeatureAvailability("POOL");
        SDMSPool sDMSPool = (SDMSPool)this.url.resolve(systemEnvironment);
        if (!sDMSPool.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "03603161306", "Insufficient privileges"));
        }
        Long l = sDMSPool.getId(systemEnvironment);
        Long l2 = sDMSPool.getNrId(systemEnvironment);
        Long l3 = sDMSPool.getScopeId(systemEnvironment);
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l2);
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l3);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSPool.getOwnerId(systemEnvironment));
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("SCOPENAME");
        vector.add("TAG");
        vector.add("OWNER");
        vector.add("MANAGER_ID");
        vector.add("MANAGER_NAME");
        vector.add("MANAGER_SCOPENAME");
        vector.add("DEFINED_AMOUNT");
        vector.add("AMOUNT");
        vector.add("FREE_AMOUNT");
        vector.add("TOTAL_FREE_AMOUNT");
        vector.add("CHILD_ALLOCATED");
        vector.add("EVALUATION_CYCLE");
        vector.add("NEXT_EVALUATION_TIME");
        vector.add("ACTIVE_DISTRIBUTION");
        vector.add("TRACE_INTERVAL");
        vector.add("TRACE_BASE");
        vector.add("TRACE_BASE_MULTIPLIER");
        vector.add("TD0_AVG");
        vector.add("TD1_AVG");
        vector.add("TD2_AVG");
        vector.add("LW_AVG");
        vector.add("LAST_WRITE");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("RESOURCES");
        vector.add("DISTRIBUTION_NAMES");
        vector.add("DISTRIBUTIONS");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSNamedResource.pathVector(systemEnvironment));
        vector2.add(sDMSScope.pathVector(systemEnvironment));
        vector2.add(sDMSPool.getTag(systemEnvironment));
        vector2.add(sDMSGroup.getName(systemEnvironment));
        Long l4 = sDMSPool.getManagerId(systemEnvironment);
        vector2.add(l4);
        if (l4 != null) {
            comparable2 = SDMSPooledResourceTable.getObject(systemEnvironment, l4);
            comparable = SDMSPoolTable.getObject(systemEnvironment, comparable2.getPId(systemEnvironment));
            vector2.add(SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)comparable).getNrId(systemEnvironment)).pathVector(systemEnvironment));
            vector2.add(SDMSScopeTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)comparable).getScopeId(systemEnvironment)).pathVector(systemEnvironment));
        } else {
            vector2.add(null);
            vector2.add(null);
        }
        vector2.add(sDMSPool.getDefinedAmount(systemEnvironment));
        vector2.add(sDMSPool.getAmount(systemEnvironment));
        vector2.add(sDMSPool.getFreeAmount(systemEnvironment));
        vector2.add(sDMSPool.getTotalFreeAmount(systemEnvironment));
        vector2.add(sDMSPool.getChildAllocated(systemEnvironment));
        comparable2 = sDMSPool.getEvaluationCycle(systemEnvironment);
        if (comparable2 == null) {
            comparable2 = new Integer(SystemEnvironment.ptEvalCycle);
        }
        vector2.add(comparable2);
        comparable = new Date();
        ((Date)comparable).setTime(sDMSPool.getNextEvaluationTime(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        Long l5 = sDMSPool.getDistId(systemEnvironment);
        if (l5 == null) {
            vector2.add("DEFAULT");
        } else {
            vector2.add(SDMSPoolDistributionTable.getObject(systemEnvironment, l5).getName(systemEnvironment));
        }
        vector2.add(sDMSPool.getTraceInterval(systemEnvironment));
        vector2.add(sDMSPool.getTraceBase(systemEnvironment));
        vector2.add(sDMSPool.getTraceBaseMultiplier(systemEnvironment));
        vector2.add(sDMSPool.getTd0Avg(systemEnvironment));
        vector2.add(sDMSPool.getTd1Avg(systemEnvironment));
        vector2.add(sDMSPool.getTd2Avg(systemEnvironment));
        vector2.add(sDMSPool.getLwAvg(systemEnvironment));
        ((Date)comparable).setTime(sDMSPool.getLastWrite(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSPool.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        ((Date)comparable).setTime(sDMSPool.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSPool.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        ((Date)comparable).setTime(sDMSPool.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format((Date)comparable));
        vector2.add(sDMSPool.getPrivileges(systemEnvironment).toString());
        vector2.add(this.listResources(systemEnvironment, l));
        vector2.add(this.listDistributionNames(systemEnvironment, l));
        vector2.add(this.listDistributions(systemEnvironment, l));
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03603161317", "Profile"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03603161318", "Pool shown"));
    }

    private SDMSOutputContainer listResources(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("RESOURCENAME");
        vector.add("RESOURCESCOPENAME");
        vector.add("TYPE");
        vector.add("IS_MANAGED");
        vector.add("NOMPCT");
        vector.add("FREEPCT");
        vector.add("MINPCT");
        vector.add("MAXPCT");
        vector.add("ACT_IS_MANAGED");
        vector.add("ACT_NOMPCT");
        vector.add("ACT_FREEPCT");
        vector.add("ACT_MINPCT");
        vector.add("ACT_MAXPCT");
        vector.add("TARGET_AMOUNT");
        vector.add("AMOUNT");
        vector.add("FREE_AMOUNT");
        vector.add("TOTAL_FREE_AMOUNT");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Vector vector2 = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSPooledResource sDMSPooledResource = (SDMSPooledResource)vector2.get(i);
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSPooledResource.getId(systemEnvironment));
            PathVector pathVector = null;
            PathVector pathVector2 = null;
            SDMSProxy sDMSProxy = sDMSPooledResource.getIsPool(systemEnvironment) != false ? SDMSPoolTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment)) : SDMSResourceTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
            pathVector = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSProxy.getNrId(systemEnvironment)).pathVector(systemEnvironment);
            pathVector2 = SDMSScopeTable.getObject(systemEnvironment, sDMSProxy.getScopeId(systemEnvironment)).pathVector(systemEnvironment);
            vector3.add(pathVector);
            vector3.add(pathVector2);
            vector3.add(sDMSPooledResource.getIsPool(systemEnvironment) != false ? "POOL" : "RESOURCE");
            vector3.add(sDMSPooledResource.getIsManaged(systemEnvironment));
            vector3.add(sDMSPooledResource.getNomPct(systemEnvironment));
            vector3.add(sDMSPooledResource.getFreePct(systemEnvironment));
            vector3.add(sDMSPooledResource.getMinPct(systemEnvironment));
            vector3.add(sDMSPooledResource.getMaxPct(systemEnvironment));
            vector3.add(sDMSPooledResource.getActIsManaged(systemEnvironment));
            vector3.add(sDMSPooledResource.getActNomPct(systemEnvironment));
            vector3.add(sDMSPooledResource.getActFreePct(systemEnvironment));
            vector3.add(sDMSPooledResource.getActMinPct(systemEnvironment));
            vector3.add(sDMSPooledResource.getActMaxPct(systemEnvironment));
            vector3.add(sDMSPooledResource.getTargetAmount(systemEnvironment));
            vector3.add(sDMSProxy.getAmount(systemEnvironment));
            vector3.add(sDMSProxy.getFreeAmount(systemEnvironment));
            vector3.add(sDMSProxy.getTotalFreeAmount(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2, 1));
        return sDMSOutputContainer;
    }

    private void listDefaultDistribution(SystemEnvironment systemEnvironment, Long l, SDMSOutputContainer sDMSOutputContainer) throws SDMSException {
        Vector vector = SDMSPooledResourceTable.idx_pId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSProxy sDMSProxy;
            SDMSPooledResource sDMSPooledResource = (SDMSPooledResource)vector.get(i);
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(null);
            vector2.add("DEFAULT");
            PathVector pathVector = null;
            PathVector pathVector2 = null;
            if (sDMSPooledResource.getIsPool(systemEnvironment).booleanValue()) {
                sDMSProxy = SDMSPoolTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
                pathVector = SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)sDMSProxy).getNrId(systemEnvironment)).pathVector(systemEnvironment);
                pathVector2 = SDMSScopeTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)sDMSProxy).getScopeId(systemEnvironment)).pathVector(systemEnvironment);
            } else {
                sDMSProxy = SDMSResourceTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
                pathVector = SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSResourceProxyGeneric)sDMSProxy).getNrId(systemEnvironment)).pathVector(systemEnvironment);
                pathVector2 = SDMSScopeTable.getObject(systemEnvironment, ((SDMSResourceProxyGeneric)sDMSProxy).getScopeId(systemEnvironment)).pathVector(systemEnvironment);
            }
            vector2.add(pathVector);
            vector2.add(pathVector2);
            vector2.add(sDMSPooledResource.getIsPool(systemEnvironment) != false ? "POOL" : "RESOURCE");
            vector2.add(sDMSPooledResource.getIsManaged(systemEnvironment));
            vector2.add(sDMSPooledResource.getNomPct(systemEnvironment));
            vector2.add(sDMSPooledResource.getFreePct(systemEnvironment));
            vector2.add(sDMSPooledResource.getMinPct(systemEnvironment));
            vector2.add(sDMSPooledResource.getMaxPct(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
    }

    private SDMSOutputContainer listDistributions(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("RESOURCENAME");
        vector.add("RESOURCESCOPENAME");
        vector.add("TYPE");
        vector.add("IS_MANAGED");
        vector.add("NOMPCT");
        vector.add("FREEPCT");
        vector.add("MINPCT");
        vector.add("MAXPCT");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Vector vector2 = SDMSPoolDistributionTable.idx_pId.getVector(systemEnvironment, l);
        this.listDefaultDistribution(systemEnvironment, l, sDMSOutputContainer);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSPoolDistribution sDMSPoolDistribution = (SDMSPoolDistribution)vector2.get(i);
            Long l2 = sDMSPoolDistribution.getId(systemEnvironment);
            String string = sDMSPoolDistribution.getName(systemEnvironment);
            Vector vector3 = SDMSPoolDistConfigTable.idx_pldId.getVector(systemEnvironment, l2);
            for (int j = 0; j < vector3.size(); ++j) {
                SDMSProxy sDMSProxy;
                SDMSPoolDistConfig sDMSPoolDistConfig = (SDMSPoolDistConfig)vector3.get(j);
                Vector<Object> vector4 = new Vector<Object>();
                vector4.add(l2);
                vector4.add(string);
                SDMSPooledResource sDMSPooledResource = SDMSPooledResourceTable.getObject(systemEnvironment, sDMSPoolDistConfig.getPrId(systemEnvironment));
                PathVector pathVector = null;
                PathVector pathVector2 = null;
                if (sDMSPooledResource.getIsPool(systemEnvironment).booleanValue()) {
                    sDMSProxy = SDMSPoolTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
                    pathVector = SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)sDMSProxy).getNrId(systemEnvironment)).pathVector(systemEnvironment);
                    pathVector2 = SDMSScopeTable.getObject(systemEnvironment, ((SDMSPoolProxyGeneric)sDMSProxy).getScopeId(systemEnvironment)).pathVector(systemEnvironment);
                } else {
                    sDMSProxy = SDMSResourceTable.getObject(systemEnvironment, sDMSPooledResource.getRId(systemEnvironment));
                    pathVector = SDMSNamedResourceTable.getObject(systemEnvironment, ((SDMSResourceProxyGeneric)sDMSProxy).getNrId(systemEnvironment)).pathVector(systemEnvironment);
                    pathVector2 = SDMSScopeTable.getObject(systemEnvironment, ((SDMSResourceProxyGeneric)sDMSProxy).getScopeId(systemEnvironment)).pathVector(systemEnvironment);
                }
                vector4.add(pathVector);
                vector4.add(pathVector2);
                vector4.add(sDMSPooledResource.getIsPool(systemEnvironment) != false ? "POOL" : "RESOURCE");
                vector4.add(sDMSPoolDistConfig.getIsManaged(systemEnvironment));
                vector4.add(sDMSPoolDistConfig.getNomPct(systemEnvironment));
                vector4.add(sDMSPoolDistConfig.getFreePct(systemEnvironment));
                vector4.add(sDMSPoolDistConfig.getMinPct(systemEnvironment));
                vector4.add(sDMSPoolDistConfig.getMaxPct(systemEnvironment));
                sDMSOutputContainer.addData(systemEnvironment, vector4);
            }
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, new int[]{1, 3, 2}));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer listDistributionNames(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Vector vector2 = SDMSPoolDistributionTable.idx_pId.getVector(systemEnvironment, l);
        Vector<Object> vector3 = new Vector<Object>();
        vector3.add(null);
        vector3.add("DEFAULT");
        sDMSOutputContainer.addData(systemEnvironment, vector3);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSPoolDistribution sDMSPoolDistribution = (SDMSPoolDistribution)vector2.get(i);
            vector3 = new Vector();
            vector3.add(sDMSPoolDistribution.getId(systemEnvironment));
            vector3.add(sDMSPoolDistribution.getName(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }
}

