/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinition;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMapping;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateMappingTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

public class ShowRsm
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowRsm.java,v 2.4.8.2 2013/06/18 09:49:37 ronald Exp $";
    String name;

    public ShowRsm(String string) {
        this.txMode = 1;
        this.auditFlag = false;
        this.name = string;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        SDMSResourceStateMappingProfile sDMSResourceStateMappingProfile = SDMSResourceStateMappingProfileTable.idx_name_getUnique(systemEnvironment, this.name);
        if (!sDMSResourceStateMappingProfile.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411721", "Insufficient privileges"));
        }
        Long l = sDMSResourceStateMappingProfile.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("MAPPINGS");
        Vector<Object> vector2 = new Vector<Object>();
        vector2.add(l);
        vector2.add(sDMSResourceStateMappingProfile.getName(systemEnvironment));
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSResourceStateMappingProfile.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSResourceStateMappingProfile.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSResourceStateMappingProfile.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSResourceStateMappingProfile.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSResourceStateMappingProfile.getPrivileges(systemEnvironment).toString());
        Vector<String> vector3 = new Vector<String>();
        vector3.add("ESD_NAME");
        vector3.add("RSD_FROM");
        vector3.add("RSD_TO");
        SDMSOutputContainer sDMSOutputContainer2 = new SDMSOutputContainer(systemEnvironment, null, vector3);
        Vector vector4 = SDMSResourceStateMappingTable.idx_rsmpId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector4.size(); ++i) {
            SDMSResourceStateDefinition sDMSResourceStateDefinition;
            SDMSResourceStateMapping sDMSResourceStateMapping = (SDMSResourceStateMapping)vector4.get(i);
            Vector<String> vector5 = new Vector<String>();
            SDMSExitStateDefinition sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, sDMSResourceStateMapping.getEsdId(systemEnvironment));
            vector5.add(sDMSExitStateDefinition.getName(systemEnvironment));
            Long l2 = sDMSResourceStateMapping.getFromRsdId(systemEnvironment);
            if (l2 == null) {
                vector5.add("ANY");
            } else {
                sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l2);
                vector5.add(sDMSResourceStateDefinition.getName(systemEnvironment));
            }
            l2 = sDMSResourceStateMapping.getToRsdId(systemEnvironment);
            sDMSResourceStateDefinition = SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l2);
            vector5.add(sDMSResourceStateDefinition.getName(systemEnvironment));
            sDMSOutputContainer2.addData(systemEnvironment, vector5);
        }
        Collections.sort(sDMSOutputContainer2.dataset, sDMSOutputContainer2.getComparator(systemEnvironment, 0, 1));
        vector2.add(sDMSOutputContainer2);
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03204021426", "Resource State Mapping"), vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03204021427", "Resource State Mapping shown"));
    }
}

