/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.filter.Comparer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class LikeComparer
extends Comparer {
    Pattern p;

    LikeComparer(SystemEnvironment systemEnvironment, Comparable comparable) throws SDMSException {
        super(systemEnvironment, comparable);
        if (comparable == null) {
            this.p = null;
        }
        try {
            this.p = Pattern.compile(comparable.toString());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03511030959", "Error in regular expression"));
        }
    }

    @Override
    boolean cmp(Comparable comparable) {
        if (comparable == null) {
            return false;
        }
        if (this.p == null) {
            return false;
        }
        try {
            Matcher matcher = this.p.matcher((String)((Object)comparable));
            return matcher.matches();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

