/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSCalendar;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.util.PathVector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class NamelistFilter
extends Filter {
    Vector paths;
    HashSet pathStrings = null;

    public NamelistFilter(SystemEnvironment systemEnvironment, Vector vector) {
        this.paths = vector;
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            if (this.pathStrings == null) {
                this.fillPathstrings();
            }
            Long l = null;
            long l2 = systemEnvironment.tx.versionId;
            if (sDMSProxy instanceof SDMSSubmittedEntity) {
                SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
                l2 = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
                l = sDMSSubmittedEntity.getSeId(systemEnvironment);
            } else if (sDMSProxy instanceof SDMSCalendar) {
                SDMSScheduledEvent sDMSScheduledEvent = SDMSScheduledEventTable.getObject(systemEnvironment, ((SDMSCalendar)sDMSProxy).getScevId(systemEnvironment));
                SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, sDMSScheduledEvent.getEvtId(systemEnvironment));
                l = sDMSEvent.getSeId(systemEnvironment);
            } else if (sDMSProxy instanceof SDMSScheduledEvent) {
                SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, ((SDMSScheduledEvent)sDMSProxy).getEvtId(systemEnvironment));
                l = sDMSEvent.getSeId(systemEnvironment);
            }
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l, l2);
            if (this.pathStrings.contains(sDMSSchedulingEntity.pathString(systemEnvironment, l2))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void fillPathstrings() {
        if (this.pathStrings == null) {
            this.pathStrings = new HashSet();
            for (int i = 0; i < this.paths.size(); ++i) {
                this.pathStrings.add(((PathVector)this.paths.get(i)).toString());
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NamelistFilter)) {
            return false;
        }
        NamelistFilter namelistFilter = (NamelistFilter)object;
        if (this.paths.size() != namelistFilter.paths.size()) {
            return false;
        }
        if (this.pathStrings == null) {
            this.fillPathstrings();
        }
        if (namelistFilter.pathStrings == null) {
            namelistFilter.fillPathstrings();
        }
        Iterator iterator = this.pathStrings.iterator();
        while (iterator.hasNext()) {
            if (namelistFilter.pathStrings.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }
}

