/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.filter;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.filter.Filter;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;

public class WarningFilter
extends Filter {
    boolean isWarning;

    public WarningFilter(SystemEnvironment systemEnvironment, Boolean bl) {
        this.isWarning = bl;
    }

    @Override
    public boolean valid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
        try {
            SDMSSubmittedEntity sDMSSubmittedEntity = (SDMSSubmittedEntity)sDMSProxy;
            if (sDMSSubmittedEntity.getWarnCount(systemEnvironment) > 0) {
                return this.isWarning;
            }
            return !this.isWarning;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WarningFilter)) {
            return false;
        }
        WarningFilter warningFilter = (WarningFilter)object;
        return this.isWarning == warningFilter.isWarning;
    }
}

