/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.timer.TimerDate;

class BlockState
implements Cloneable {
    public long baseStart;
    public long baseEnd;
    public long blockStart;
    public long blockEnd;
    public int blockIdx;

    public BlockState() {
        this.clear();
    }

    public BlockState(BlockState blockState) {
        this.baseStart = blockState.baseStart;
        this.baseEnd = blockState.baseEnd;
        this.blockStart = blockState.blockStart;
        this.blockEnd = blockState.blockEnd;
        this.blockIdx = blockState.blockIdx;
    }

    public void copyFrom(BlockState blockState) {
        this.baseStart = blockState.baseStart;
        this.baseEnd = blockState.baseEnd;
        this.blockStart = blockState.blockStart;
        this.blockEnd = blockState.blockEnd;
        this.blockIdx = blockState.blockIdx;
    }

    public void clear() {
        this.baseStart = -1L;
        this.baseEnd = -1L;
        this.blockStart = -1L;
        this.blockEnd = -1L;
        this.blockIdx = 0;
    }

    public Object clone() {
        return new BlockState(this);
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "    ";
        }
        return string + "blockState [\n" + string + "\tbaseStart : " + new TimerDate((int)(this.baseStart / 60000L)).toString() + "\n" + string + "\tbaseEnd   : " + new TimerDate((int)(this.baseEnd / 60000L)).toString() + "\n" + string + "\tblockStart: " + new TimerDate((int)(this.blockStart / 60000L)).toString() + "\n" + string + "\tblockEnd  : " + new TimerDate((int)(this.blockEnd / 60000L)).toString() + "\n" + string + "\tblockIdx  : " + this.blockIdx + "\n" + string + "]";
    }

    public boolean equals(BlockState blockState) {
        return this.baseStart == blockState.baseStart && this.baseEnd == blockState.baseEnd && this.blockStart == blockState.blockStart && this.blockEnd == blockState.blockEnd && this.blockIdx == blockState.blockIdx;
    }
}

