/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ManipParameters;
import de.independit.scheduler.server.repository.FolderVariableResolver;
import de.independit.scheduler.server.repository.SDMSFolderProxyGeneric;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSNiceProfile;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntry;
import de.independit.scheduler.server.repository.SDMSNiceProfileEntryTable;
import de.independit.scheduler.server.repository.SDMSNiceProfileTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityProxyGeneric;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSUser;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.VariableResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class SDMSFolder
extends SDMSFolderProxyGeneric
implements SDMSOwnedObject {
    public static final String __version = "@(#) $Id: SDMSFolder.java,v 2.16.2.5 2013/03/19 17:16:51 ronald Exp $";
    private static final VariableResolver FVR = new FolderVariableResolver();
    private static final Long lzero = new Long(0L);
    private static final Integer zero = new Integer(0);
    private static final Float fzero = new Float(0.0f);

    protected SDMSFolder(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    public SDMSFolder copy(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        if (!this.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "03402291137"));
        }
        HashMap hashMap = new HashMap();
        SDMSFolder sDMSFolder = this.copy(systemEnvironment, l, string, hashMap);
        sDMSFolder.relocateEntityDetails(systemEnvironment, hashMap);
        return sDMSFolder;
    }

    public SDMSFolder copy(SystemEnvironment systemEnvironment, Long l, String string, HashMap hashMap) throws SDMSException {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Long l2 = this.getId(systemEnvironment);
        SDMSUser sDMSUser = SDMSUserTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
        SDMSFolder sDMSFolder = SDMSFolderTable.table.create(systemEnvironment, string, sDMSUser.getDefaultGId(systemEnvironment), this.getEnvId(systemEnvironment), l, this.getInheritPrivs(systemEnvironment));
        Long l3 = sDMSFolder.getId(systemEnvironment);
        ManipParameters.copy(systemEnvironment, l2, l3);
        Vector vector = SDMSFolderTable.idx_parentId.getVector(systemEnvironment, l2);
        for (Object object42 : vector) {
            if (!((SDMSFolderProxyGeneric)object42).checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "03402291134"));
            }
            ((SDMSFolder)object42).copy(systemEnvironment, l3, ((SDMSFolderProxyGeneric)object42).getName(systemEnvironment), hashMap);
        }
        object42 = SDMSSchedulingEntityTable.idx_folderId.getVector(systemEnvironment, l2);
        Iterator iterator = ((Vector)object42).iterator();
        while (iterator.hasNext()) {
            object3 = (SDMSSchedulingEntity)iterator.next();
            if (!((SDMSSchedulingEntityProxyGeneric)object3).checkPrivileges(systemEnvironment, 0x10000000L)) {
                throw new AccessViolationException(this.accessViolationMessage(systemEnvironment, "03402291135"));
            }
            object2 = ((SDMSSchedulingEntity)object3).copy(systemEnvironment, l3, ((SDMSSchedulingEntityProxyGeneric)object3).getName(systemEnvironment), hashMap);
            hashMap.put(((SDMSProxy)object3).getId(systemEnvironment), ((SDMSProxy)object2).getId(systemEnvironment));
        }
        object3 = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l2);
        object2 = ((Vector)object3).iterator();
        while (object2.hasNext()) {
            object = (SDMSResource)object2.next();
            SDMSResource sDMSResource = SDMSResourceTable.table.create(systemEnvironment, ((SDMSResourceProxyGeneric)object).getNrId(systemEnvironment), l3, ((SDMSResourceProxyGeneric)object).getMasterId(systemEnvironment), ((SDMSResourceProxyGeneric)object).getOwnerId(systemEnvironment), ((SDMSResourceProxyGeneric)object).getLinkId(systemEnvironment), null, ((SDMSResource)object).getTag(systemEnvironment), ((SDMSResource)object).getRsdId(systemEnvironment), ((SDMSResource)object).getRsdTime(systemEnvironment), ((SDMSResource)object).getDefinedAmount(systemEnvironment), ((SDMSResource)object).getRequestableAmount(systemEnvironment), ((SDMSResource)object).getDefinedAmount(systemEnvironment), ((SDMSResource)object).getDefinedAmount(systemEnvironment), ((SDMSResource)object).getIsOnline(systemEnvironment), ((SDMSResource)object).getFactor(systemEnvironment), ((SDMSResource)object).getTraceInterval(systemEnvironment), ((SDMSResource)object).getTraceBase(systemEnvironment), ((SDMSResource)object).getTraceBaseMultiplier(systemEnvironment), fzero, fzero, fzero, fzero, lzero, lzero);
            ((SDMSResource)object).copyVariables(systemEnvironment, sDMSResource.getId(systemEnvironment));
        }
        object = SDMSObjectCommentTable.idx_objectId.getVector(systemEnvironment, l2);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            SDMSObjectComment sDMSObjectComment = (SDMSObjectComment)((Vector)object).get(i);
            SDMSObjectCommentTable.table.create(systemEnvironment, l3, sDMSObjectComment.getObjectType(systemEnvironment), sDMSObjectComment.getInfoType(systemEnvironment), sDMSObjectComment.getSequenceNumber(systemEnvironment), sDMSObjectComment.getTag(systemEnvironment), sDMSObjectComment.getDescription(systemEnvironment));
        }
        return sDMSFolder;
    }

    public void relocateEntityDetails(SystemEnvironment systemEnvironment, HashMap hashMap) throws SDMSException {
        Object object2;
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSFolderTable.idx_parentId.getVector(systemEnvironment, l);
        for (Object object2 : vector) {
            ((SDMSFolder)object2).relocateEntityDetails(systemEnvironment, hashMap);
        }
        object2 = SDMSSchedulingEntityTable.idx_folderId.getVector(systemEnvironment, l);
        Iterator iterator = ((Vector)object2).iterator();
        while (iterator.hasNext()) {
            SDMSSchedulingEntity sDMSSchedulingEntity = (SDMSSchedulingEntity)iterator.next();
            sDMSSchedulingEntity.relocateDetails(systemEnvironment, hashMap);
        }
    }

    public void collectSeIds(SystemEnvironment systemEnvironment, HashSet<Long> hashSet, HashSet<Long> hashSet2) throws SDMSException {
        Object object;
        Object object22;
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSSchedulingEntityTable.idx_folderId.getVector(systemEnvironment, l);
        for (Object object22 : vector) {
            object = ((SDMSProxy)object22).getId(systemEnvironment);
            if (hashSet2 != null && hashSet2.contains(object)) continue;
            hashSet.add(((SDMSProxy)object22).getId(systemEnvironment));
        }
        object22 = SDMSFolderTable.idx_parentId.getVector(systemEnvironment, l);
        object = ((Vector)object22).iterator();
        while (object.hasNext()) {
            SDMSFolder sDMSFolder = (SDMSFolder)object.next();
            sDMSFolder.collectSeIds(systemEnvironment, hashSet, hashSet2);
        }
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        boolean bl = this.delete(systemEnvironment, null);
    }

    public void deleteCascade(SystemEnvironment systemEnvironment, HashSet hashSet) throws SDMSException {
        Vector vector = SDMSFolderTable.idx_parentId.getVector(systemEnvironment, this.getId(systemEnvironment));
        for (SDMSFolder sDMSFolder : vector) {
            sDMSFolder.deleteCascade(systemEnvironment, hashSet);
        }
        boolean bl = this.delete(systemEnvironment, hashSet);
    }

    public boolean delete(SystemEnvironment systemEnvironment, HashSet hashSet) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        boolean bl = this.dropResources(systemEnvironment, hashSet);
        if (bl && (hashSet == null || !hashSet.contains(l))) {
            if (SDMSFolderTable.idx_parentId.containsKey(systemEnvironment, l)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112191517", "Folder $1 not empty", (Object)this.pathString(systemEnvironment)));
            }
            if (SDMSSchedulingEntityTable.idx_folderId.containsKey(systemEnvironment, l)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03112191519", "Folder $1 not empty", (Object)this.pathString(systemEnvironment)));
            }
            ManipParameters.kill(systemEnvironment, l);
            Vector vector = SDMSNiceProfileEntryTable.idx_folderId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector.size(); ++i) {
                SDMSNiceProfileEntry sDMSNiceProfileEntry = (SDMSNiceProfileEntry)vector.get(i);
                if (sDMSNiceProfileEntry.getIsActive(systemEnvironment).booleanValue()) {
                    SDMSNiceProfile sDMSNiceProfile = SDMSNiceProfileTable.getObject(systemEnvironment, sDMSNiceProfileEntry.getNpId(systemEnvironment));
                    if (!sDMSNiceProfile.getIsActive(systemEnvironment).booleanValue()) {
                        sDMSNiceProfileEntry.delete(systemEnvironment);
                        continue;
                    }
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03408211524", "Folder $1 is addressed by active Nice Profile $2", (Object)this.pathString(systemEnvironment), (Object)sDMSNiceProfile.getName(systemEnvironment)));
                }
                sDMSNiceProfileEntry.delete(systemEnvironment);
            }
            super.delete(systemEnvironment);
        }
        return bl;
    }

    public void dropResources(SystemEnvironment systemEnvironment) throws SDMSException {
        boolean bl = this.dropResources(systemEnvironment, null);
    }

    public boolean dropResources(SystemEnvironment systemEnvironment, HashSet hashSet) throws SDMSException {
        boolean bl = true;
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSResource sDMSResource = (SDMSResource)vector.get(i);
            if (hashSet != null && hashSet.contains(sDMSResource.getId(systemEnvironment))) {
                bl = false;
                continue;
            }
            sDMSResource.delete(systemEnvironment);
        }
        return bl;
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        return FVR.getVariableValue(systemEnvironment, (SDMSProxy)this, string, -1L);
    }

    public String getVariableValue(SystemEnvironment systemEnvironment, String string, long l) throws SDMSException {
        return FVR.getVariableValue(systemEnvironment, (SDMSProxy)this, string, l);
    }

    @Override
    public String getURLName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pathString(systemEnvironment);
    }

    @Override
    public String getURL(SystemEnvironment systemEnvironment) throws SDMSException {
        return "folder " + this.getURLName(systemEnvironment);
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2 = super.getPrivileges(systemEnvironment, l, bl, vector);
        if (systemEnvironment.cEnv.isUser() && this.getParentId(systemEnvironment) == null) {
            l2 |= 0x10000000L;
        }
        return l2 & l;
    }
}

