/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPoolDistConfig;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigGeneric;
import de.independit.scheduler.server.repository.SDMSPoolDistConfigTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSPoolDistConfigTableGeneric
extends SDMSTable {
    public static final String tableName = "POOL_DIST_CONFIG";
    public static SDMSPoolDistConfigTable table = null;
    public static final String[] columnNames = new String[]{"ID", "PLD_ID", "PR_ID", "IS_MANAGED", "NOM_PCT", "FREE_PCT", "MIN_PCT", "MAX_PCT", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_pldId;
    public static SDMSIndex idx_prId;
    public static SDMSIndex idx_pldId_prId;

    public SDMSPoolDistConfigTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "PoolDistConfig"));
        }
        table = (SDMSPoolDistConfigTable)this;
        table = (SDMSPoolDistConfigTable)this;
        this.isVersioned = false;
        idx_pldId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "pldId");
        idx_prId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "prId");
        idx_pldId_prId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "pldId_prId");
    }

    public SDMSPoolDistConfig create(SystemEnvironment systemEnvironment, Long l, Long l2, Boolean bl, Integer n, Integer n2, Integer n3, Integer n4) throws SDMSException {
        SDMSPoolDistConfig sDMSPoolDistConfig;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "PoolDistConfig"));
        }
        this.validate(systemEnvironment, l, l2, bl, n, n2, n3, n4, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSPoolDistConfigGeneric sDMSPoolDistConfigGeneric = new SDMSPoolDistConfigGeneric(systemEnvironment, l, l2, bl, n, n2, n3, n4, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSPoolDistConfigGeneric.versions, true);
            table.put(systemEnvironment, sDMSPoolDistConfigGeneric.id, sDMSPoolDistConfigGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSPoolDistConfig = (SDMSPoolDistConfig)sDMSPoolDistConfigGeneric.toProxy(systemEnvironment);
            sDMSPoolDistConfig.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSPoolDistConfig sDMSPoolDistConfig2 = (SDMSPoolDistConfig)sDMSPoolDistConfigGeneric.toProxy(systemEnvironment);
            sDMSPoolDistConfig2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSPoolDistConfig)) {
            throw new AccessViolationException(sDMSPoolDistConfig.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSPoolDistConfig.touchMaster(systemEnvironment);
        return sDMSPoolDistConfig;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSPoolDistConfig sDMSPoolDistConfig) throws SDMSException {
        return sDMSPoolDistConfig.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Boolean bl, Integer n, Integer n2, Integer n3, Integer n4, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Boolean bl;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = new Long(resultSet.getLong(1));
            l8 = new Long(resultSet.getLong(2));
            l7 = new Long(resultSet.getLong(3));
            bl = new Boolean(resultSet.getInt(4) != 0);
            if (resultSet.wasNull()) {
                bl = null;
            }
            n4 = new Integer(resultSet.getInt(5));
            if (resultSet.wasNull()) {
                n4 = null;
            }
            n3 = new Integer(resultSet.getInt(6));
            if (resultSet.wasNull()) {
                n3 = null;
            }
            n2 = new Integer(resultSet.getInt(7));
            if (resultSet.wasNull()) {
                n2 = null;
            }
            n = new Integer(resultSet.getInt(8));
            if (resultSet.wasNull()) {
                n = null;
            }
            l6 = new Long(resultSet.getLong(9));
            l5 = new Long(resultSet.getLong(10));
            l4 = new Long(resultSet.getLong(11));
            l3 = new Long(resultSet.getLong(12));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "PoolDistConfig: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSPoolDistConfigGeneric(l9, l8, l7, bl, n4, n3, n2, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "PLD_ID" + string2 + ", " + string + "PR_ID" + string2 + ", " + string + "IS_MANAGED" + string2 + ", " + string + "NOM_PCT" + string2 + ", " + string + "FREE_PCT" + string2 + ", " + string + "MIN_PCT" + string2 + ", " + string + "MAX_PCT" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_pldId.check(((SDMSPoolDistConfigGeneric)sDMSObject).pldId, sDMSObject);
        string = string + "idx_pldId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_prId.check(((SDMSPoolDistConfigGeneric)sDMSObject).prId, sDMSObject);
        string = string + "idx_prId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSPoolDistConfigGeneric)sDMSObject).pldId);
        sDMSKey.add(((SDMSPoolDistConfigGeneric)sDMSObject).prId);
        bl = idx_pldId_prId.check(sDMSKey, sDMSObject);
        string = string + "idx_pldId_prId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_pldId.put(systemEnvironment, ((SDMSPoolDistConfigGeneric)sDMSObject).pldId, sDMSObject, (1L & l) != 0L);
        idx_prId.put(systemEnvironment, ((SDMSPoolDistConfigGeneric)sDMSObject).prId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSPoolDistConfigGeneric)sDMSObject).pldId);
        sDMSKey.add(((SDMSPoolDistConfigGeneric)sDMSObject).prId);
        idx_pldId_prId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_pldId.remove(systemEnvironment, ((SDMSPoolDistConfigGeneric)sDMSObject).pldId, sDMSObject);
        idx_prId.remove(systemEnvironment, ((SDMSPoolDistConfigGeneric)sDMSObject).prId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSPoolDistConfigGeneric)sDMSObject).pldId);
        sDMSKey.add(((SDMSPoolDistConfigGeneric)sDMSObject).prId);
        idx_pldId_prId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSPoolDistConfig getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSPoolDistConfig)table.get(systemEnvironment, l);
    }

    public static SDMSPoolDistConfig getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSPoolDistConfig)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSPoolDistConfig getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSPoolDistConfig)table.get(systemEnvironment, l, l2);
    }

    public static SDMSPoolDistConfig idx_pldId_prId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSPoolDistConfig)idx_pldId_prId.getUnique(systemEnvironment, object);
    }

    public static SDMSPoolDistConfig idx_pldId_prId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSPoolDistConfig)idx_pldId_prId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSPoolDistConfig idx_pldId_prId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSPoolDistConfig)idx_pldId_prId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

