/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPoolDistribution;
import de.independit.scheduler.server.repository.SDMSPoolDistributionGeneric;
import de.independit.scheduler.server.repository.SDMSPoolDistributionTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSPoolDistributionTableGeneric
extends SDMSTable {
    public static final String tableName = "POOL_DISTRIBUTION";
    public static SDMSPoolDistributionTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "P_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_pId;
    public static SDMSIndex idx_name_pId;

    public SDMSPoolDistributionTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "PoolDistribution"));
        }
        table = (SDMSPoolDistributionTable)this;
        table = (SDMSPoolDistributionTable)this;
        this.isVersioned = false;
        idx_pId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "pId");
        idx_name_pId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name_pId");
    }

    public SDMSPoolDistribution create(SystemEnvironment systemEnvironment, String string, Long l) throws SDMSException {
        SDMSPoolDistribution sDMSPoolDistribution;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "PoolDistribution"));
        }
        this.validate(systemEnvironment, string, l, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSPoolDistributionGeneric sDMSPoolDistributionGeneric = new SDMSPoolDistributionGeneric(systemEnvironment, string, l, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSPoolDistributionGeneric.versions, true);
            table.put(systemEnvironment, sDMSPoolDistributionGeneric.id, sDMSPoolDistributionGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSPoolDistribution = (SDMSPoolDistribution)sDMSPoolDistributionGeneric.toProxy(systemEnvironment);
            sDMSPoolDistribution.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSPoolDistribution sDMSPoolDistribution2 = (SDMSPoolDistribution)sDMSPoolDistributionGeneric.toProxy(systemEnvironment);
            sDMSPoolDistribution2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSPoolDistribution)) {
            throw new AccessViolationException(sDMSPoolDistribution.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSPoolDistribution.touchMaster(systemEnvironment);
        return sDMSPoolDistribution;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSPoolDistribution sDMSPoolDistribution) throws SDMSException {
        return sDMSPoolDistribution.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        String string;
        Long l8;
        try {
            l8 = new Long(resultSet.getLong(1));
            string = resultSet.getString(2);
            l7 = new Long(resultSet.getLong(3));
            l6 = new Long(resultSet.getLong(4));
            l5 = new Long(resultSet.getLong(5));
            l4 = new Long(resultSet.getLong(6));
            l3 = new Long(resultSet.getLong(7));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "PoolDistribution: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSPoolDistributionGeneric(l8, string, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "P_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_pId.check(((SDMSPoolDistributionGeneric)sDMSObject).pId, sDMSObject);
        string = string + "idx_pId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSPoolDistributionGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSPoolDistributionGeneric)sDMSObject).pId);
        bl = idx_name_pId.check(sDMSKey, sDMSObject);
        string = string + "idx_name_pId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_pId.put(systemEnvironment, ((SDMSPoolDistributionGeneric)sDMSObject).pId, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSPoolDistributionGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSPoolDistributionGeneric)sDMSObject).pId);
        idx_name_pId.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_pId.remove(systemEnvironment, ((SDMSPoolDistributionGeneric)sDMSObject).pId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add((Comparable)((Object)((SDMSPoolDistributionGeneric)sDMSObject).name));
        sDMSKey.add(((SDMSPoolDistributionGeneric)sDMSObject).pId);
        idx_name_pId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSPoolDistribution getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSPoolDistribution)table.get(systemEnvironment, l);
    }

    public static SDMSPoolDistribution getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSPoolDistribution)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSPoolDistribution getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSPoolDistribution)table.get(systemEnvironment, l, l2);
    }

    public static SDMSPoolDistribution idx_name_pId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSPoolDistribution)idx_name_pId.getUnique(systemEnvironment, object);
    }

    public static SDMSPoolDistribution idx_name_pId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSPoolDistribution)idx_name_pId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSPoolDistribution idx_name_pId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSPoolDistribution)idx_name_pId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

