/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import java.util.HashMap;
import java.util.Vector;

public class SDMSPrivilege {
    public static final String __version = "@(#) $Id: SDMSPrivilege.java,v 2.8.4.1 2013/03/14 10:25:22 ronald Exp $";
    public static final String S_CREATE_CONTENT = "C";
    public static final String S_DROP = "D";
    public static final String S_EDIT = "E";
    public static final String S_GRANT = "G";
    public static final String S_CREATE = "K";
    public static final String S_MONITOR = "M";
    public static final String S_OPERATE = "O";
    public static final String S_CREATE_PARENT_CONTENT = "P";
    public static final String S_RESOURCE = "R";
    public static final String S_SUBMIT = "S";
    public static final String S_USE = "U";
    public static final String S_VIEW = "V";
    public static final String S_EXECUTE = "X";
    public static final long CREATE = 1L;
    public static final long CREATE_CONTENT = 2L;
    public static final long CREATE_PARENT_CONTENT = 4L;
    public static final long RESOURCE = 8L;
    public static final long DROP = 16L;
    public static final long EDIT = 256L;
    public static final long MONITOR = 4096L;
    public static final long OPERATE = 65536L;
    public static final long SUBMIT = 0x100000L;
    public static final long USE = 0x1000000L;
    public static final long VIEW = 0x10000000L;
    public static final long EXECUTE = 0x100000000L;
    public static final long GRANT = 0x200000000L;
    public static final long MANAGE_USER = 0x400000000L;
    public static final long MANAGE_GROUP = 0x800000000L;
    public static final long MANAGE_ESD = 0x1000000000L;
    public static final long MANAGE_ESP = 0x2000000000L;
    public static final long MANAGE_ESM = 0x4000000000L;
    public static final long MANAGE_EST = 0x8000000000L;
    public static final long MANAGE_RSD = 0x10000000000L;
    public static final long MANAGE_RSP = 0x20000000000L;
    public static final long MANAGE_RSM = 0x40000000000L;
    public static final long MANAGE_FP = 0x80000000000L;
    public static final long MANAGE_ENV = 0x100000000000L;
    public static final long MANAGE_SYS = 0x200000000000L;
    public static final long MANAGE_SEL = 0x400000000000L;
    public static final long MANAGE_NP = 0x800000000000L;
    private static final long VALID_BITS = 0xFFFF1111111FL;
    private static final long INVALID_BITS = -281470968074528L;
    public static final long ALL = 0x31111111BL;
    public static final long MANAGE_ALL = 0xFFFC00000000L;
    public static final long[] MANAGE_PRIVS = new long[]{0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L};
    public static final long NOPRIVS = 0L;
    public static final Long SYSPRIVOBJID = new Long(0L);
    private long priv;
    private static final HashMap mapper = new HashMap();

    public SDMSPrivilege() {
        this.priv = 0L;
    }

    public SDMSPrivilege(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        if ((l & 0xFFFF0000EEEEEEE0L) != 0L) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03708061541", "Trying to use invalid privileges"));
        }
        this.priv = l;
    }

    public static Long map(Integer n) {
        return (Long)mapper.get(n);
    }

    public void addPriv(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        if ((l & 0xFFFF0000EEEEEEE0L) != 0L) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03402101453", "Trying to use invalid privileges"));
        }
        this.priv |= l;
    }

    public void addPriv(SystemEnvironment systemEnvironment, SDMSPrivilege sDMSPrivilege) throws SDMSException {
        this.priv |= sDMSPrivilege.priv;
    }

    public void delPriv(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        if ((l & 0xFFFF0000EEEEEEE0L) != 0L) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03402101459", "Trying to use invalid privileges"));
        }
        this.priv &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void setPriv(SystemEnvironment systemEnvironment, long l) throws SDMSException {
        if ((l & 0xFFFF0000EEEEEEE0L) != 0L) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03402111239", "Trying to use invalid privileges"));
        }
        this.priv = l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.priv & 1L) == 1L) {
            stringBuffer.append(S_CREATE);
        }
        if ((this.priv & 2L) == 2L) {
            stringBuffer.append(S_CREATE_CONTENT);
        }
        if ((this.priv & 4L) == 4L) {
            stringBuffer.append(S_CREATE_PARENT_CONTENT);
        }
        if ((this.priv & 0x10L) == 16L) {
            stringBuffer.append(S_DROP);
        }
        if ((this.priv & 0x100L) == 256L) {
            stringBuffer.append(S_EDIT);
        }
        if ((this.priv & 0x1000L) == 4096L) {
            stringBuffer.append(S_MONITOR);
        }
        if ((this.priv & 0x10000L) == 65536L) {
            stringBuffer.append(S_OPERATE);
        }
        if ((this.priv & 0x100000L) == 0x100000L) {
            stringBuffer.append(S_SUBMIT);
        }
        if ((this.priv & 0x1000000L) == 0x1000000L) {
            stringBuffer.append(S_USE);
        }
        if ((this.priv & 0x10000000L) == 0x10000000L) {
            stringBuffer.append(S_VIEW);
        }
        if ((this.priv & 0x200000000L) == 0x200000000L) {
            stringBuffer.append(S_GRANT);
        }
        if ((this.priv & 8L) == 8L) {
            stringBuffer.append(S_RESOURCE);
        }
        if ((this.priv & 0x100000000L) == 0x100000000L) {
            stringBuffer.append(S_EXECUTE);
        }
        return new String(stringBuffer);
    }

    public String[] asString() {
        Vector<String> vector = new Vector<String>();
        if ((this.priv & 1L) == 1L) {
            vector.add("CREATE");
        }
        if ((this.priv & 2L) == 2L) {
            vector.add("CREATE CONTENT");
        }
        if ((this.priv & 4L) == 4L) {
            vector.add("CREATE PARENT CONTENT");
        }
        if ((this.priv & 0x10L) == 16L) {
            vector.add("DROP");
        }
        if ((this.priv & 0x100L) == 256L) {
            vector.add("EDIT");
        }
        if ((this.priv & 0x1000L) == 4096L) {
            vector.add("MONITOR");
        }
        if ((this.priv & 0x10000L) == 65536L) {
            vector.add("OPERATE");
        }
        if ((this.priv & 0x100000L) == 0x100000L) {
            vector.add("SUBMIT");
        }
        if ((this.priv & 0x1000000L) == 0x1000000L) {
            vector.add("USE");
        }
        if ((this.priv & 0x10000000L) == 0x10000000L) {
            vector.add("VIEW");
        }
        if ((this.priv & 8L) == 8L) {
            vector.add("RESOURCE");
        }
        if ((this.priv & 0x100000000L) == 0x100000000L) {
            vector.add("EXECUTE");
        }
        if ((this.priv & 0x400000000L) == 0x400000000L) {
            vector.add("MANAGE USER");
        }
        if ((this.priv & 0x800000000L) == 0x800000000L) {
            vector.add("MANAGE GROUP");
        }
        if ((this.priv & 0x1000000000L) == 0x1000000000L) {
            vector.add("MANAGE EXIT STATE DEFINITION");
        }
        if ((this.priv & 0x2000000000L) == 0x2000000000L) {
            vector.add("MANAGE EXIT STATE PROFILE");
        }
        if ((this.priv & 0x4000000000L) == 0x4000000000L) {
            vector.add("MANAGE EXIT STATE MAPPING");
        }
        if ((this.priv & 0x8000000000L) == 0x8000000000L) {
            vector.add("MANAGE EXIT STATE DEFINITION");
        }
        if ((this.priv & 0x10000000000L) == 0x10000000000L) {
            vector.add("MANAGE RESOURCE STATE DEFINITION");
        }
        if ((this.priv & 0x20000000000L) == 0x20000000000L) {
            vector.add("MANAGE RESOURCE STATE PROFILE");
        }
        if ((this.priv & 0x40000000000L) == 0x40000000000L) {
            vector.add("MANAGE RESOURCE STATE MAPPING");
        }
        if ((this.priv & 0x80000000000L) == 0x80000000000L) {
            vector.add("MANAGE FOOTPRINT");
        }
        if ((this.priv & 0x100000000000L) == 0x100000000000L) {
            vector.add("MANAGE ENVIRONMENT");
        }
        if ((this.priv & 0x200000000000L) == 0x200000000000L) {
            vector.add("MANAGE SYSTEM");
        }
        if ((this.priv & 0x400000000000L) == 0x400000000000L) {
            vector.add("MANAGE SELECT");
        }
        if ((this.priv & 0x800000000000L) == 0x800000000000L) {
            vector.add("MANAGE NICE PROFILE");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Long toLong() {
        return new Long(this.priv);
    }

    public void merge(SDMSPrivilege sDMSPrivilege) {
        this.priv &= sDMSPrivilege.priv;
    }

    public void merge(long l) {
        this.priv &= l;
    }

    public boolean can(long l) {
        return (this.priv & l) == l;
    }

    public boolean isEmpty() {
        return this.priv == 0L;
    }

    static {
        mapper.put(new Integer(622), new Long(0x10000000L));
        mapper.put(new Integer(618), new Long(0x1000000L));
        mapper.put(new Integer(343), new Long(256L));
        mapper.put(new Integer(339), new Long(16L));
        mapper.put(new Integer(581), new Long(0x100000L));
        mapper.put(new Integer(317), new Long(2L));
        mapper.put(new Integer(466), new Long(4096L));
        mapper.put(new Integer(497), new Long(65536L));
        mapper.put(new Integer(532), new Long(8L));
        mapper.put(new Integer(355), new Long(0x100000000L));
    }
}

