/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleGeneric;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class SDMSScheduleTableGeneric
extends SDMSTable {
    public static final String tableName = "SCHEDULE";
    public static SDMSScheduleTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "OWNER_ID", "INT_ID", "PARENT_ID", "TIME_ZONE", "SE_ID", "ACTIVE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS", "INHERIT_PRIVS"};
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_intId;
    public static SDMSIndex idx_parentId;
    public static SDMSIndex idx_seId;
    public static SDMSIndex idx_parentId_name;

    public SDMSScheduleTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Schedule"));
        }
        table = (SDMSScheduleTable)this;
        table = (SDMSScheduleTable)this;
        this.isVersioned = false;
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_intId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "intId");
        idx_parentId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "parentId");
        idx_seId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "seId");
        idx_parentId_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "parentId_name");
    }

    public SDMSSchedule create(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, String string2, Long l4, Boolean bl, Long l5) throws SDMSException {
        SDMSSchedule sDMSSchedule;
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        Long l8 = systemEnvironment.cEnv.uid();
        Long l9 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Schedule"));
        }
        this.validate(systemEnvironment, string, l, l2, l3, string2, l4, bl, l6, l7, l8, l9, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSScheduleGeneric sDMSScheduleGeneric = new SDMSScheduleGeneric(systemEnvironment, string, l, l2, l3, string2, l4, bl, l6, l7, l8, l9, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSScheduleGeneric.versions, true);
            table.put(systemEnvironment, sDMSScheduleGeneric.id, sDMSScheduleGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSSchedule = (SDMSSchedule)sDMSScheduleGeneric.toProxy(systemEnvironment);
            sDMSSchedule.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSSchedule sDMSSchedule2 = (SDMSSchedule)sDMSScheduleGeneric.toProxy(systemEnvironment);
            sDMSSchedule2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSSchedule)) {
            throw new AccessViolationException(sDMSSchedule.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSSchedule;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSSchedule sDMSSchedule) throws SDMSException {
        Long l = sDMSSchedule.getParentId(systemEnvironment);
        SDMSSchedule sDMSSchedule2 = SDMSScheduleTable.getObject(systemEnvironment, l);
        return sDMSSchedule2.checkPrivileges(systemEnvironment, 2L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, String string2, Long l4, Boolean bl, Long l5, Long l6, Long l7, Long l8, Long l9) throws SDMSException {
        if (!SDMSScheduleGeneric.checkIsActive(bl)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "Schedule: $1 $2", (Object)"isActive", (Object)bl));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Boolean bl;
        Long l8;
        String string;
        Long l9;
        Long l10;
        Long l11;
        String string2;
        Long l12;
        try {
            l12 = new Long(resultSet.getLong(1));
            string2 = resultSet.getString(2);
            l11 = new Long(resultSet.getLong(3));
            l10 = new Long(resultSet.getLong(4));
            if (resultSet.wasNull()) {
                l10 = null;
            }
            l9 = new Long(resultSet.getLong(5));
            if (resultSet.wasNull()) {
                l9 = null;
            }
            string = resultSet.getString(6);
            l8 = new Long(resultSet.getLong(7));
            if (resultSet.wasNull()) {
                l8 = null;
            }
            bl = new Boolean(resultSet.getInt(8) != 0);
            l7 = new Long(resultSet.getLong(9));
            l6 = new Long(resultSet.getLong(10));
            l5 = new Long(resultSet.getLong(11));
            l4 = new Long(resultSet.getLong(12));
            l3 = new Long(resultSet.getLong(13));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Schedule: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSScheduleGeneric(l12, string2, l11, l10, l9, string, l8, bl, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID, " + string + "NAME" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "INT_ID" + string2 + ", " + string + "PARENT_ID" + string2 + ", " + string + "TIME_ZONE" + string2 + ", " + string + "SE_ID" + string2 + ", " + string + "ACTIVE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", " + string + "INHERIT_PRIVS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_ownerId.check(((SDMSScheduleGeneric)sDMSObject).ownerId, sDMSObject);
        string = string + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_intId.check(((SDMSScheduleGeneric)sDMSObject).intId, sDMSObject);
        string = string + "idx_intId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_parentId.check(((SDMSScheduleGeneric)sDMSObject).parentId, sDMSObject);
        string = string + "idx_parentId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_seId.check(((SDMSScheduleGeneric)sDMSObject).seId, sDMSObject);
        string = string + "idx_seId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScheduleGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSScheduleGeneric)sDMSObject).name));
        bl = idx_parentId_name.check(sDMSKey, sDMSObject);
        string = string + "idx_parentId_name: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_ownerId.put(systemEnvironment, ((SDMSScheduleGeneric)sDMSObject).ownerId, sDMSObject, (1L & l) != 0L);
        idx_intId.put(systemEnvironment, ((SDMSScheduleGeneric)sDMSObject).intId, sDMSObject, (2L & l) != 0L);
        idx_parentId.put(systemEnvironment, ((SDMSScheduleGeneric)sDMSObject).parentId, sDMSObject, (4L & l) != 0L);
        idx_seId.put(systemEnvironment, ((SDMSScheduleGeneric)sDMSObject).seId, sDMSObject, (8L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScheduleGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSScheduleGeneric)sDMSObject).name));
        idx_parentId_name.put(systemEnvironment, sDMSKey, sDMSObject, (0x10L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_ownerId.remove(systemEnvironment, ((SDMSScheduleGeneric)sDMSObject).ownerId, sDMSObject);
        idx_intId.remove(systemEnvironment, ((SDMSScheduleGeneric)sDMSObject).intId, sDMSObject);
        idx_parentId.remove(systemEnvironment, ((SDMSScheduleGeneric)sDMSObject).parentId, sDMSObject);
        idx_seId.remove(systemEnvironment, ((SDMSScheduleGeneric)sDMSObject).seId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScheduleGeneric)sDMSObject).parentId);
        sDMSKey.add((Comparable)((Object)((SDMSScheduleGeneric)sDMSObject).name));
        idx_parentId_name.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSSchedule getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSSchedule)table.get(systemEnvironment, l);
    }

    public static SDMSSchedule getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSSchedule)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSSchedule getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSSchedule)table.get(systemEnvironment, l, l2);
    }

    public static SDMSSchedule idx_parentId_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSSchedule)idx_parentId_name.getUnique(systemEnvironment, object);
    }

    public static SDMSSchedule idx_parentId_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSSchedule)idx_parentId_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSSchedule idx_parentId_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSSchedule)idx_parentId_name.getUnique(systemEnvironment, object, l);
    }

    public static Long pathToId(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return SDMSScheduleTableGeneric.getSchedule(systemEnvironment, vector).getId(systemEnvironment);
    }

    public static Long pathToIdForUpdate(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        return SDMSScheduleTableGeneric.getScheduleForUpdate(systemEnvironment, vector).getId(systemEnvironment);
    }

    public static SDMSSchedule getSchedule(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Long l = null;
        SDMSSchedule sDMSSchedule = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSSchedule = (SDMSSchedule)SDMSScheduleTable.idx_parentId_name.getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
            l = sDMSSchedule.getId(systemEnvironment);
        }
        return sDMSSchedule;
    }

    public static SDMSSchedule getScheduleForUpdate(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Long l = null;
        SDMSSchedule sDMSSchedule = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSSchedule = (SDMSSchedule)SDMSScheduleTable.idx_parentId_name.getUniqueForUpdate(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
            l = sDMSSchedule.getId(systemEnvironment);
        }
        return sDMSSchedule;
    }

    public static Long pathToId(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        return SDMSScheduleTableGeneric.getSchedule(systemEnvironment, vector, l).getId(systemEnvironment);
    }

    public static SDMSSchedule getSchedule(SystemEnvironment systemEnvironment, Vector vector, long l) throws SDMSException {
        Long l2 = null;
        SDMSSchedule sDMSSchedule = null;
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.get(i);
            sDMSSchedule = (SDMSSchedule)SDMSScheduleTable.idx_parentId_name.getUnique(systemEnvironment, new SDMSKey(l2, (Comparable)((Object)string)), l);
            l2 = sDMSSchedule.getId(systemEnvironment);
        }
        return sDMSSchedule;
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

