/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTableGeneric;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class SDMSSchedulingHierarchyTable
extends SDMSSchedulingHierarchyTableGeneric {
    public static final String __version = "SDMSSchedulingHierarchyTable $Revision: 1.4.4.1 $ / @(#) $Id: SDMSSchedulingHierarchyTable.java,v 1.4.4.1 2013/03/14 10:25:24 ronald Exp $";

    public SDMSSchedulingHierarchyTable(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
    }

    @Override
    public SDMSSchedulingHierarchy create(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Boolean bl, Boolean bl2, Integer n, Integer n2, String string2, Integer n3, Integer n4, Integer n5, Long l3, Long l4) throws SDMSException {
        SDMSSchedulingHierarchy sDMSSchedulingHierarchy = super.create(systemEnvironment, l, l2, string, bl, bl2, n, n2, string2, n3, n4, n5, l3, l4);
        SDMSSchedulingHierarchyTable.checkHierarchyCycles(systemEnvironment, l);
        return sDMSSchedulingHierarchy;
    }

    public static void checkHierarchyCycles(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSSchedulingHierarchyTable.checkHierarchyCycles(systemEnvironment, l, new Vector());
    }

    private static void checkHierarchyCycles(SystemEnvironment systemEnvironment, Long l, Vector vector) throws SDMSException {
        Serializable serializable;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            serializable = (Long)vector.get(i);
            if (!((Long)serializable).equals(l)) continue;
            String string = ((Long)serializable).toString();
            ++i;
            while (i < n) {
                serializable = (Long)vector.get(i);
                string = string + "->" + ((Long)serializable).toString();
                ++i;
            }
            string = string + "->" + l.toString();
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02209190845", "Hierarchy cycle detected (Child->Parent:$1)", (Object)string));
        }
        vector.add(l);
        Vector vector2 = idx_seChildId.getVector(systemEnvironment, l);
        n = vector2.size();
        serializable = new HashSet();
        for (int i = 0; i < n; ++i) {
            SDMSSchedulingHierarchy sDMSSchedulingHierarchy = (SDMSSchedulingHierarchy)vector2.get(i);
            serializable.add(sDMSSchedulingHierarchy.getSeParentId(systemEnvironment));
        }
        Vector vector3 = SDMSTriggerTable.idx_seId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector3.size(); ++i) {
            SDMSTrigger sDMSTrigger = (SDMSTrigger)vector3.get(i);
            if (sDMSTrigger.getIsMaster(systemEnvironment).booleanValue() || sDMSTrigger.getType(systemEnvironment) == 3 || sDMSTrigger.getAction(systemEnvironment) == 1) continue;
            serializable.add(sDMSTrigger.getFireId(systemEnvironment));
        }
        Iterator iterator = serializable.iterator();
        while (iterator.hasNext()) {
            SDMSSchedulingHierarchyTable.checkHierarchyCycles(systemEnvironment, (Long)iterator.next(), (Vector)vector.clone());
        }
    }
}

