/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;

class TxCounter {
    private static final int QUANTUM = 1000;
    private static long nextId = 0L;
    private static long lastId;
    private static long lastRoId;
    private long[] commitingTx;
    private int commitingTxCnt = 0;

    public TxCounter(SystemEnvironment systemEnvironment) throws SDMSException {
        lastId = this.getNextQuantum(systemEnvironment);
        lastRoId = nextId = lastId - 1000L + 1L;
        this.commitingTx = new long[SystemEnvironment.maxWriter];
    }

    private synchronized long next(SystemEnvironment systemEnvironment, boolean bl) throws SDMSException {
        if (nextId == lastId) {
            lastId = this.getNextQuantum(systemEnvironment);
            nextId = lastId - 1000L;
        }
        ++nextId;
        if (bl && SystemEnvironment.maxWriter > 1) {
            this.commitingTx[systemEnvironment.dbConnectionNr] = nextId;
            ++this.commitingTxCnt;
        }
        return nextId;
    }

    public synchronized long next(SystemEnvironment systemEnvironment, int n, boolean bl) throws SDMSException {
        if (n == 1) {
            return lastRoId;
        }
        return this.next(systemEnvironment, bl);
    }

    public synchronized void releaseVersion(SystemEnvironment systemEnvironment) throws SDMSException {
        if (SystemEnvironment.maxWriter > 1 && this.commitingTx[systemEnvironment.dbConnectionNr] != 0L) {
            this.commitingTx[systemEnvironment.dbConnectionNr] = 0L;
            --this.commitingTxCnt;
        }
        lastRoId = this.next(systemEnvironment, false);
    }

    public synchronized long[] getCommitingTx() {
        long[] lArray;
        if (this.commitingTxCnt > 0) {
            lArray = new long[this.commitingTxCnt];
            int n = 0;
            for (int i = 0; i < SystemEnvironment.maxWriter; ++i) {
                if (this.commitingTx[i] == 0L) continue;
                lArray[n] = this.commitingTx[i];
                ++n;
            }
            Arrays.sort(lArray);
        } else {
            lArray = new long[]{Long.MAX_VALUE};
        }
        return lArray;
    }

    private synchronized long getNextQuantum(SystemEnvironment systemEnvironment) throws SDMSException {
        long l;
        try {
            Statement statement = systemEnvironment.dbConnection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT LASTID FROM VERSIONCOUNTER");
            if (!resultSet.next()) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03110181541", "Counter Value Missing"));
            }
            l = resultSet.getLong(1);
            if (resultSet.next()) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "03110181542", "Duplicate Counter Value"));
            }
            resultSet.close();
            l += 1000L;
            statement.executeUpdate("UPDATE VERSIONCOUNTER SET LASTID = LASTID + 1000");
            statement.close();
            systemEnvironment.dbConnection.commit();
        }
        catch (SQLException sQLException) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "03110181543", "SQLerror on updating the VersionCounter:\n$1", (Object)("SQL Error : " + sQLException.getMessage())));
        }
        return l;
    }
}

