/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.util;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSEscape;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTime {
    public static final String __version = "@(#) $Id: DateTime.java,v 2.12.2.1 2013/03/14 10:25:29 ronald Exp $";
    public static final boolean IS_DURATION = true;
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private boolean isDuration;
    private boolean isFixed = false;
    private TimeZone tz = null;
    private final GregorianCalendar gc = SystemEnvironment.newGregorianCalendar();
    private boolean gcValid = false;
    private boolean secondsSuppressed = false;
    public int year = -1;
    public int month = -1;
    public int week = -1;
    public int day = -1;
    public int hour = -1;
    public int minute = -1;
    public int second = -1;
    private static final long SECONDS_SUPPRESSED = 0x8000000000000L;
    private static final long GMT_VALID = 0x4000000000000L;
    private static final long DURATION_VALID = 0x2000000000000L;
    private static final long YEAR_VALID = 0x1000000000000L;
    private static final long MONTH_VALID = 0x200000000L;
    private static final long WEEK_VALID = 0x204000000L;
    private static final long DAY_VALID = 0x2000000L;
    private static final long HOUR_VALID = 524288L;
    private static final long MINUTE_VALID = 8192L;
    private static final long SECOND_VALID = 64L;
    private static final long GMT_SHIFT = 0L;
    private static final long YEAR_SHIFT = 34L;
    private static final long MONTH_SHIFT = 29L;
    private static final long WEEK_SHIFT = 27L;
    private static final long DAY_SHIFT = 20L;
    private static final long HOUR_SHIFT = 14L;
    private static final long MINUTE_SHIFT = 7L;
    private static final long SECOND_SHIFT = 0L;
    private static final long GMT_MASK = 0x3FFFFFFFFFFFFL;
    private static final long YEAR_MASK = 16383L;
    private static final long MONTH_MASK = 15L;
    private static final long WEEK_MASK = 63L;
    private static final long DAY_MASK = 31L;
    private static final long HOUR_MASK = 31L;
    private static final long MINUTE_MASK = 63L;
    private static final long SECOND_MASK = 63L;
    private static final int YEAR = 1;
    private static final int MONTH = 2;
    private static final int DAY = 3;
    private static final int HOUR = 4;
    private static final int MINUTE = 5;
    private static final int SECOND = 6;
    private static final DateTime MIN_VALUE = new DateTime(new Long(0x4000000000000L));
    public static final DateTime ZERO = new DateTime(new Long(0x2000000002000L));
    private static final DecimalFormat df = new DecimalFormat();

    private final int parseNumber(String string, String string2, int n, int n2, int n3, int n4) throws SDMSEscape {
        if (!string.substring(n).matches("^\\d{" + n2 + "}.*")) {
            return -1;
        }
        String string3 = string.substring(n, n + n2);
        try {
            int n5 = Integer.parseInt(string3, 10);
            if (n5 < n3 || n5 > n4) {
                throw new SDMSEscape("(04304091319) " + string2 + ' ' + n5 + " is out of range " + n3 + '-' + n4);
            }
            return n5;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SDMSEscape("(04304091320) invalid number: " + string3);
        }
    }

    private final boolean parseStr(String string, String string2) throws SDMSEscape {
        return this.parseStr(string, string2, false);
    }

    private final boolean parseStr(String string, String string2, boolean bl) throws SDMSEscape {
        int n;
        if (this.tz == null || bl) {
            this.tz = bl ? GMT : TimeZone.getDefault();
        }
        this.year = -1;
        this.month = -1;
        this.week = -1;
        this.day = -1;
        this.hour = -1;
        this.minute = -1;
        this.second = -1;
        int n2 = 0;
        block15: while (n2 < string2.length()) {
            n = string2.charAt(n2);
            switch (n) {
                case 89: {
                    this.year = this.parseNumber(string, "year", n2, 4, 0, 9999);
                    if (this.year == -1) {
                        return false;
                    }
                    n2 += 4;
                    continue block15;
                }
                case 77: {
                    this.month = this.parseNumber(string, "month", n2, 2, 1, 12);
                    if (this.month == -1) {
                        return false;
                    }
                    n2 += 2;
                    continue block15;
                }
                case 68: {
                    this.day = this.parseNumber(string, "day of month", n2, 2, 1, 31);
                    if (this.day == -1) {
                        return false;
                    }
                    n2 += 2;
                    continue block15;
                }
                case 119: {
                    this.week = this.parseNumber(string, "week of year", n2, 2, 1, 53);
                    if (this.week == -1) {
                        return false;
                    }
                    n2 += 2;
                    continue block15;
                }
                case 104: {
                    this.hour = this.parseNumber(string, "hour", n2, 2, 0, 23);
                    if (this.hour == -1) {
                        return false;
                    }
                    n2 += 2;
                    continue block15;
                }
                case 109: {
                    this.minute = this.parseNumber(string, "minute", n2, 2, 0, 59);
                    if (this.minute == -1) {
                        return false;
                    }
                    n2 += 2;
                    continue block15;
                }
                case 115: {
                    this.second = this.parseNumber(string, "second", n2, 2, 0, 59);
                    if (this.second == -1) {
                        return false;
                    }
                    n2 += 2;
                    continue block15;
                }
                case 122: {
                    if (string.charAt(n2) != ' ') {
                        return false;
                    }
                    String string3 = string.substring(++n2);
                    if (!bl) {
                        this.tz = TimeZone.getTimeZone(string3);
                        if (!this.tz.getID().equals(string3)) {
                            throw new SDMSEscape("(04304091448) unknown timezone: \"" + string3 + '\"');
                        }
                    }
                    n2 += string3.length();
                    continue block15;
                }
            }
            if (string.length() <= n2) {
                return false;
            }
            if (Character.toUpperCase(string.charAt(n2)) != Character.toUpperCase((char)n)) {
                return false;
            }
            ++n2;
        }
        if (n2 != string.length()) {
            return false;
        }
        if (this.day != -1) {
            switch (this.month) {
                case -1: {
                    n = 31;
                    break;
                }
                case 2: {
                    if (this.year == -1) {
                        n = 29;
                        break;
                    }
                    this.gc.setTimeZone(this.tz);
                    n = this.gc.isLeapYear(this.year) ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    n = 30;
                    break;
                }
                default: {
                    n = 31;
                }
            }
            if (this.day > n) {
                throw new SDMSEscape("(04304091331) day of month " + this.day + " is out of range 1-" + n);
            }
        }
        return true;
    }

    public DateTime(String string, boolean bl) throws SDMSEscape {
        this.isDuration = bl;
        this.interpretStr(string, bl, false);
    }

    public DateTime(String string, TimeZone timeZone) throws SDMSEscape {
        this.isDuration = false;
        this.tz = timeZone;
        this.interpretStr(string, false, false);
    }

    public DateTime(String string, boolean bl, boolean bl2) throws SDMSEscape {
        this.isDuration = bl;
        this.interpretStr(string, bl, bl2);
    }

    private void interpretStr(String string, boolean bl, boolean bl2) throws SDMSEscape {
        boolean bl3;
        boolean bl4 = bl3 = this.parseStr(string, "YYYY", bl2) || this.parseStr(string, "YYYYMM", bl2) || this.parseStr(string, "YYYY-MM", bl2) || this.parseStr(string, "YYYYMMDD", bl2) || this.parseStr(string, "YYYY-MM-DD", bl2) || this.parseStr(string, "YYYYMMDDThh", bl2) || this.parseStr(string, "YYYY-MM-DDThh", bl2) || this.parseStr(string, "YYYYMMDDThhmm", bl2) || this.parseStr(string, "YYYY-MM-DDThh:mm", bl2) || this.parseStr(string, "YYYYMMDDThhmmss", bl2) || this.parseStr(string, "YYYY-MM-DDThh:mm:ss", bl2) || this.parseStr(string, "-MM", bl2) || this.parseStr(string, "-MMDD", bl2) || this.parseStr(string, "-MM-DD", bl2) || this.parseStr(string, "-MMDDThh", bl2) || this.parseStr(string, "-MM-DDThh", bl2) || this.parseStr(string, "-MMDDThhmm", bl2) || this.parseStr(string, "-MM-DDThh:mm", bl2) || this.parseStr(string, "-MMDDThhmmss", bl2) || this.parseStr(string, "-MM-DDThh:mm:ss", bl2) || this.parseStr(string, "--DD", bl2) || this.parseStr(string, "--DDThh", bl2) || this.parseStr(string, "--DDThhmm", bl2) || this.parseStr(string, "--DDThh:mm", bl2) || this.parseStr(string, "--DDThhmmss", bl2) || this.parseStr(string, "--DDThh:mm:ss", bl2) || this.parseStr(string, "Thh", bl2) || this.parseStr(string, "Thhmm", bl2) || this.parseStr(string, "Thh:mm", bl2) || this.parseStr(string, "Thhmmss", bl2) || this.parseStr(string, "Thh:mm:ss", bl2) || this.parseStr(string, "T-mm", bl2) || this.parseStr(string, "T-mm", bl2) || this.parseStr(string, "T-mmss", bl2) || this.parseStr(string, "T-mm:ss", bl2) || this.parseStr(string, "T--ss", bl2) || this.parseStr(string, "T--ss", bl2) || this.parseStr(string, "YYYYWww", bl2) || this.parseStr(string, "Www", bl2);
        if (!bl3) {
            boolean bl5 = bl3 = this.parseStr(string, "YYYYz", bl2) || this.parseStr(string, "YYYYMMz", bl2) || this.parseStr(string, "YYYY-MMz", bl2) || this.parseStr(string, "YYYYMMDDz", bl2) || this.parseStr(string, "YYYY-MM-DDz", bl2) || this.parseStr(string, "YYYYMMDDThhz", bl2) || this.parseStr(string, "YYYY-MM-DDThhz", bl2) || this.parseStr(string, "YYYYMMDDThhmmz", bl2) || this.parseStr(string, "YYYY-MM-DDThh:mmz", bl2) || this.parseStr(string, "YYYYMMDDThhmmssz", bl2) || this.parseStr(string, "YYYY-MM-DDThh:mm:ssz", bl2) || this.parseStr(string, "YYYYWwwz", bl2);
            if (bl3 && bl) {
                throw new SDMSEscape("(04304091425) durations cannot have a timezone: \"" + string + '\"');
            }
        }
        if (!bl3) {
            throw new SDMSEscape("(04304091318) invalid format: \"" + string + '\"');
        }
        boolean bl6 = this.isFixed = bl || this.year == -1;
        if (!bl && this.year != -1 && this.compareTo(MIN_VALUE) < 0L) {
            throw new SDMSEscape("(04304091321) Date is too early: " + this + " (must be at least " + MIN_VALUE + ")");
        }
    }

    public DateTime(String string) throws SDMSEscape {
        this(string, false);
    }

    private final void setFieldsFromGC() {
        this.gc.setTimeZone(this.tz);
        this.year = this.gc.get(1);
        this.month = this.gc.get(2) + 1;
        this.week = -1;
        this.day = this.gc.get(5);
        this.hour = this.gc.get(11);
        this.minute = this.gc.get(12);
        this.second = this.gc.get(13);
    }

    public final void setMissingFieldsFromNow() {
        this.setMissingFieldsFromNow(false);
    }

    public final void setMissingFieldsFromNow(boolean bl) {
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        this.setMissingFieldsFromReference(date, bl);
    }

    public final void setMissingFieldsFromReference(Date date, boolean bl) {
        this.gc.setTimeZone(this.tz);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.tz);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(this.tz);
        gregorianCalendar.setTime(date);
        gregorianCalendar2.setTime(date);
        DateTime dateTime = new DateTime(0L);
        dateTime.set(this);
        int n = 0;
        if (bl) {
            if (this.year == -1) {
                n = 1;
                if (this.month == -1) {
                    n = 2;
                    if (this.day == -1) {
                        n = 3;
                        if (this.hour == -1) {
                            n = 4;
                            if (this.minute == -1) {
                                n = 5;
                            }
                        }
                    }
                }
            }
            switch (n) {
                case 1: {
                    gregorianCalendar2.add(1, 1);
                    break;
                }
                case 2: {
                    gregorianCalendar2.add(2, 1);
                    break;
                }
                case 3: {
                    gregorianCalendar2.add(5, 1);
                    break;
                }
                case 4: {
                    gregorianCalendar2.add(11, 1);
                    break;
                }
                case 5: {
                    gregorianCalendar2.add(12, 1);
                }
            }
        }
        if (this.year == -1) {
            this.year = gregorianCalendar.get(1);
            dateTime.year = gregorianCalendar2.get(1);
        } else if (this.month == -1) {
            this.month = 1;
        }
        if (this.month == -1) {
            this.month = gregorianCalendar.get(2) + 1;
            dateTime.month = gregorianCalendar2.get(2) + 1;
        } else if (this.day == -1) {
            this.day = 1;
        }
        if (this.day == -1) {
            this.day = gregorianCalendar.get(5);
            dateTime.day = gregorianCalendar2.get(5);
        } else if (this.hour == -1) {
            this.hour = 0;
        }
        if (this.hour == -1) {
            this.hour = gregorianCalendar.get(11);
            dateTime.hour = gregorianCalendar2.get(11);
        } else if (this.minute == -1) {
            this.minute = 0;
        }
        if (this.minute == -1) {
            this.minute = gregorianCalendar.get(12);
            dateTime.minute = gregorianCalendar2.get(12);
        } else if (this.second == -1) {
            this.second = 0;
        }
        if (this.second == -1) {
            this.second = gregorianCalendar.get(13);
            dateTime.second = gregorianCalendar2.get(13);
        }
        this.week = -1;
        dateTime.week = -1;
        this.loadGC();
        dateTime.loadGC();
        if (date.compareTo(this.toDate()) > 0) {
            this.set(dateTime);
        }
    }

    public DateTime(Date date) {
        this.isDuration = false;
        this.gc.setTime(date);
        this.tz = SystemEnvironment.systemTimeZone;
        this.gcValid = true;
        this.isFixed = true;
        if (this.gcValid) {
            this.setFieldsFromGC();
        }
    }

    public DateTime(DateTime dateTime) {
        this.set(dateTime);
    }

    public DateTime(long l) {
        this.setValues(l, true);
    }

    public DateTime(Long l) {
        this.setValues(l, true);
    }

    public DateTime(Long l, boolean bl) {
        this.setValues(l, bl);
    }

    private void setValues(long l, boolean bl) {
        this.isDuration = (l & 0x2000000000000L) == 0x2000000000000L;
        this.tz = bl ? TimeZone.getDefault() : GMT;
        boolean bl2 = this.gcValid = (l & 0x4000000000000L) == 0x4000000000000L;
        if (this.gcValid) {
            this.gc.setTimeInMillis(l >> 0 & 0x3FFFFFFFFFFFFL);
            this.setFieldsFromGC();
        } else {
            this.year = (l & 0x1000000000000L) != 0x1000000000000L ? -1 : (int)(l >> 34 & 0x3FFFL);
            this.day = (l & 0x2000000L) != 0x2000000L ? -1 : (int)(l >> 20 & 0x1FL);
            this.hour = (l & 0x80000L) != 524288L ? -1 : (int)(l >> 14 & 0x1FL);
            this.minute = (l & 0x2000L) != 8192L ? -1 : (int)(l >> 7 & 0x3FL);
            int n = this.second = (l & 0x40L) != 64L ? -1 : (int)(l >> 0 & 0x3FL);
            if ((l & 0x204000000L) == 0x204000000L) {
                this.week = (int)(l >> 27 & 0x3FL);
                this.month = -1;
            } else {
                this.week = -1;
                this.month = (l & 0x200000000L) != 0x200000000L ? -1 : (int)(l >> 29 & 0xFL);
            }
        }
        this.secondsSuppressed = (l & 0x8000000000000L) == 0x8000000000000L;
        this.isFixed = true;
    }

    public final void set(DateTime dateTime) {
        this.isDuration = dateTime.isDuration;
        this.isFixed = dateTime.isFixed;
        this.gcValid = dateTime.gcValid;
        if (this.gcValid) {
            this.gc.setTime(dateTime.gc.getTime());
        }
        this.tz = dateTime.tz;
        this.secondsSuppressed = dateTime.secondsSuppressed;
        this.year = dateTime.year;
        this.month = dateTime.month;
        this.week = dateTime.week;
        this.day = dateTime.day;
        this.hour = dateTime.hour;
        this.minute = dateTime.minute;
        this.second = dateTime.second;
    }

    public final void loadGC() {
        this.gc.setTimeZone(this.tz);
        this.gc.clear();
        this.gc.set(1, this.year);
        if (this.week != -1) {
            this.gc.set(3, this.week);
            this.gc.set(11, 0);
            this.gc.set(12, 0);
            this.gc.set(13, 0);
        } else {
            if (this.month != -1) {
                this.gc.set(2, this.month - 1);
            }
            if (this.day != -1) {
                this.gc.set(5, this.day);
            }
            if (this.hour != -1) {
                this.gc.set(11, this.hour);
            }
            if (this.minute != -1) {
                this.gc.set(12, this.minute);
            }
            if (this.second != -1) {
                this.gc.set(13, this.second);
            }
        }
        this.gc.set(14, 0);
        this.gcValid = true;
    }

    public final void fixToMinDate() {
        if (this.isDuration) {
            throw new IllegalStateException("(04304091942) Durations cannot be fixed");
        }
        if (this.isFixed) {
            if (this.year == -1) {
                return;
            }
            throw new IllegalStateException("(04304092046) DateTime is already fixed");
        }
        this.loadGC();
        this.isFixed = true;
    }

    public final void fixToMaxDate() {
        if (this.isDuration) {
            throw new IllegalStateException("(04304092053) Durations cannot be fixed");
        }
        if (this.isFixed) {
            if (this.year == -1) {
                return;
            }
            throw new IllegalStateException("(04304092054) DateTime is already fixed");
        }
        this.loadGC();
        if (this.second == -1) {
            if (!this.secondsSuppressed) {
                this.gc.set(13, this.gc.getActualMaximum(13));
            }
            if (this.minute == -1) {
                this.gc.set(12, this.gc.getActualMaximum(12));
                if (this.hour == -1) {
                    this.gc.set(11, this.gc.getActualMaximum(11));
                    if (this.week != -1) {
                        this.gc.add(5, 6);
                    } else if (this.day == -1) {
                        this.gc.set(5, this.gc.getActualMaximum(5));
                        if (this.month == -1) {
                            this.gc.set(2, this.gc.getActualMaximum(2));
                        }
                    }
                }
            }
        }
        this.isFixed = true;
    }

    public final boolean suppressSeconds() {
        if (this.secondsSuppressed) {
            return false;
        }
        boolean bl = false;
        if (this.gcValid) {
            boolean bl2 = bl = this.gc.isSet(13) && this.gc.get(13) != 0;
            if (bl) {
                this.gc.set(13, 0);
            }
        }
        if (this.second != -1) {
            bl = true;
            this.second = -1;
        }
        this.secondsSuppressed = true;
        return bl;
    }

    private static final void fillGC(DateTime dateTime) {
        dateTime.gc.setTimeZone(dateTime.tz);
        dateTime.gc.clear();
        if (dateTime.year != -1) {
            dateTime.gc.set(1, dateTime.year);
        }
        if (dateTime.week != -1) {
            dateTime.gc.set(3, dateTime.week);
            dateTime.gc.set(11, 0);
            dateTime.gc.set(12, 0);
            dateTime.gc.set(13, 0);
        } else {
            if (dateTime.month != -1) {
                dateTime.gc.set(2, dateTime.month - 1);
            }
            if (dateTime.day != -1) {
                dateTime.gc.set(5, dateTime.day);
            }
            if (dateTime.hour != -1) {
                dateTime.gc.set(11, dateTime.hour);
            }
            if (dateTime.minute != -1) {
                dateTime.gc.set(12, dateTime.minute);
            }
            if (dateTime.second != -1) {
                dateTime.gc.set(13, dateTime.second);
            }
        }
        dateTime.gc.set(14, 0);
    }

    public final long compareTo(DateTime dateTime) {
        if (!this.gcValid) {
            DateTime.fillGC(this);
        }
        if (!dateTime.gcValid) {
            DateTime.fillGC(dateTime);
        }
        return this.gc.getTimeInMillis() - dateTime.gc.getTimeInMillis();
    }

    public final Long toLong() {
        if (!this.isFixed) {
            throw new IllegalStateException("(04304091916) DateTime is not fixed");
        }
        long l = 0L;
        if (this.gcValid) {
            l |= 0x4000000000000L;
            l |= this.gc.getTimeInMillis();
        } else {
            if (this.isDuration) {
                l |= 0x2000000000000L;
            }
            if (this.year != -1) {
                l |= 0x1000000000000L | (long)this.year << 34;
            }
            if (this.day != -1) {
                l |= 0x2000000L | (long)this.day << 20;
            }
            if (this.hour != -1) {
                l |= 0x80000L | (long)this.hour << 14;
            }
            if (this.minute != -1) {
                l |= 0x2000L | (long)this.minute << 7;
            }
            if (this.second != -1) {
                l |= 0x40L | (long)this.second << 0;
            }
            if (this.month != -1) {
                l |= 0x200000000L | (long)this.month << 29;
            } else if (this.week != -1) {
                l |= 0x204000000L | (long)this.week << 27;
            }
        }
        if (this.secondsSuppressed) {
            l |= 0x8000000000000L;
        }
        return new Long(l);
    }

    public final Date toDate() {
        if (this.isDuration) {
            throw new IllegalStateException("(04304151255) Durations cannot be converted to Date");
        }
        if (!this.isFixed) {
            throw new IllegalStateException("(04304151254) DateTime is not fixed");
        }
        if (!this.gcValid) {
            if (this.year == -1) {
                throw new IllegalStateException("(04304151303) DateTime must have a year to be converted to Date");
            }
            throw new IllegalStateException("(04304151305) DateTime in unexpected internal state");
        }
        return this.gc.getTime();
    }

    public final long getTimeInMillis() {
        if (this.isDuration) {
            throw new IllegalStateException("(03304151255) Durations cannot be converted to Date");
        }
        if (!this.isFixed) {
            throw new IllegalStateException("(03304151254) DateTime is not fixed");
        }
        if (!this.gcValid) {
            if (this.year == -1) {
                throw new IllegalStateException("(03304151303) DateTime must have a year to be converted to Date");
            }
            throw new IllegalStateException("(03304151305) DateTime in unexpected internal state");
        }
        return this.gc.getTimeInMillis();
    }

    private static final String nice(String string, int n) {
        df.applyPattern(string);
        return df.format(n);
    }

    public final synchronized String toString() {
        return this.toString(this.tz);
    }

    public final synchronized String toString(TimeZone timeZone) {
        return this.toString(timeZone, false);
    }

    public final synchronized String toString(TimeZone timeZone, boolean bl) {
        String string;
        if (this.gcValid) {
            this.gc.setTimeZone(timeZone == null ? SystemEnvironment.systemTimeZone : timeZone);
            String string2 = "";
            if (bl) {
                boolean bl2;
                GregorianCalendar gregorianCalendar = SystemEnvironment.newGregorianCalendar();
                gregorianCalendar.setTimeZone(timeZone == null ? SystemEnvironment.systemTimeZone : timeZone);
                gregorianCalendar.setTimeInMillis(this.gc.getTimeInMillis());
                boolean bl3 = bl2 = gregorianCalendar.get(16) != 0;
                if (bl2) {
                    gregorianCalendar.add(11, 1);
                    if (gregorianCalendar.get(11) == this.gc.get(11)) {
                        string2 = "A";
                    }
                } else {
                    gregorianCalendar.add(11, -1);
                    if (gregorianCalendar.get(11) == this.gc.get(11)) {
                        string2 = "B";
                    }
                }
            }
            return DateTime.nice("0000", this.gc.get(1)) + DateTime.nice("'-'00", this.gc.get(2) + 1) + DateTime.nice("'-'00", this.gc.get(5)) + DateTime.nice("'T'00", this.gc.get(11)) + DateTime.nice("':'00", this.gc.get(12)) + (this.secondsSuppressed ? "" : DateTime.nice("':'00", this.gc.get(13))) + string2 + (timeZone == null ? "" : " " + timeZone.getID());
        }
        String string3 = !this.isDuration && this.year != -1 ? (timeZone == null ? "" : " " + timeZone.getID()) : "";
        String string4 = string = this.year == -1 ? "" : DateTime.nice("0000", this.year);
        if (this.week != -1) {
            return string + DateTime.nice("'W'00", this.week) + string3;
        }
        if (this.month != -1 || this.day != -1) {
            string = string + "-";
            if (this.month != -1) {
                string = string + DateTime.nice("00", this.month);
            }
            if (this.day != -1) {
                string = string + DateTime.nice("'-'00", this.day);
            }
        }
        if (this.hour == -1 && this.minute == -1 && this.second == -1) {
            return string + string3;
        }
        string = this.hour != -1 ? string + DateTime.nice("'T'00", this.hour) : string + "T-";
        if (this.minute != -1) {
            string = string + (this.hour != -1 ? ":" : "") + DateTime.nice("00", this.minute);
        }
        if (this.second != -1 && !this.secondsSuppressed) {
            string = string + (this.minute != -1 ? ":" : "-") + DateTime.nice("00", this.second);
        }
        return string + string3;
    }
}

