/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.shell;

import com.sun.jna.platform.win32.Sspi;
import de.independit.scheduler.SDMSApp.App;
import de.independit.scheduler.SDMSApp.Options;
import de.independit.scheduler.server.output.SDMSLineRenderer;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputError;
import de.independit.scheduler.server.output.SDMSOutputRenderer;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.xml.bind.DatatypeConverter;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class SDMSServerConnection {
    String host;
    int port = 2506;
    String auth = "BASIC";
    String user;
    String passwd;
    Socket svrConnection = null;
    ObjectInputStream in = null;
    PrintStream out = null;
    boolean isJob = false;
    boolean debug = false;
    boolean use_ssl = false;
    int timeout = -1;
    String info = null;
    KeyManagerFactory kmf;
    SSLContext sc = null;

    public SDMSServerConnection(String string, int n, String string2, String string3, String string4) {
        this.auth = string4;
        this.host = string;
        this.port = n;
        this.user = string2;
        try {
            Long.parseLong(string2);
            this.isJob = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.passwd = string3;
    }

    public SDMSServerConnection(String string, int n, String string2, String string3) {
        this.host = string;
        this.port = n;
        this.user = string2;
        try {
            Long.parseLong(string2);
            this.isJob = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.passwd = string3;
    }

    public SDMSServerConnection(String string, int n, String string2, String string3, String string4, int n2) {
        this.auth = string4;
        this.host = string;
        this.port = n;
        this.user = string2;
        try {
            Long.parseLong(string2);
            this.isJob = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.passwd = string3;
        this.timeout = n2;
    }

    public SDMSServerConnection(String string, int n, String string2, String string3, int n2) {
        this.host = string;
        this.port = n;
        this.user = string2;
        try {
            Long.parseLong(string2);
            this.isJob = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.passwd = string3;
        this.timeout = n2;
    }

    public SDMSServerConnection(String string, int n, String string2, String string3, String string4, int n2, boolean bl) {
        this.auth = string4;
        this.host = string;
        this.port = n;
        this.user = string2;
        this.use_ssl = bl;
        try {
            Long.parseLong(string2);
            this.isJob = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.passwd = string3;
        this.timeout = n2;
    }

    public SDMSServerConnection(String string, int n, String string2, String string3, int n2, boolean bl) {
        this.host = string;
        this.port = n;
        this.user = string2;
        this.use_ssl = bl;
        try {
            Long.parseLong(string2);
            this.isJob = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.passwd = string3;
        this.timeout = n2;
    }

    public SDMSServerConnection(Options options) {
        this.host = options.getValue("HOST");
        try {
            this.port = Integer.parseInt(options.getValue("PORT"));
            this.timeout = options.isSet("CONNTIMEOUT") ? Integer.parseInt(options.getValue("CONNTIMEOUT")) : -1;
        }
        catch (NumberFormatException numberFormatException) {
            this.timeout = -1;
        }
        this.user = options.getValue("USER");
        this.passwd = options.getValue("PASS");
        this.use_ssl = options.isSet("TLS") ? options.getOption("TLS").getBValue() : false;
        String string = this.info = options.isSet("INFO") ? options.getValue("INFO") : null;
        if (this.info != null) {
            this.info = this.info.replace("\\\\", "\\\\");
            this.info = this.info.replace("'", "\\'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SDMSOutput connect(Options options) throws IOException {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        if (this.use_ssl) {
            object4 = null;
            object3 = null;
            if (options.isSet("KEYSTORE") && options.isSet("KEYSTOREPW")) {
                string = options.getValue("KEYSTORE");
                System.setProperty("javax.net.ssl.keyStore", string);
                System.setProperty("javax.net.ssl.keyStorePassword", options.getValue("KEYSTOREPW"));
                object3 = options.getValue("KEYSTOREPW").toCharArray();
                try {
                    object4 = KeyStore.getInstance("JKS");
                    ((KeyStore)object4).load(new FileInputStream(string), (char[])object3);
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                    System.exit(1);
                }
            }
            if (options.isSet("TRUSTSTORE") && options.isSet("TRUSTSTOREPW")) {
                System.setProperty("javax.net.ssl.trustStore", options.getValue("TRUSTSTORE"));
                System.setProperty("javax.net.ssl.trustStorePassword", options.getValue("TRUSTSTOREPW"));
            }
            try {
                this.kmf = KeyManagerFactory.getInstance("SunX509");
                if (object4 == null) {
                    this.kmf.init(null, null);
                } else {
                    this.kmf.init((KeyStore)object4, (char[])object3);
                }
                this.sc = SSLContext.getInstance("SSL");
                this.sc.init(this.kmf.getKeyManagers(), null, null);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                System.exit(1);
            }
            object2 = this.sc.getSocketFactory();
            object = (SSLSocket)((SocketFactory)object2).createSocket(InetAddress.getByName(this.host), this.port);
            ((SSLSocket)object).startHandshake();
            this.svrConnection = object;
        } else {
            this.svrConnection = new Socket();
            this.svrConnection.setPerformancePreferences(0, 1, 0);
            this.svrConnection.setTcpNoDelay(true);
            this.svrConnection.connect(new InetSocketAddress(InetAddress.getByName(this.host), this.port));
        }
        object4 = new DataInputStream(this.svrConnection.getInputStream());
        this.checkSuperfluous((InputStream)object4);
        this.out = new PrintStream(this.svrConnection.getOutputStream(), true, "UTF8");
        string = "'";
        object3 = "'";
        if (this.isJob) {
            this.auth = "BASIC";
            string = "job ";
            object3 = "";
        }
        object = null;
        IWindowsSecurityContext iWindowsSecurityContext = null;
        if (options != null && options.isSet("AUTH")) {
            this.auth = options.getValue("AUTH");
        }
        switch (this.auth) {
            case "BASIC": {
                return this.execute("connect " + string + this.user + (String)object3 + " identified by '" + this.passwd + "' with protocol = SERIAL" + (this.timeout != -1 ? ", timeout = " + this.timeout : "") + (this.info != null ? ", session = '" + this.info + "'" : "") + ";");
            }
            case "WINSSO": {
                String string2;
                Object object5;
                byte[] byArray;
                String string3 = null;
                if (options.isSet("SPN")) {
                    string3 = options.getValue("SPN");
                }
                try {
                    iWindowsSecurityContext = WindowsSecurityContextImpl.getCurrent((String)"Negotiate", (String)string3);
                    byArray = iWindowsSecurityContext.getToken();
                    object = DatatypeConverter.printBase64Binary((byte[])byArray);
                }
                catch (Throwable throwable) {
                    iWindowsSecurityContext.dispose();
                    object2 = new SDMSOutput();
                    ((SDMSOutput)object2).setError(new SDMSOutputError("Desktop-0006", "Exception getting clientToken:" + throwable.toString() + " !"));
                    return object2;
                }
                String string4 = "connect with token = '" + (String)object + "', protocol = SERIAL, method = '" + this.auth + "'" + (this.timeout != -1 ? ", timeout = " + this.timeout : "") + (this.info != null ? ", session = '" + this.info + "'" : "") + ";";
                object2 = this.execute(string4);
                if (((SDMSOutput)object2).error != null) {
                    iWindowsSecurityContext.dispose();
                    return object2;
                }
                int n = ((SDMSOutput)object2).container.indexForName(null, "TOKEN");
                Vector vector = (Vector)((SDMSOutput)object2).container.dataset.get(0);
                object = (String)vector.get(n);
                byArray = DatatypeConverter.parseBase64Binary((String)object);
                try {
                    object5 = new Sspi.SecBufferDesc(2, byArray);
                    iWindowsSecurityContext.initialize(iWindowsSecurityContext.getHandle(), object5, string3);
                    byArray = iWindowsSecurityContext.getToken();
                    object = DatatypeConverter.printBase64Binary((byte[])byArray);
                }
                catch (Throwable throwable) {
                    object2 = new SDMSOutput();
                    ((SDMSOutput)object2).setError(new SDMSOutputError("Desktop-0006", "Exception getting clientToken:" + throwable.toString() + " !"));
                    Object object6 = object2;
                    return object6;
                }
                finally {
                    iWindowsSecurityContext.dispose();
                }
                string4 = "continue connect with token = '" + (String)object + "';";
                object5 = this.execute(string4);
                if (object5.error != null) {
                    return object2;
                }
                string4 = "show user;";
                object2 = this.execute(string4);
                if (((SDMSOutput)object2).error != null) {
                    return object2;
                }
                int n2 = ((SDMSOutput)object2).container.indexForName(null, "NAME");
                vector = (Vector)((SDMSOutput)object2).container.dataset.get(0);
                App.userName = (String)vector.get(n2);
                if (options.isSet("USER") && !(string2 = options.getValue("USER")).equals(App.userName)) {
                    App.userName = string2;
                    string4 = "alter session set user = '" + string2 + "';";
                    object2 = this.execute(string4);
                    if (((SDMSOutput)object2).error != null) {
                        return object2;
                    }
                }
                return object5;
            }
        }
        object2 = new SDMSOutput();
        ((SDMSOutput)object2).setError(new SDMSOutputError("Desktop-0005", "Invalid auth option '" + this.auth + "'!"));
        return object2;
    }

    public SDMSOutput execute(String string) {
        Object object;
        SDMSOutput sDMSOutput = null;
        String string2 = string.trim();
        if (this.debug) {
            System.out.println(string2);
        }
        try {
            this.out.print(string2);
            if (!string2.endsWith(";")) {
                this.out.print(";");
            }
            this.out.println("");
            if (this.out.checkError()) {
                sDMSOutput = new SDMSOutput();
                sDMSOutput.setError(new SDMSOutputError("Desktop-0004", "Error on communication channel to Server"));
                return sDMSOutput;
            }
            this.in = new ObjectInputStream(this.svrConnection.getInputStream());
            sDMSOutput = (SDMSOutput)this.in.readObject();
            object = new DataInputStream(this.svrConnection.getInputStream());
            this.checkSuperfluous((InputStream)object);
        }
        catch (EOFException eOFException) {
            sDMSOutput = new SDMSOutput();
            sDMSOutput.setError(new SDMSOutputError("Desktop-0002", "Connection closed by Server"));
        }
        catch (SocketException socketException) {
            sDMSOutput = new SDMSOutput();
            sDMSOutput.setError(new SDMSOutputError("Desktop-0003", "Connection closed by Server"));
        }
        catch (Exception exception) {
            sDMSOutput = new SDMSOutput();
            sDMSOutput.setError(new SDMSOutputError("Desktop-0001", "Server Error executing command"));
        }
        if (this.debug) {
            try {
                object = new SDMSLineRenderer();
                ((SDMSOutputRenderer)object).render(System.out, sDMSOutput);
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                System.exit(1);
            }
        }
        return sDMSOutput;
    }

    public void finish() throws IOException {
        this.out.println("disconnect;");
        this.closeall();
    }

    private void closeall() throws IOException {
        this.out.close();
        this.in.close();
        this.svrConnection.close();
    }

    private void checkSuperfluous(InputStream inputStream) throws IOException {
        if (inputStream.available() > 0) {
            byte[] byArray = new byte[5000];
            int n = inputStream.read(byArray);
            System.err.println("got " + n + " additional bytes!");
            System.exit(1);
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

