/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.tools;

import de.independit.scheduler.SDMSApp.App;
import de.independit.scheduler.SDMSApp.RetryException;
import de.independit.scheduler.server.output.SDMSOutput;
import de.independit.scheduler.server.output.SDMSOutputUtil;
import java.util.Iterator;

class submit
extends App {
    public static final String __version = "@(#) $Id: submit.java,v 2.7.6.1 2013/03/14 10:25:32 ronald Exp $";
    public static final String JOB = "JOB";
    public static final String TAG = "TAG";
    public static final String MASTER = "MASTER";
    public static final String SUSPEND = "SUSPEND";
    public static final String DELAY = "DELAY";
    public static final String UNIT = "UNIT";
    public static final String AT = "AT";
    public static final String GROUP = "GROUP";
    public static final String NICE = "NICE";
    private String submitTag = null;

    @Override
    public void addOptions() {
        this.addOption("J", "job", null, JOB, null, "jobname", true, "Name or alias of job to submit");
        this.addOption("T", "tag", null, TAG, null, "tag", false, "Child tag for dynamic child submits");
        this.addOption("m", "master", null, MASTER, null, null, false, "The job will be submitted as master (job option only)");
        this.addOption("N", "nice", null, NICE, null, "nice", false, "Nice value of the job or batch");
        this.addOption("S", "suspend", null, SUSPEND, null, null, false, "Submit job [not] suspended");
        this.addOption("D", "delay", null, DELAY, null, "delay", false, "Delay after Job will be resumed (only valid with suspend option)");
        this.addOption("U", "unit", null, UNIT, null, "unit", false, "Delay Unit (MINUTE, HOUR or DAY) defaults to MINUTE");
        this.addOption("A", "at", null, AT, null, "at", false, "Timestamp (YYYY-MM-DDTHH:MM) when job should be resumed (only valid with suspend option)");
        this.addOption("g", "group", null, GROUP, null, "groupname", false, "Group to own the submitted job (not allows with jid option)");
    }

    @Override
    public String getName() {
        return "submit";
    }

    @Override
    public boolean canRetry() {
        return true;
    }

    @Override
    public String getUsageArguments() {
        return "{ parameter value }";
    }

    @Override
    public boolean validateOptions() {
        if (this.options.isSet(GROUP) && !this.options.isSet("USER")) {
            if (!this.silent) {
                System.err.println("group option only allowed with user option !");
            }
            return false;
        }
        if (this.options.isSet(MASTER) && this.options.isSet("USER") && !this.silent) {
            System.err.println("WARNING: master option has no effect for submits by user");
        }
        if (this.options.isSet(NICE)) {
            int n;
            try {
                n = Integer.parseInt(this.options.getValue(NICE));
            }
            catch (Exception exception) {
                if (!this.silent) {
                    System.err.println("nicevalue be an integer !");
                }
                return false;
            }
            if (n < -100 || n > 100) {
                if (!this.silent) {
                    System.err.println("nicevalue must be >= -100 and <= 100 !");
                }
                return false;
            }
        }
        if (!this.options.isSet(SUSPEND) || !this.options.getOption(SUSPEND).getBValue()) {
            if (this.options.isSet(DELAY)) {
                System.err.println("delay option only valid with suspend option");
                return false;
            }
            if (this.options.isSet(AT)) {
                System.err.println("at option only valid with suspend option");
                return false;
            }
        } else {
            if (this.options.isSet(DELAY) && this.options.isSet(AT)) {
                System.err.println("combination of delay and at option not allowed");
                return false;
            }
            if (this.options.isSet(DELAY) && !this.options.isSet(UNIT)) {
                System.err.println("delay option requires unit option");
                return false;
            }
            if (this.options.isSet(UNIT) && !this.options.getValue(UNIT).equals("MINUTE") && !this.options.getValue(UNIT).equals("HOUR") && !this.options.getValue(UNIT).equals("DAY")) {
                System.err.println("unit must be MINUTE, HOUR or DAY");
                return false;
            }
        }
        if (this.options.isSet(UNIT) && !this.options.isSet(DELAY)) {
            System.err.println("unit option only valid with delay option");
            return false;
        }
        if (this.options.rest.size() % 2 != 0) {
            if (!this.silent) {
                System.err.println("Incomplete parameter value pairs !");
            }
            return false;
        }
        return true;
    }

    @Override
    public int go() throws RetryException {
        SDMSOutput sDMSOutput;
        String string;
        if (this.submitTag == null) {
            string = "GET SUBMITTAG";
            sDMSOutput = this.execute(string);
            this.submitTag = SDMSOutputUtil.getFromRecord(sDMSOutput, "VALUE");
        }
        string = "SUBMIT " + this.options.getValue(JOB) + "\nWITH\n    SUBMITTAG = '" + this.submitTag + "'";
        if (this.options.isSet(SUSPEND) && this.options.getOption(SUSPEND).getBValue()) {
            string = string + ",\n    SUSPEND";
        }
        if (this.options.isSet(DELAY) || this.options.isSet(AT)) {
            string = string + ",\n    RESUME";
        }
        if (this.options.isSet(DELAY)) {
            string = string + " IN " + this.options.getValue(DELAY) + " " + this.options.getValue(UNIT);
        }
        if (this.options.isSet(AT)) {
            string = string + " AT '" + this.options.getValue(AT) + "'";
        }
        if (this.options.isSet(NICE)) {
            string = string + ",\n    NICEVALUE = " + this.options.getValue(NICE);
        }
        if (this.options.isSet(TAG)) {
            string = string + ",\n    CHILDTAG = '" + this.options.getValue(TAG) + "'";
        }
        if (this.options.isSet(MASTER) && !this.options.isSet("USER")) {
            string = string + ",\n    MASTER";
        }
        if (this.options.rest.size() > 0) {
            string = string + ",\n    PARAMETERS = (\n";
            String string2 = "";
            Iterator iterator = this.options.rest.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)iterator.next();
                string4 = string4.replaceAll("\\\\", "\\\\\\\\");
                string4 = string4.replaceAll("'", "\\\\'");
                string = string + string2 + "        '" + string3 + "' = '" + string4 + "'";
                string2 = ",\n";
            }
            string = string + "\n    )";
        }
        sDMSOutput = this.execute(string);
        if (sDMSOutput.error != null) {
            if (sDMSOutput.error.code.equals("03406031553")) {
                return 0;
            }
            this.printError(sDMSOutput.error);
            return 1;
        }
        System.out.println(SDMSOutputUtil.getFromRecord(sDMSOutput, "ID"));
        return 0;
    }

    public static void main(String[] stringArray) {
        System.exit(new submit().run(stringArray));
    }
}

