-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_INSTANCE (
    ID                             bigint NOT NULL
    , UNIQUE_NAME                    varchar(256)    NOT NULL
    , OM_ID                          bigint          NOT NULL
    , MODIFY_TS                      bigint              NULL
    , REMOVE_TS                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_INSTANCE
ON OBJECT_INSTANCE(ID);
CREATE VIEW SCI_OBJECT_INSTANCE AS
SELECT 
    ID 
    , UNIQUE_NAME                    AS UNIQUE_NAME
    , OM_ID                          AS OM_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(MODIFY_TS, 1125899906842624)/1000) seconds AS MODIFY_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(REMOVE_TS, 1125899906842624)/1000) seconds AS REMOVE_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM OBJECT_INSTANCE;
