-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_TEMPLATE (
    ID                             bigint NOT NULL
    , NR_ID                          bigint          NOT NULL
    , SE_ID                          bigint          NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , RSD_ID                         bigint              NULL
    , REQUESTABLE_AMOUNT             integer             NULL
    , AMOUNT                         integer             NULL
    , IS_ONLINE                      integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_RESOURCE_TEMPLATE
ON RESOURCE_TEMPLATE(ID);
CREATE VIEW SCI_C_RESOURCE_TEMPLATE AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , OWNER_ID                       AS OWNER_ID
    , RSD_ID                         AS RSD_ID
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_TEMPLATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_TEMPLATE AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , OWNER_ID                       AS OWNER_ID
    , RSD_ID                         AS RSD_ID
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_TEMPLATE;
