-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SME_COUNTER (
    ID                             bigint NOT NULL
    , JAHR                           integer         NOT NULL
    , MONAT                          integer         NOT NULL
    , TAG                            integer         NOT NULL
    , ANZAHL                         integer         NOT NULL
    , CHECKSUM                       bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SME_COUNTER
ON SME_COUNTER(ID);
CREATE VIEW SCI_SME_COUNTER AS
SELECT 
    ID 
    , JAHR                           AS JAHR
    , MONAT                          AS MONAT
    , TAG                            AS TAG
    , ANZAHL                         AS ANZAHL
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SME_COUNTER;
