CREATE TABLE ARC_AUDIT_TRAIL (
    ID                             bigint NOT NULL
    , USER_ID                        bigint           NULL
    , TS                             bigint           NULL
    , TXID                           bigint           NULL
    , ACTION                         integer          NULL
    , OBJECT_TYPE                    integer          NULL
    , OBJECT_ID                      bigint           NULL
    , ORIGIN_ID                      bigint           NULL
    , IS_SET_WARNING                 integer          NULL
    , ACTION_INFO                    varchar(1024)    NULL
    , ACTION_COMMENT                 varchar(1024)    NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
DROP VIEW SCI_AUDIT_TRAIL;
CREATE VIEW SCI_AUDIT_TRAIL AS
SELECT 
    ID 
    , USER_ID                        AS USER_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(TS, 1125899906842624)/1000) seconds AS TS
    , TXID                           AS TXID
    , DECODE (ACTION, 1, 'RERUN', 2, 'RERUN_RECURSIVE', 3, 'CANCEL', 4, 'SUSPEND', 5, 'RESUME', 6, 'SET_STATE', 7, 'SET_EXIT_STATE', 8, 'IGNORE_DEPENDENCY', 9, 'IGNORE_DEP_RECURSIVE', 10, 'IGNORE_RESOURCE', 11, 'KILL', 12, 'ALTER_RUN_PROGRAM', 13, 'ALTER_RERUN_PROGRAM', 14, 'COMMENT_JOB', 15, 'SUBMITTED', 16, 'TRIGGER_FAILED', 17, 'TRIGGER_SUBMIT', 18, 'JOB_RESTARTABLE', 19, 'CHANGE_PRIORITY', 20, 'RENICE', 21, 'SUBMIT_SUSPENDED', 22, 'IGNORE_NAMED_RESOURCE', 23, 'TIMEOUT', 24, 'SET_RESOURCE_STATE', 25, 'JOB_IN_ERROR', 26, 'CLEAR_WARNING', 27, 'SET_WARNING', 28, 'JOB_UNREACHABLE', 29, 'SET_PARAMETERS', 30, 'DISABLE', 31, 'ENABLE', 32, 'CLONE') AS ACTION
    , DECODE (OBJECT_TYPE, 17, 'JOB') AS OBJECT_TYPE
    , OBJECT_ID                      AS OBJECT_ID
    , ORIGIN_ID                      AS ORIGIN_ID
    , DECODE (IS_SET_WARNING, 1, 'TRUE', 0, 'FALSE') AS IS_SET_WARNING
    , ACTION_INFO                    AS ACTION_INFO
    , ACTION_COMMENT                 AS ACTION_COMMENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM AUDIT_TRAIL;
DROP VIEW SCI_CALENDAR;
CREATE VIEW SCI_CALENDAR AS
SELECT 
    ID 
    , SCEV_ID                        AS SCEV_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(STARTTIME, 1125899906842624)/1000) seconds AS STARTTIME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM CALENDAR;
DROP VIEW SCI_C_DEPENDENCY_DEFINITION;
DROP VIEW SCI_V_DEPENDENCY_DEFINITION;
CREATE VIEW SCI_C_DEPENDENCY_DEFINITION AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM DEPENDENCY_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_DEPENDENCY_DEFINITION AS
SELECT 
    ID 
    , SE_DEPENDENT_ID                AS SE_DEPENDENT_ID
    , SE_REQUIRED_ID                 AS SE_REQUIRED_ID
    , NAME                           AS NAME
    , DECODE (UNRESOLVED_HANDLING, 1, 'IGNORE', 2, 'ERROR', 3, 'SUSPEND', 4, 'DEFER', 5, 'DEFER_IGNORE') AS UNRESOLVED_HANDLING
    , DECODE (DMODE, 1, 'ALL_FINAL', 2, 'JOB_FINAL') AS DMODE
    , DECODE (STATE_SELECTION, 0, 'FINAL', 1, 'ALL_REACHABLE', 2, 'UNREACHABLE', 3, 'DEFAULT') AS STATE_SELECTION
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM DEPENDENCY_DEFINITION;
CREATE TABLE ARC_DEPENDENCY_INSTANCE (
    ID                             bigint NOT NULL
    , DD_ID                          bigint           NULL
    , DEPENDENT_ID                   bigint           NULL
    , DEPENDENT_ID_ORIG              bigint           NULL
    , DEPENDENCY_OPERATION           integer          NULL
    , REQUIRED_ID                    bigint           NULL
    , STATE                          integer          NULL
    , IGNORE                         integer          NULL
    , DI_ID_ORIG                     bigint           NULL
    , SE_VERSION                     bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
DROP VIEW SCI_DEPENDENCY_INSTANCE;
CREATE VIEW SCI_DEPENDENCY_INSTANCE AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , DEPENDENT_ID                   AS DEPENDENT_ID
    , DEPENDENT_ID_ORIG              AS DEPENDENT_ID_ORIG
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , REQUIRED_ID                    AS REQUIRED_ID
    , DECODE (STATE, 0, 'OPEN', 1, 'FULFILLED', 2, 'FAILED', 3, 'BROKEN', 4, 'DEFERRED', 8, 'CANCELLED') AS STATE
    , DECODE (IGNORE, 0, 'NO', 1, 'YES', 2, 'RECURSIVE') AS IGNORE
    , DI_ID_ORIG                     AS DI_ID_ORIG
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM DEPENDENCY_INSTANCE;
DROP VIEW SCI_C_DEPENDENCY_STATE;
DROP VIEW SCI_V_DEPENDENCY_STATE;
CREATE VIEW SCI_C_DEPENDENCY_STATE AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , ESD_ID                         AS ESD_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM DEPENDENCY_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_DEPENDENCY_STATE AS
SELECT 
    ID 
    , DD_ID                          AS DD_ID
    , ESD_ID                         AS ESD_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM DEPENDENCY_STATE;
CREATE TABLE ARC_ENTITY_VARIABLE (
    ID                             bigint NOT NULL
    , SME_ID                         bigint           NULL
    , NAME                           varchar(64)      NULL
    , VALUE                          varchar(256)     NULL
    , IS_LOCAL                       integer          NULL
    , EV_LINK                        bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
DROP VIEW SCI_ENTITY_VARIABLE;
CREATE VIEW SCI_ENTITY_VARIABLE AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , NAME                           AS NAME
    , VALUE                          AS VALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM ENTITY_VARIABLE;
DROP VIEW SCI_C_ENVIRONMENT;
DROP VIEW SCI_V_ENVIRONMENT;
CREATE VIEW SCI_C_ENVIRONMENT AS
SELECT 
    ID 
    , NE_ID                          AS NE_ID
    , NR_ID                          AS NR_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM ENVIRONMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_ENVIRONMENT AS
SELECT 
    ID 
    , NE_ID                          AS NE_ID
    , NR_ID                          AS NR_ID
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM ENVIRONMENT;
DROP VIEW SCI_EVENT;
CREATE VIEW SCI_EVENT AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , SE_ID                          AS SE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EVENT;
DROP VIEW SCI_EVENT_PARAMETER;
CREATE VIEW SCI_EVENT_PARAMETER AS
SELECT 
    ID 
    , KEY                            AS KEY
    , VALUE                          AS VALUE
    , EVT_ID                         AS EVT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EVENT_PARAMETER;
DROP VIEW SCI_C_EXIT_STATE;
DROP VIEW SCI_V_EXIT_STATE;
CREATE VIEW SCI_C_EXIT_STATE AS
SELECT 
    ID 
    , PREFERENCE                     AS PREFERENCE
    , DECODE (IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS IS_FINAL
    , DECODE (IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS IS_RESTARTABLE
    , DECODE (IS_UNREACHABLE, 1, 'TRUE', 0, 'FALSE') AS IS_UNREACHABLE
    , DECODE (IS_BROKEN, 1, 'TRUE', 0, 'FALSE') AS IS_BROKEN
    , DECODE (IS_BATCH_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_BATCH_DEFAULT
    , DECODE (IS_DEPENDENCY_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_DEPENDENCY_DEFAULT
    , ESP_ID                         AS ESP_ID
    , ESD_ID                         AS ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EXIT_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE AS
SELECT 
    ID 
    , PREFERENCE                     AS PREFERENCE
    , DECODE (IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS IS_FINAL
    , DECODE (IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS IS_RESTARTABLE
    , DECODE (IS_UNREACHABLE, 1, 'TRUE', 0, 'FALSE') AS IS_UNREACHABLE
    , DECODE (IS_BROKEN, 1, 'TRUE', 0, 'FALSE') AS IS_BROKEN
    , DECODE (IS_BATCH_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_BATCH_DEFAULT
    , DECODE (IS_DEPENDENCY_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_DEPENDENCY_DEFAULT
    , ESP_ID                         AS ESP_ID
    , ESD_ID                         AS ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE;
DROP VIEW SCI_C_EXIT_STATE_DEFINITION;
DROP VIEW SCI_V_EXIT_STATE_DEFINITION;
CREATE VIEW SCI_C_EXIT_STATE_DEFINITION AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EXIT_STATE_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_DEFINITION AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_DEFINITION;
DROP VIEW SCI_C_EXIT_STATE_MAPPING;
DROP VIEW SCI_V_EXIT_STATE_MAPPING;
CREATE VIEW SCI_C_EXIT_STATE_MAPPING AS
SELECT 
    ID 
    , ESMP_ID                        AS ESMP_ID
    , ESD_ID                         AS ESD_ID
    , ECR_START                      AS ECR_START
    , ECR_END                        AS ECR_END
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EXIT_STATE_MAPPING
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_MAPPING AS
SELECT 
    ID 
    , ESMP_ID                        AS ESMP_ID
    , ESD_ID                         AS ESD_ID
    , ECR_START                      AS ECR_START
    , ECR_END                        AS ECR_END
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_MAPPING;
DROP VIEW SCI_C_EXIT_STATE_MAP_PROFILE;
DROP VIEW SCI_V_EXIT_STATE_MAP_PROFILE;
CREATE VIEW SCI_C_EXIT_STATE_MAP_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EXIT_STATE_MAPPING_PROFILE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_MAP_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_MAPPING_PROFILE;
DROP VIEW SCI_C_EXIT_STATE_PROFILE;
DROP VIEW SCI_V_EXIT_STATE_PROFILE;
CREATE VIEW SCI_C_EXIT_STATE_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULT_ESMP_ID                AS DEFAULT_ESMP_ID
    , DECODE (IS_VALID, 1, 'TRUE', 0, 'FALSE') AS IS_VALID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EXIT_STATE_PROFILE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULT_ESMP_ID                AS DEFAULT_ESMP_ID
    , DECODE (IS_VALID, 1, 'TRUE', 0, 'FALSE') AS IS_VALID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_PROFILE;
DROP VIEW SCI_C_EXIT_STATE_TRANSLATION;
DROP VIEW SCI_V_EXIT_STATE_TRANSLATION;
CREATE VIEW SCI_C_EXIT_STATE_TRANSLATION AS
SELECT 
    ID 
    , ESTP_ID                        AS ESTP_ID
    , FROM_ESD_ID                    AS FROM_ESD_ID
    , TO_ESD_ID                      AS TO_ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EXIT_STATE_TRANSLATION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_TRANSLATION AS
SELECT 
    ID 
    , ESTP_ID                        AS ESTP_ID
    , FROM_ESD_ID                    AS FROM_ESD_ID
    , TO_ESD_ID                      AS TO_ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_TRANSLATION;
DROP VIEW SCI_C_EXIT_STATE_TRANS_PROFILE;
DROP VIEW SCI_V_EXIT_STATE_TRANS_PROFILE;
CREATE VIEW SCI_C_EXIT_STATE_TRANS_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EXIT_STATE_TRANS_PROFILE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_TRANS_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE_TRANS_PROFILE;
DROP VIEW SCI_EXTENTS;
CREATE VIEW SCI_EXTENTS AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SME_ID                         AS SME_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM EXTENTS;
DROP VIEW SCI_C_FOLDER;
DROP VIEW SCI_V_FOLDER;
CREATE VIEW SCI_C_FOLDER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , ENV_ID                         AS ENV_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM FOLDER
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_FOLDER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , ENV_ID                         AS ENV_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , VALID_FROM
    , VALID_TO
  FROM FOLDER;
DROP VIEW SCI_FOOTPRINT;
CREATE VIEW SCI_FOOTPRINT AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM FOOTPRINT;
DROP VIEW SCI_GRANTS;
CREATE VIEW SCI_GRANTS AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , G_ID                           AS G_ID
    , DECODE (OBJECT_TYPE, 1, 'ENVIRONMENT', 18, 'EVENT', 6, 'FOLDER', 19, 'INTERVAL', 17, 'JOB', 9, 'JOB_DEFINITION', 10, 'NAMED_RESOURCE', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 15, 'SCOPE', 21, 'GROUP', 11, 'RESOURCE', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 7, 'FOOTPRINT', 8, 'USER', 30, 'OBJECT_MONITOR', 0, 'SYSTEM') AS OBJECT_TYPE
    , PRIVS                          AS PRIVS
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM GRANTS;
DROP VIEW SCI_GROUPS;
CREATE VIEW SCI_GROUPS AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM GROUPS;
CREATE TABLE ARC_HIERARCHY_INSTANCE (
    ID                             bigint NOT NULL
    , PARENT_ID                      bigint           NULL
    , CHILD_ID                       bigint           NULL
    , SH_ID                          bigint           NULL
    , NICE                           integer          NULL
    , CHILD_ESD_ID                   bigint           NULL
    , CHILD_ES_PREFERENCE            integer          NULL
    , SE_VERSION                     bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
DROP VIEW SCI_HIERARCHY_INSTANCE;
CREATE VIEW SCI_HIERARCHY_INSTANCE AS
SELECT 
    ID 
    , PARENT_ID                      AS PARENT_ID
    , CHILD_ID                       AS CHILD_ID
    , SH_ID                          AS SH_ID
    , NICE                           AS NICE
    , CHILD_ESD_ID                   AS CHILD_ESD_ID
    , CHILD_ES_PREFERENCE            AS CHILD_ES_PREFERENCE
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM HIERARCHY_INSTANCE;
DROP VIEW SCI_C_IGNORED_DEPENDENCY;
DROP VIEW SCI_V_IGNORED_DEPENDENCY;
CREATE VIEW SCI_C_IGNORED_DEPENDENCY AS
SELECT 
    ID 
    , SH_ID                          AS SH_ID
    , DD_NAME                        AS DD_NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM IGNORED_DEPENDENCY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_IGNORED_DEPENDENCY AS
SELECT 
    ID 
    , SH_ID                          AS SH_ID
    , DD_NAME                        AS DD_NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM IGNORED_DEPENDENCY;
DROP VIEW SCI_INSTANCE_VALUE;
CREATE VIEW SCI_INSTANCE_VALUE AS
SELECT 
    ID 
    , VALUE                          AS VALUE
    , OI_ID                          AS OI_ID
    , WTP_ID                         AS WTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM INSTANCE_VALUE;
DROP VIEW SCI_INTERVALL;
CREATE VIEW SCI_INTERVALL AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(START_TIME, 1125899906842624)/1000) seconds AS START_TIME
    , timestamp('1970-01-01-00.00.00') + int(mod(END_TIME, 1125899906842624)/1000) seconds AS END_TIME
    , DELAY                          AS DELAY
    , DECODE (BASE_INTERVAL, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS BASE_INTERVAL
    , BASE_INTERVAL_MULTIPLIER       AS BASE_INTERVAL_MULTIPLIER
    , DECODE (DURATION, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DURATION
    , DURATION_MULTIPLIER            AS DURATION_MULTIPLIER
    , timestamp('1970-01-01-00.00.00') + int(mod(SYNC_TIME, 1125899906842624)/1000) seconds AS SYNC_TIME
    , DECODE (IS_INVERSE, 1, 'TRUE', 0, 'FALSE') AS IS_INVERSE
    , DECODE (IS_MERGE, 1, 'TRUE', 0, 'FALSE') AS IS_MERGE
    , EMBEDDED_INT_ID                AS EMBEDDED_INT_ID
    , SE_ID                          AS SE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM INTERVALL;
DROP VIEW SCI_INTERVAL_DISPATCHER;
CREATE VIEW SCI_INTERVAL_DISPATCHER AS
SELECT 
    ID 
    , INT_ID                         AS INT_ID
    , SEQ_NO                         AS SEQ_NO
    , NAME                           AS NAME
    , SELECT_INT_ID                  AS SELECT_INT_ID
    , FILTER_INT_ID                  AS FILTER_INT_ID
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM INTERVAL_DISPATCHER;
DROP VIEW SCI_INTERVAL_HIERARCHY;
CREATE VIEW SCI_INTERVAL_HIERARCHY AS
SELECT 
    ID 
    , CHILD_ID                       AS CHILD_ID
    , PARENT_ID                      AS PARENT_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM INTERVAL_HIERARCHY;
DROP VIEW SCI_INTERVAL_SELECTION;
CREATE VIEW SCI_INTERVAL_SELECTION AS
SELECT 
    ID 
    , INT_ID                         AS INT_ID
    , VALUE                          AS VALUE
    , PERIOD_FROM                    AS PERIOD_FROM
    , PERIOD_TO                      AS PERIOD_TO
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM INTERVAL_SELECTION;
CREATE TABLE ARC_KILL_JOB (
    ID                             bigint NOT NULL
    , SE_ID                          bigint           NULL
    , SE_VERSION                     bigint           NULL
    , SME_ID                         bigint           NULL
    , SCOPE_ID                       bigint           NULL
    , STATE                          integer          NULL
    , EXIT_CODE                      integer          NULL
    , COMMANDLINE                    varchar(512)     NULL
    , LOGFILE                        varchar(512)     NULL
    , ERRLOGFILE                     varchar(512)     NULL
    , PID                            varchar(32)      NULL
    , EXTPID                         varchar(32)      NULL
    , ERROR_MSG                      varchar(256)     NULL
    , RUNNABLE_TS                    bigint           NULL
    , START_TS                       bigint           NULL
    , FINSH_TS                       bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
DROP VIEW SCI_KILL_JOB;
CREATE VIEW SCI_KILL_JOB AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , SE_VERSION                     AS SE_VERSION
    , SME_ID                         AS SME_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (STATE, 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 11, 'FINISHED', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR') AS STATE
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , timestamp('1970-01-01-00.00.00') + int(mod(RUNNABLE_TS, 1125899906842624)/1000) seconds AS RUNNABLE_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(START_TS, 1125899906842624)/1000) seconds AS START_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(FINSH_TS, 1125899906842624)/1000) seconds AS FINSH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM KILL_JOB;
DROP VIEW SCI_C_NAMED_ENVIRONMENT;
DROP VIEW SCI_V_NAMED_ENVIRONMENT;
CREATE VIEW SCI_C_NAMED_ENVIRONMENT AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM NAMED_ENVIRONMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_NAMED_ENVIRONMENT AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM NAMED_ENVIRONMENT;
DROP VIEW SCI_NAMED_RESOURCE;
CREATE VIEW SCI_NAMED_RESOURCE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , DECODE (USAGE, 1, 'STATIC', 2, 'SYSTEM', 4, 'SYNCHRONIZING', 8, 'CATEGORY', 3, 'POOL') AS USAGE
    , RSP_ID                         AS RSP_ID
    , FACTOR                         AS FACTOR
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM NAMED_RESOURCE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NICE_PROFILE (
    ID                             bigint NOT NULL
    , NAME                           varchar(64)     NOT NULL
    , IS_ACTIVE                      integer         NOT NULL
    , ACTIVE_TS                      bigint              NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_NICE_PROFILE
ON NICE_PROFILE(ID);
DROP VIEW SCI_NICE_PROFILE;
CREATE VIEW SCI_NICE_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , ACTIVE_TS                      AS ACTIVE_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM NICE_PROFILE;
-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE NICE_PROFILE_ENTRY (
    ID                             bigint NOT NULL
    , NP_ID                          bigint          NOT NULL
    , PREFERENCE                     integer         NOT NULL
    , FOLDER_ID                      bigint              NULL
    , IS_SUSPENDED                   integer         NOT NULL
    , RENICE                         integer         NOT NULL
    , IS_ACTIVE                      integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_NICE_PROFILE_ENTRY
ON NICE_PROFILE_ENTRY(ID);
DROP VIEW SCI_NICE_PROFILE_ENTRY;
CREATE VIEW SCI_NICE_PROFILE_ENTRY AS
SELECT 
    ID 
    , NP_ID                          AS NP_ID
    , PREFERENCE                     AS PREFERENCE
    , FOLDER_ID                      AS FOLDER_ID
    , DECODE (IS_SUSPENDED, 0, 'NOSUSPEND', 1, 'SUSPEND', 2, 'ADMINSUSPEND') AS IS_SUSPENDED
    , RENICE                         AS RENICE
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM NICE_PROFILE_ENTRY;
DROP VIEW SCI_MEMBER;
CREATE VIEW SCI_MEMBER AS
SELECT 
    ID 
    , G_ID                           AS G_ID
    , U_ID                           AS U_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM MEMBER;
DROP VIEW SCI_C_OBJECT_COMMENT;
DROP VIEW SCI_V_OBJECT_COMMENT;
CREATE VIEW SCI_C_OBJECT_COMMENT AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , DECODE (OBJECT_TYPE, 9, 'JOB_DEFINITION', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 6, 'FOLDER', 15, 'SCOPE', 10, 'NAMED_RESOURCE', 31, 'NICE_PROFILE', 11, 'RESOURCE', 1, 'ENVIRONMENT', 7, 'FOOTPRINT', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 8, 'USER', 16, 'TRIGGER', 17, 'JOB', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 21, 'GROUP', 23, 'PARAMETER', 24, 'POOL', 25, 'DISTRIBUTION', 29, 'WATCH_TYPE', 30, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , DECODE (INFO_TYPE, 0, 'TEXT', 1, 'URL') AS INFO_TYPE
    , SEQUENCE_NUMBER                AS SEQUENCE_NUMBER
    , DESCRIPTION                    AS DESCRIPTION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM OBJECT_COMMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_OBJECT_COMMENT AS
SELECT 
    ID 
    , OBJECT_ID                      AS OBJECT_ID
    , DECODE (OBJECT_TYPE, 9, 'JOB_DEFINITION', 2, 'EXIT_STATE_DEFINITION', 3, 'EXIT_STATE_PROFILE', 4, 'EXIT_STATE_MAPPING', 5, 'EXIT_STATE_TRANSLATION', 6, 'FOLDER', 15, 'SCOPE', 10, 'NAMED_RESOURCE', 31, 'NICE_PROFILE', 11, 'RESOURCE', 1, 'ENVIRONMENT', 7, 'FOOTPRINT', 13, 'RESOURCE_STATE_DEFINITION', 14, 'RESOURCE_STATE_PROFILE', 12, 'RESOURCE_STATE_MAPPING', 8, 'USER', 16, 'TRIGGER', 17, 'JOB', 18, 'EVENT', 19, 'INTERVAL', 20, 'SCHEDULE', 22, 'SCHEDULED_EVENT', 21, 'GROUP', 23, 'PARAMETER', 24, 'POOL', 25, 'DISTRIBUTION', 29, 'WATCH_TYPE', 30, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , DECODE (INFO_TYPE, 0, 'TEXT', 1, 'URL') AS INFO_TYPE
    , SEQUENCE_NUMBER                AS SEQUENCE_NUMBER
    , DESCRIPTION                    AS DESCRIPTION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM OBJECT_COMMENT;
DROP VIEW SCI_OBJECT_EVENT;
CREATE VIEW SCI_OBJECT_EVENT AS
SELECT 
    ID 
    , TR_ID                          AS TR_ID
    , OI_ID                          AS OI_ID
    , DECODE (EVENT_TYPE, 1, 'CREATE', 2, 'CHANGE', 3, 'DELETE') AS EVENT_TYPE
    , SME_ID                         AS SME_ID
    , SE_ID                          AS SE_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(SUBMIT_TS, 1125899906842624)/1000) seconds AS SUBMIT_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(FINAL_TS, 1125899906842624)/1000) seconds AS FINAL_TS
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , MAIN_SME_ID                    AS MAIN_SME_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(MAIN_FINAL_TS, 1125899906842624)/1000) seconds AS MAIN_FINAL_TS
    , MAIN_FINAL_ESD_ID              AS MAIN_FINAL_ESD_ID
    , SE_VERSION                     AS SE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM OBJECT_EVENT;
DROP VIEW SCI_OBJECT_INSTANCE;
CREATE VIEW SCI_OBJECT_INSTANCE AS
SELECT 
    ID 
    , UNIQUE_NAME                    AS UNIQUE_NAME
    , OM_ID                          AS OM_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(MODIFY_TS, 1125899906842624)/1000) seconds AS MODIFY_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(REMOVE_TS, 1125899906842624)/1000) seconds AS REMOVE_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM OBJECT_INSTANCE;
DROP VIEW SCI_OBJECT_MONITOR;
CREATE VIEW SCI_OBJECT_MONITOR AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , WT_ID                          AS WT_ID
    , DECODE (RECREATE_HANDLING, 0, 'NONE', 1, 'CREATE', 2, 'CHANGE') AS RECREATE_HANDLING
    , WATCH_SE_ID                    AS WATCH_SE_ID
    , DELETE_AMOUNT                  AS DELETE_AMOUNT
    , DECODE (DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS DELETE_BASE
    , EVENT_DELETE_AMOUNT            AS EVENT_DELETE_AMOUNT
    , DECODE (EVENT_DELETE_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EVENT_DELETE_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM OBJECT_MONITOR;
DROP VIEW SCI_OBJECT_MONITOR_PARAMETER;
CREATE VIEW SCI_OBJECT_MONITOR_PARAMETER AS
SELECT 
    ID 
    , VALUE                          AS VALUE
    , OM_ID                          AS OM_ID
    , WTP_ID                         AS WTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM OBJECT_MONITOR_PARAMETER;
DROP VIEW SCI_C_PARAMETER_DEFINITION;
DROP VIEW SCI_V_PARAMETER_DEFINITION;
CREATE VIEW SCI_C_PARAMETER_DEFINITION AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM PARAMETER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_PARAMETER_DEFINITION AS
SELECT 
    ID 
    , SE_ID                          AS SE_ID
    , NAME                           AS NAME
    , DECODE (TYPE, 10, 'REFERENCE', 20, 'CHILDREFERENCE', 30, 'CONSTANT', 40, 'RESULT', 50, 'PARAMETER', 60, 'EXPRESSION', 70, 'IMPORT', 80, 'DYNAMIC', 81, 'DYNAMICVALUE', 90, 'LOCAL_CONSTANT', 91, 'RESOURCEREFERENCE') AS TYPE
    , DECODE (AGG_FUNCTION, 0, 'NONE', 61, 'AVG', 62, 'COUNT', 63, 'MIN', 64, 'MAX', 65, 'SUM') AS AGG_FUNCTION
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , DECODE (IS_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_LOCAL
    , LINK_PD_ID                     AS LINK_PD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM PARAMETER_DEFINITION;
DROP VIEW SCI_PERSISTENT_VALUE;
CREATE VIEW SCI_PERSISTENT_VALUE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , INT_VALUE                      AS INT_VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM PERSISTENT_VALUE;
DROP VIEW SCI_POOL;
CREATE VIEW SCI_POOL AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SCOPE_ID                       AS SCOPE_ID
    , OWNER_ID                       AS OWNER_ID
    , MANAGER_ID                     AS MANAGER_ID
    , DIST_ID                        AS DIST_ID
    , DEFINED_AMOUNT                 AS DEFINED_AMOUNT
    , AMOUNT                         AS AMOUNT
    , FREE_AMOUNT                    AS FREE_AMOUNT
    , CHILD_ALLOCATED                AS CHILD_ALLOCATED
    , EVALUATION_CYCLE               AS EVALUATION_CYCLE
    , NEXT_EVALUATION_TIME           AS NEXT_EVALUATION_TIME
    , TAG                            AS TAG
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_EVAL, 1125899906842624)/1000) seconds AS LAST_EVAL
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_WRITE, 1125899906842624)/1000) seconds AS LAST_WRITE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM POOL;
DROP VIEW SCI_POOL_DIST_CONFIG;
CREATE VIEW SCI_POOL_DIST_CONFIG AS
SELECT 
    ID 
    , PLD_ID                         AS PLD_ID
    , PR_ID                          AS PR_ID
    , DECODE (IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS IS_MANAGED
    , NOM_PCT                        AS NOM_PCT
    , FREE_PCT                       AS FREE_PCT
    , MIN_PCT                        AS MIN_PCT
    , MAX_PCT                        AS MAX_PCT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM POOL_DIST_CONFIG;
DROP VIEW SCI_POOL_DISTRIBUTION;
CREATE VIEW SCI_POOL_DISTRIBUTION AS
SELECT 
    ID 
    , NAME                           AS NAME
    , P_ID                           AS P_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM POOL_DISTRIBUTION;
DROP VIEW SCI_POOLED_RESOURCE;
CREATE VIEW SCI_POOLED_RESOURCE AS
SELECT 
    ID 
    , P_ID                           AS P_ID
    , R_ID                           AS R_ID
    , DECODE (IS_POOL, 1, 'TRUE', 0, 'FALSE') AS IS_POOL
    , DECODE (IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS IS_MANAGED
    , NOM_PCT                        AS NOM_PCT
    , FREE_PCT                       AS FREE_PCT
    , MIN_PCT                        AS MIN_PCT
    , MAX_PCT                        AS MAX_PCT
    , DECODE (ACT_IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS ACT_IS_MANAGED
    , ACT_NOM_PCT                    AS ACT_NOM_PCT
    , ACT_FREE_PCT                   AS ACT_FREE_PCT
    , ACT_MIN_PCT                    AS ACT_MIN_PCT
    , ACT_MAX_PCT                    AS ACT_MAX_PCT
    , TARGET_AMOUNT                  AS TARGET_AMOUNT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM POOLED_RESOURCE;
DROP VIEW SCI_RESSOURCE;
CREATE VIEW SCI_RESSOURCE AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SCOPE_ID                       AS SCOPE_ID
    , MASTER_ID                      AS MASTER_ID
    , OWNER_ID                       AS OWNER_ID
    , LINK_ID                        AS LINK_ID
    , MANAGER_ID                     AS MANAGER_ID
    , TAG                            AS TAG
    , RSD_ID                         AS RSD_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(RSD_TIME, 1125899906842624)/1000) seconds AS RSD_TIME
    , DEFINED_AMOUNT                 AS DEFINED_AMOUNT
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , FREE_AMOUNT                    AS FREE_AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , FACTOR                         AS FACTOR
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_EVAL, 1125899906842624)/1000) seconds AS LAST_EVAL
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_WRITE, 1125899906842624)/1000) seconds AS LAST_WRITE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESSOURCE;
DROP VIEW SCI_RESOURCE_ALLOCATION;
CREATE VIEW SCI_RESOURCE_ALLOCATION AS
SELECT 
    ID 
    , R_ID                           AS R_ID
    , SME_ID                         AS SME_ID
    , NR_ID                          AS NR_ID
    , AMOUNT                         AS AMOUNT
    , ORIG_AMOUNT                    AS ORIG_AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , DECODE (ALLOCATION_TYPE, 1, 'REQUEST', 6, 'MASTER_REQUEST', 2, 'RESERVATION', 3, 'MASTER_RESERVATION', 4, 'ALLOCATION', 5, 'IGNORE') AS ALLOCATION_TYPE
    , RSMP_ID                        AS RSMP_ID
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , REFCOUNT                       AS REFCOUNT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_ALLOCATION;
DROP VIEW SCI_C_RESOURCE_REQ_STATES;
DROP VIEW SCI_V_RESOURCE_REQ_STATES;
CREATE VIEW SCI_C_RESOURCE_REQ_STATES AS
SELECT 
    ID 
    , RR_ID                          AS RR_ID
    , RSD_ID                         AS RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_REQ_STATES
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_REQ_STATES AS
SELECT 
    ID 
    , RR_ID                          AS RR_ID
    , RSD_ID                         AS RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_REQ_STATES;
DROP VIEW SCI_C_RESOURCE_REQUIREMENT;
DROP VIEW SCI_V_RESOURCE_REQUIREMENT;
CREATE VIEW SCI_C_RESOURCE_REQUIREMENT AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_REQUIREMENT
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_REQUIREMENT AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , AMOUNT                         AS AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , RSMP_ID                        AS RSMP_ID
    , EXPIRED_AMOUNT                 AS EXPIRED_AMOUNT
    , DECODE (EXPIRED_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS EXPIRED_BASE
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , CONDITION                      AS CONDITION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_REQUIREMENT;
DROP VIEW SCI_RESOURCE_STATE;
CREATE VIEW SCI_RESOURCE_STATE AS
SELECT 
    ID 
    , RSD_ID                         AS RSD_ID
    , RSP_ID                         AS RSP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_STATE;
DROP VIEW SCI_RESOURCE_STATE_DEFINITION;
CREATE VIEW SCI_RESOURCE_STATE_DEFINITION AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_STATE_DEFINITION;
DROP VIEW SCI_C_RESOURCE_STATE_MAPPING;
DROP VIEW SCI_V_RESOURCE_STATE_MAPPING;
CREATE VIEW SCI_C_RESOURCE_STATE_MAPPING AS
SELECT 
    ID 
    , RSMP_ID                        AS RSMP_ID
    , ESD_ID                         AS ESD_ID
    , FROM_RSD_ID                    AS FROM_RSD_ID
    , TO_RSD_ID                      AS TO_RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_STATE_MAPPING
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_STATE_MAPPING AS
SELECT 
    ID 
    , RSMP_ID                        AS RSMP_ID
    , ESD_ID                         AS ESD_ID
    , FROM_RSD_ID                    AS FROM_RSD_ID
    , TO_RSD_ID                      AS TO_RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_STATE_MAPPING;
DROP VIEW SCI_C_RESOURCE_STATE_MAP_PROF;
DROP VIEW SCI_V_RESOURCE_STATE_MAP_PROF;
CREATE VIEW SCI_C_RESOURCE_STATE_MAP_PROF AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_STATE_MAP_PROF
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_STATE_MAP_PROF AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_STATE_MAP_PROF;
DROP VIEW SCI_RESOURCE_STATE_PROFILE;
CREATE VIEW SCI_RESOURCE_STATE_PROFILE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , INITIAL_RSD_ID                 AS INITIAL_RSD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_STATE_PROFILE;
DROP VIEW SCI_C_RESOURCE_TEMPLATE;
DROP VIEW SCI_V_RESOURCE_TEMPLATE;
CREATE VIEW SCI_C_RESOURCE_TEMPLATE AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , OWNER_ID                       AS OWNER_ID
    , RSD_ID                         AS RSD_ID
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_TEMPLATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_RESOURCE_TEMPLATE AS
SELECT 
    ID 
    , NR_ID                          AS NR_ID
    , SE_ID                          AS SE_ID
    , OWNER_ID                       AS OWNER_ID
    , RSD_ID                         AS RSD_ID
    , REQUESTABLE_AMOUNT             AS REQUESTABLE_AMOUNT
    , AMOUNT                         AS AMOUNT
    , DECODE (IS_ONLINE, 1, 'TRUE', 0, 'FALSE') AS IS_ONLINE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM RESOURCE_TEMPLATE;
DROP VIEW SCI_RESOURCE_VARIABLE;
CREATE VIEW SCI_RESOURCE_VARIABLE AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , R_ID                           AS R_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_VARIABLE;
DROP VIEW SCI_RUNNABLE_QUEUE;
CREATE VIEW SCI_RUNNABLE_QUEUE AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (STATE, 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING') AS STATE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RUNNABLE_QUEUE;
DROP VIEW SCI_SCHEDULE;
CREATE VIEW SCI_SCHEDULE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , INT_ID                         AS INT_ID
    , PARENT_ID                      AS PARENT_ID
    , TIME_ZONE                      AS TIME_ZONE
    , SE_ID                          AS SE_ID
    , DECODE (ACTIVE, 1, 'ACTIVE', 0, 'INACTIVE') AS ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM SCHEDULE;
DROP VIEW SCI_SCHEDULED_EVENT;
CREATE VIEW SCI_SCHEDULED_EVENT AS
SELECT 
    ID 
    , OWNER_ID                       AS OWNER_ID
    , SCE_ID                         AS SCE_ID
    , EVT_ID                         AS EVT_ID
    , DECODE (ACTIVE, 1, 'ACTIVE', 0, 'INACTIVE') AS ACTIVE
    , DECODE (BROKEN, 1, 'BROKEN', 0, 'NOBROKEN') AS BROKEN
    , ERROR_CODE                     AS ERROR_CODE
    , ERROR_MSG                      AS ERROR_MSG
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_START_TIME, 1125899906842624)/1000) seconds AS LAST_START_TIME
    , timestamp('1970-01-01-00.00.00') + int(mod(NEXT_START_TIME, 1125899906842624)/1000) seconds AS NEXT_START_TIME
    , DECODE (NEXT_IS_TRIGGER, 1, 'TRUE', 0, 'FALSE') AS NEXT_IS_TRIGGER
    , DECODE (BACKLOG_HANDLING, 0, 'NONE', 1, 'LAST', 2, 'ALL') AS BACKLOG_HANDLING
    , DECODE (SUSPEND_LIMIT, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS SUSPEND_LIMIT
    , SUSPEND_LIMIT_MULTIPLIER       AS SUSPEND_LIMIT_MULTIPLIER
    , DECODE (IS_CALENDAR, 1, 'ACTIVE', 0, 'INACTIVE') AS IS_CALENDAR
    , CALENDAR_HORIZON               AS CALENDAR_HORIZON
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SCHEDULED_EVENT;
DROP VIEW SCI_C_SCHEDULING_ENTITY;
DROP VIEW SCI_V_SCHEDULING_ENTITY;
CREATE VIEW SCI_C_SCHEDULING_ENTITY AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FOLDER_ID                      AS FOLDER_ID
    , OWNER_ID                       AS OWNER_ID
    , DECODE (TYPE, 1, 'JOB', 2, 'BATCH', 3, 'MILESTONE') AS TYPE
    , RUN_PROGRAM                    AS RUN_PROGRAM
    , RERUN_PROGRAM                  AS RERUN_PROGRAM
    , KILL_PROGRAM                   AS KILL_PROGRAM
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , DECODE (TRUNC_LOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_LOG
    , ERRLOGFILE                     AS ERRLOGFILE
    , DECODE (TRUNC_ERRLOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_ERRLOG
    , EXPECTED_RUNTIME               AS EXPECTED_RUNTIME
    , EXPECTED_FINALTIME             AS EXPECTED_FINALTIME
    , GET_EXPECTED_RUNTIME           AS GET_EXPECTED_RUNTIME
    , PRIORITY                       AS PRIORITY
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , DECODE (AGING_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS AGING_BASE
    , DECODE (SUBMIT_SUSPENDED, 1, 'SUSPEND', 0, 'NOSUSPEND') AS SUBMIT_SUSPENDED
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MASTER_SUBMITTABLE, 1, 'MASTER', 0, 'NOMASTER') AS MASTER_SUBMITTABLE
    , TIMEOUT_AMOUNT                 AS TIMEOUT_AMOUNT
    , DECODE (TIMEOUT_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS TIMEOUT_BASE
    , TIMEOUT_STATE_ID               AS TIMEOUT_STATE_ID
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , ESMP_ID                        AS ESMP_ID
    , ESP_ID                         AS ESP_ID
    , NE_ID                          AS NE_ID
    , FP_ID                          AS FP_ID
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SCHEDULING_ENTITY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_SCHEDULING_ENTITY AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FOLDER_ID                      AS FOLDER_ID
    , OWNER_ID                       AS OWNER_ID
    , DECODE (TYPE, 1, 'JOB', 2, 'BATCH', 3, 'MILESTONE') AS TYPE
    , RUN_PROGRAM                    AS RUN_PROGRAM
    , RERUN_PROGRAM                  AS RERUN_PROGRAM
    , KILL_PROGRAM                   AS KILL_PROGRAM
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , DECODE (TRUNC_LOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_LOG
    , ERRLOGFILE                     AS ERRLOGFILE
    , DECODE (TRUNC_ERRLOG, 0, 'NOTRUNC', 1, 'TRUNC') AS TRUNC_ERRLOG
    , EXPECTED_RUNTIME               AS EXPECTED_RUNTIME
    , EXPECTED_FINALTIME             AS EXPECTED_FINALTIME
    , GET_EXPECTED_RUNTIME           AS GET_EXPECTED_RUNTIME
    , PRIORITY                       AS PRIORITY
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , DECODE (AGING_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS AGING_BASE
    , DECODE (SUBMIT_SUSPENDED, 1, 'SUSPEND', 0, 'NOSUSPEND') AS SUBMIT_SUSPENDED
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MASTER_SUBMITTABLE, 1, 'MASTER', 0, 'NOMASTER') AS MASTER_SUBMITTABLE
    , TIMEOUT_AMOUNT                 AS TIMEOUT_AMOUNT
    , DECODE (TIMEOUT_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS TIMEOUT_BASE
    , TIMEOUT_STATE_ID               AS TIMEOUT_STATE_ID
    , DECODE (DEPENDENCY_OPERATION, 1, 'AND', 2, 'OR') AS DEPENDENCY_OPERATION
    , ESMP_ID                        AS ESMP_ID
    , ESP_ID                         AS ESP_ID
    , NE_ID                          AS NE_ID
    , FP_ID                          AS FP_ID
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_ENTITY;
DROP VIEW SCI_C_SCHEDULING_HIERARCHY;
DROP VIEW SCI_V_SCHEDULING_HIERARCHY;
CREATE VIEW SCI_C_SCHEDULING_HIERARCHY AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SCHEDULING_HIERARCHY
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_SCHEDULING_HIERARCHY AS
SELECT 
    ID 
    , SE_PARENT_ID                   AS SE_PARENT_ID
    , SE_CHILD_ID                    AS SE_CHILD_ID
    , ALIAS_NAME                     AS ALIAS_NAME
    , DECODE (IS_STATIC, 1, 'STATIC', 0, 'DYNAMIC') AS IS_STATIC
    , PRIORITY                       AS PRIORITY
    , DECODE (SUSPEND, 1, 'CHILDSUSPEND', 2, 'NOSUSPEND', 3, 'SUSPEND') AS SUSPEND
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , ESTP_ID                        AS ESTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM SCHEDULING_HIERARCHY;
DROP VIEW SCI_SCOPE;
CREATE VIEW SCI_SCOPE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , DECODE (TYPE, 1, 'SCOPE', 2, 'SERVER') AS TYPE
    , DECODE (IS_TERMINATE, 1, 'TRUE', 0, 'FALSE') AS IS_TERMINATE
    , DECODE (HAS_ALTEREDCONFIG, 1, 'TRUE', 0, 'FALSE') AS HAS_ALTEREDCONFIG
    , DECODE (IS_SUSPENDED, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DECODE (IS_REGISTERED, 1, 'TRUE', 0, 'FALSE') AS IS_REGISTERED
    , DECODE (STATE, 1, 'NOMINAL', 2, 'NONFATAL', 3, 'FATAL') AS STATE
    , PID                            AS PID
    , NODE                           AS NODE
    , ERRMSG                         AS ERRMSG
    , LAST_ACTIVE                    AS LAST_ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM SCOPE;
DROP VIEW SCI_SCOPE_CONFIG;
CREATE VIEW SCI_SCOPE_CONFIG AS
SELECT 
    ID 
    , KEY                            AS KEY
    , VALUE                          AS VALUE
    , S_ID                           AS S_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SCOPE_CONFIG;
DROP VIEW SCI_SCOPE_CONFIG_ENVMAPPING;
CREATE VIEW SCI_SCOPE_CONFIG_ENVMAPPING AS
SELECT 
    ID 
    , KEY                            AS KEY
    , VALUE                          AS VALUE
    , S_ID                           AS S_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SCOPE_CONFIG_ENVMAPPING;
DROP VIEW SCI_SME_COUNTER;
CREATE VIEW SCI_SME_COUNTER AS
SELECT 
    ID 
    , JAHR                           AS JAHR
    , MONAT                          AS MONAT
    , TAG                            AS TAG
    , ANZAHL                         AS ANZAHL
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SME_COUNTER;
CREATE TABLE ARC_SUBMITTED_ENTITY (
    ID                             bigint NOT NULL
    , ACCESS_KEY                     bigint           NULL
    , MASTER_ID                      bigint           NULL
    , SUBMIT_TAG                     varchar(32)      NULL
    , UNRESOLVED_HANDLING            integer          NULL
    , SE_ID                          bigint           NULL
    , CHILD_TAG                      varchar(70)      NULL
    , SE_VERSION                     bigint           NULL
    , OWNER_ID                       bigint           NULL
    , PARENT_ID                      bigint           NULL
    , SCOPE_ID                       bigint           NULL
    , IS_STATIC                      integer          NULL
    , MERGE_MODE                     integer          NULL
    , STATE                          integer          NULL
    , JOB_ESD_ID                     bigint           NULL
    , JOB_ESD_PREF                   integer          NULL
    , JOB_IS_FINAL                   integer          NULL
    , JOB_IS_RESTARTABLE             integer          NULL
    , FINAL_ESD_ID                   bigint           NULL
    , EXIT_CODE                      integer          NULL
    , COMMANDLINE                    varchar(512)     NULL
    , RR_COMMANDLINE                 varchar(512)     NULL
    , RERUN_SEQ                      integer          NULL
    , IS_REPLACED                    integer          NULL
    , IS_CANCELLED                   integer          NULL
    , BASE_SME_ID                    bigint           NULL
    , REASON_SME_ID                  bigint           NULL
    , FIRE_SME_ID                    bigint           NULL
    , FIRE_SE_ID                     bigint           NULL
    , TR_ID                          bigint           NULL
    , TR_SD_ID_OLD                   bigint           NULL
    , TR_SD_ID_NEW                   bigint           NULL
    , TR_SEQ                         integer          NULL
    , WORKDIR                        varchar(512)     NULL
    , LOGFILE                        varchar(512)     NULL
    , ERRLOGFILE                     varchar(512)     NULL
    , PID                            varchar(32)      NULL
    , EXTPID                         varchar(32)      NULL
    , ERROR_MSG                      varchar(256)     NULL
    , KILL_ID                        bigint           NULL
    , KILL_EXIT_CODE                 integer          NULL
    , IS_SUSPENDED                   integer          NULL
    , IS_SUSPENDED_LOCAL             integer          NULL
    , PRIORITY                       integer          NULL
    , RAW_PRIORITY                   integer          NULL
    , NICE                           integer          NULL
    , NP_NICE                        integer          NULL
    , MIN_PRIORITY                   integer          NULL
    , AGING_AMOUNT                   integer          NULL
    , PARENT_SUSPENDED               integer          NULL
    , CHILD_SUSPENDED                integer          NULL
    , WARN_COUNT                     integer          NULL
    , WARN_LINK                      bigint           NULL
    , SUBMIT_TS                      bigint           NULL
    , RESUME_TS                      bigint           NULL
    , SYNC_TS                        bigint           NULL
    , RESOURCE_TS                    bigint           NULL
    , RUNNABLE_TS                    bigint           NULL
    , START_TS                       bigint           NULL
    , FINSH_TS                       bigint           NULL
    , FINAL_TS                       bigint           NULL
    , CNT_SUBMITTED                  integer          NULL
    , CNT_DEPENDENCY_WAIT            integer          NULL
    , CNT_SYNCHRONIZE_WAIT           integer          NULL
    , CNT_RESOURCE_WAIT              integer          NULL
    , CNT_RUNNABLE                   integer          NULL
    , CNT_STARTING                   integer          NULL
    , CNT_STARTED                    integer          NULL
    , CNT_RUNNING                    integer          NULL
    , CNT_TO_KILL                    integer          NULL
    , CNT_KILLED                     integer          NULL
    , CNT_CANCELLED                  integer          NULL
    , CNT_FINISHED                   integer          NULL
    , CNT_FINAL                      integer          NULL
    , CNT_BROKEN_ACTIVE              integer          NULL
    , CNT_BROKEN_FINISHED            integer          NULL
    , CNT_ERROR                      integer          NULL
    , CNT_UNREACHABLE                integer          NULL
    , CNT_RESTARTABLE                integer          NULL
    , CNT_WARN                       integer          NULL
    , CNT_PENDING                    integer          NULL
    , IDLE_TS                        integer          NULL
    , IDLE_TIME                      integer          NULL
    , STATISTIC_TS                   integer          NULL
    , DEPENDENCY_WAIT_TIME           integer          NULL
    , SUSPEND_TIME                   integer          NULL
    , SYNC_TIME                      integer          NULL
    , RESOURCE_TIME                  integer          NULL
    , JOBSERVER_TIME                 integer          NULL
    , RESTARTABLE_TIME               integer          NULL
    , CHILD_WAIT_TIME                integer          NULL
    , OP_SUSRES_TS                   bigint           NULL
    , NPE_ID                         bigint           NULL
    , CREATOR_U_ID                   bigint           NULL
    , CREATE_TS                      bigint           NULL
    , CHANGER_U_ID                   bigint           NULL
    , CHANGE_TS                      bigint           NULL
);
ALTER TABLE SUBMITTED_ENTITY
    ADD RAW_PRIORITY integer DEFAULT 0 NOT NULL
    ADD NP_NICE integer DEFAULT 0 NOT NULL
    ADD IDLE_TS integer
    ADD IDLE_TIME integer
    ADD STATISTIC_TS integer
    ADD DEPENDENCY_WAIT_TIME integer
    ADD SUSPEND_TIME integer
    ADD SYNC_TIME integer
    ADD RESOURCE_TIME integer
    ADD JOBSERVER_TIME integer
    ADD RESTARTABLE_TIME integer
    ADD CHILD_WAIT_TIME integer
    ADD OP_SUSRES_TS bigint
    ADD NPE_ID bigint;
DROP VIEW SCI_SUBMITTED_ENTITY;
CREATE VIEW SCI_SUBMITTED_ENTITY AS
SELECT 
    ID 
    , MASTER_ID                      AS MASTER_ID
    , SUBMIT_TAG                     AS SUBMIT_TAG
    , DECODE (UNRESOLVED_HANDLING, 1, 'UH_IGNORE', 3, 'UH_SUSPEND', 2, 'UH_ERROR') AS UNRESOLVED_HANDLING
    , SE_ID                          AS SE_ID
    , CHILD_TAG                      AS CHILD_TAG
    , SE_VERSION                     AS SE_VERSION
    , OWNER_ID                       AS OWNER_ID
    , PARENT_ID                      AS PARENT_ID
    , SCOPE_ID                       AS SCOPE_ID
    , DECODE (IS_STATIC, 1, 'TRUE', 0, 'FALSE') AS IS_STATIC
    , DECODE (MERGE_MODE, 1, 'MERGE_LOCAL', 2, 'MERGE_GLOBAL', 3, 'NOMERGE', 4, 'FAILURE') AS MERGE_MODE
    , DECODE (STATE, 0, 'SUBMITTED', 1, 'DEPENDENCY_WAIT', 2, 'SYNCHRONIZE_WAIT', 3, 'RESOURCE_WAIT', 4, 'RUNNABLE', 5, 'STARTING', 6, 'STARTED', 7, 'RUNNING', 8, 'TO_KILL', 9, 'KILLED', 10, 'CANCELLED', 11, 'FINISHED', 12, 'FINAL', 13, 'BROKEN_ACTIVE', 14, 'BROKEN_FINISHED', 15, 'ERROR', 16, 'UNREACHABLE') AS STATE
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , JOB_ESD_PREF                   AS JOB_ESD_PREF
    , DECODE (JOB_IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_FINAL
    , DECODE (JOB_IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS JOB_IS_RESTARTABLE
    , FINAL_ESD_ID                   AS FINAL_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , RR_COMMANDLINE                 AS RR_COMMANDLINE
    , RERUN_SEQ                      AS RERUN_SEQ
    , DECODE (IS_REPLACED, 1, 'TRUE', 0, 'FALSE') AS IS_REPLACED
    , DECODE (IS_CANCELLED, 1, 'TRUE', 0, 'FALSE') AS IS_CANCELLED
    , BASE_SME_ID                    AS BASE_SME_ID
    , REASON_SME_ID                  AS REASON_SME_ID
    , FIRE_SME_ID                    AS FIRE_SME_ID
    , FIRE_SE_ID                     AS FIRE_SE_ID
    , TR_ID                          AS TR_ID
    , TR_SD_ID_OLD                   AS TR_SD_ID_OLD
    , TR_SD_ID_NEW                   AS TR_SD_ID_NEW
    , TR_SEQ                         AS TR_SEQ
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , PID                            AS PID
    , EXTPID                         AS EXTPID
    , ERROR_MSG                      AS ERROR_MSG
    , KILL_ID                        AS KILL_ID
    , KILL_EXIT_CODE                 AS KILL_EXIT_CODE
    , DECODE (IS_SUSPENDED, 2, 'ADMINSUSPEND', 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPENDED
    , DECODE (IS_SUSPENDED_LOCAL, 1, 'TRUE', 0, 'FALSE') AS IS_SUSPENDED_LOCAL
    , PRIORITY                       AS PRIORITY
    , RAW_PRIORITY                   AS RAW_PRIORITY
    , NICE                           AS NICE
    , NP_NICE                        AS NP_NICE
    , MIN_PRIORITY                   AS MIN_PRIORITY
    , AGING_AMOUNT                   AS AGING_AMOUNT
    , PARENT_SUSPENDED               AS PARENT_SUSPENDED
    , CHILD_SUSPENDED                AS CHILD_SUSPENDED
    , WARN_COUNT                     AS WARN_COUNT
    , WARN_LINK                      AS WARN_LINK
    , timestamp('1970-01-01-00.00.00') + int(mod(SUBMIT_TS, 1125899906842624)/1000) seconds AS SUBMIT_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(RESUME_TS, 1125899906842624)/1000) seconds AS RESUME_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(SYNC_TS, 1125899906842624)/1000) seconds AS SYNC_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(RESOURCE_TS, 1125899906842624)/1000) seconds AS RESOURCE_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(RUNNABLE_TS, 1125899906842624)/1000) seconds AS RUNNABLE_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(START_TS, 1125899906842624)/1000) seconds AS START_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(FINSH_TS, 1125899906842624)/1000) seconds AS FINSH_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(FINAL_TS, 1125899906842624)/1000) seconds AS FINAL_TS
    , IDLE_TIME                      AS IDLE_TIME
    , DEPENDENCY_WAIT_TIME           AS DEPENDENCY_WAIT_TIME
    , SUSPEND_TIME                   AS SUSPEND_TIME
    , SYNC_TIME                      AS SYNC_TIME
    , RESOURCE_TIME                  AS RESOURCE_TIME
    , JOBSERVER_TIME                 AS JOBSERVER_TIME
    , RESTARTABLE_TIME               AS RESTARTABLE_TIME
    , CHILD_WAIT_TIME                AS CHILD_WAIT_TIME
    , OP_SUSRES_TS                   AS OP_SUSRES_TS
    , NPE_ID                         AS NPE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , ((NVL(FINAL_TS, TIMESTAMPDIFF(2, CURRENT TIMESTAMP - CURRENT TIMEZONE - TIMESTAMP('1970-01-01-00.00.00')) * 1000) - SUBMIT_TS) / 1000) - DEPENDENCY_WAIT_TIME AS PROCESS_TIME
  FROM SUBMITTED_ENTITY;
DROP VIEW SCI_SUBMITTED_ENTITY_STATS;
CREATE VIEW SCI_SUBMITTED_ENTITY_STATS AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , RERUN_SEQ                      AS RERUN_SEQ
    , SCOPE_ID                       AS SCOPE_ID
    , JOB_ESD_ID                     AS JOB_ESD_ID
    , EXIT_CODE                      AS EXIT_CODE
    , COMMANDLINE                    AS COMMANDLINE
    , WORKDIR                        AS WORKDIR
    , LOGFILE                        AS LOGFILE
    , ERRLOGFILE                     AS ERRLOGFILE
    , EXTPID                         AS EXTPID
    , timestamp('1970-01-01-00.00.00') + int(mod(SYNC_TS, 1125899906842624)/1000) seconds AS SYNC_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(RESOURCE_TS, 1125899906842624)/1000) seconds AS RESOURCE_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(RUNNABLE_TS, 1125899906842624)/1000) seconds AS RUNNABLE_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(START_TS, 1125899906842624)/1000) seconds AS START_TS
    , timestamp('1970-01-01-00.00.00') + int(mod(FINISH_TS, 1125899906842624)/1000) seconds AS FINISH_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM SUBMITTED_ENTITY_STATS;
DROP VIEW SCI_C_TEMPLATE_VARIABLE;
DROP VIEW SCI_V_TEMPLATE_VARIABLE;
CREATE VIEW SCI_C_TEMPLATE_VARIABLE AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , RT_ID                          AS RT_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM TEMPLATE_VARIABLE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TEMPLATE_VARIABLE AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , RT_ID                          AS RT_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TEMPLATE_VARIABLE;
DROP VIEW SCI_C_TRIGGER_DEFINITION;
DROP VIEW SCI_V_TRIGGER_DEFINITION;
CREATE VIEW SCI_C_TRIGGER_DEFINITION AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FIRE_ID                        AS FIRE_ID
    , DECODE (OBJECT_TYPE, 0, 'JOB_DEFINITION', 1, 'RESOURCE', 2, 'NAMED_RESOURCE', 3, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , SE_ID                          AS SE_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , PARENT_SE_ID                   AS PARENT_SE_ID
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , DECODE (ACTION, 0, 'SUBMIT', 1, 'RERUN') AS ACTION
    , DECODE (TYPE, 0, 'IMMEDIATE_LOCAL', 2, 'BEFORE_FINAL', 3, 'AFTER_FINAL', 1, 'IMMEDIATE_MERGE', 4, 'FINISH_CHILD', 5, 'UNTIL_FINISHED', 6, 'UNTIL_FINAL', 7, 'WARNING') AS TYPE
    , DECODE (IS_MASTER, 1, 'MASTER', 0, 'NOMASTER') AS IS_MASTER
    , DECODE (IS_SUSPEND, 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPEND
    , DECODE (IS_CREATE, 1, 'TRUE', 0, 'FALSE') AS IS_CREATE
    , DECODE (IS_CHANGE, 1, 'TRUE', 0, 'FALSE') AS IS_CHANGE
    , DECODE (IS_DELETE, 1, 'TRUE', 0, 'FALSE') AS IS_DELETE
    , DECODE (IS_GROUP, 1, 'TRUE', 0, 'FALSE') AS IS_GROUP
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (IS_WARN_ON_LIMIT, 1, 'TRUE', 0, 'FALSE') AS IS_WARN_ON_LIMIT
    , MAX_RETRY                      AS MAX_RETRY
    , SUBMIT_OWNER_ID                AS SUBMIT_OWNER_ID
    , CONDITION                      AS CONDITION
    , CHECK_AMOUNT                   AS CHECK_AMOUNT
    , DECODE (CHECK_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS CHECK_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM TRIGGER_DEFINITION
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_DEFINITION AS
SELECT 
    ID 
    , NAME                           AS NAME
    , FIRE_ID                        AS FIRE_ID
    , DECODE (OBJECT_TYPE, 0, 'JOB_DEFINITION', 1, 'RESOURCE', 2, 'NAMED_RESOURCE', 3, 'OBJECT_MONITOR') AS OBJECT_TYPE
    , SE_ID                          AS SE_ID
    , MAIN_SE_ID                     AS MAIN_SE_ID
    , PARENT_SE_ID                   AS PARENT_SE_ID
    , DECODE (IS_ACTIVE, 1, 'TRUE', 0, 'FALSE') AS IS_ACTIVE
    , DECODE (ACTION, 0, 'SUBMIT', 1, 'RERUN') AS ACTION
    , DECODE (TYPE, 0, 'IMMEDIATE_LOCAL', 2, 'BEFORE_FINAL', 3, 'AFTER_FINAL', 1, 'IMMEDIATE_MERGE', 4, 'FINISH_CHILD', 5, 'UNTIL_FINISHED', 6, 'UNTIL_FINAL', 7, 'WARNING') AS TYPE
    , DECODE (IS_MASTER, 1, 'MASTER', 0, 'NOMASTER') AS IS_MASTER
    , DECODE (IS_SUSPEND, 1, 'SUSPEND', 0, 'NOSUSPEND') AS IS_SUSPEND
    , DECODE (IS_CREATE, 1, 'TRUE', 0, 'FALSE') AS IS_CREATE
    , DECODE (IS_CHANGE, 1, 'TRUE', 0, 'FALSE') AS IS_CHANGE
    , DECODE (IS_DELETE, 1, 'TRUE', 0, 'FALSE') AS IS_DELETE
    , DECODE (IS_GROUP, 1, 'TRUE', 0, 'FALSE') AS IS_GROUP
    , RESUME_AT                      AS RESUME_AT
    , RESUME_IN                      AS RESUME_IN
    , DECODE (RESUME_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS RESUME_BASE
    , DECODE (IS_WARN_ON_LIMIT, 1, 'TRUE', 0, 'FALSE') AS IS_WARN_ON_LIMIT
    , MAX_RETRY                      AS MAX_RETRY
    , SUBMIT_OWNER_ID                AS SUBMIT_OWNER_ID
    , CONDITION                      AS CONDITION
    , CHECK_AMOUNT                   AS CHECK_AMOUNT
    , DECODE (CHECK_BASE, 0, 'MINUTE', 1, 'HOUR', 2, 'DAY', 3, 'WEEK', 4, 'MONTH', 5, 'YEAR') AS CHECK_BASE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_DEFINITION;
DROP VIEW SCI_C_TRIGGER_PARAMETER;
DROP VIEW SCI_V_TRIGGER_PARAMETER;
CREATE VIEW SCI_C_TRIGGER_PARAMETER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , EXPRESSION                     AS EXPRESSION
    , TRIGGER_ID                     AS TRIGGER_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM TRIGGER_PARAMETER
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_PARAMETER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , EXPRESSION                     AS EXPRESSION
    , TRIGGER_ID                     AS TRIGGER_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_PARAMETER;
DROP VIEW SCI_TRIGGER_QUEUE;
CREATE VIEW SCI_TRIGGER_QUEUE AS
SELECT 
    ID 
    , SME_ID                         AS SME_ID
    , TR_ID                          AS TR_ID
    , NEXT_TRIGGER_TIME              AS NEXT_TRIGGER_TIME
    , TIMES_CHECKED                  AS TIMES_CHECKED
    , TIMES_TRIGGERED                AS TIMES_TRIGGERED
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM TRIGGER_QUEUE;
DROP VIEW SCI_C_TRIGGER_STATE;
DROP VIEW SCI_V_TRIGGER_STATE;
CREATE VIEW SCI_C_TRIGGER_STATE AS
SELECT 
    ID 
    , TRIGGER_ID                     AS TRIGGER_ID
    , FROM_STATE_ID                  AS FROM_STATE_ID
    , TO_STATE_ID                    AS TO_STATE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM TRIGGER_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_TRIGGER_STATE AS
SELECT 
    ID 
    , TRIGGER_ID                     AS TRIGGER_ID
    , FROM_STATE_ID                  AS FROM_STATE_ID
    , TO_STATE_ID                    AS TO_STATE_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM TRIGGER_STATE;
DROP VIEW SCI_USERS;
CREATE VIEW SCI_USERS AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DECODE (IS_ENABLED, 1, 'TRUE', 0, 'FALSE') AS IS_ENABLED
    , DEFAULT_G_ID                   AS DEFAULT_G_ID
    , DELETE_VERSION                 AS DELETE_VERSION
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM USERS;
DROP VIEW SCI_USER_EQUIV;
CREATE VIEW SCI_USER_EQUIV AS
SELECT 
    ID 
    , U_ID                           AS U_ID
    , DECODE (ALT_U_TYPE, 0, 'USER', 1, 'SERVER') AS ALT_U_TYPE
    , ALT_U_ID                       AS ALT_U_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM USER_EQUIV;
DROP VIEW SCI_C_VERSIONED_EXTENTS;
DROP VIEW SCI_V_VERSIONED_EXTENTS;
CREATE VIEW SCI_C_VERSIONED_EXTENTS AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM VERSIONED_EXTENTS
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_VERSIONED_EXTENTS AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM VERSIONED_EXTENTS;
DROP VIEW SCI_C_WATCH_TYPE;
DROP VIEW SCI_V_WATCH_TYPE;
CREATE VIEW SCI_C_WATCH_TYPE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM WATCH_TYPE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_WATCH_TYPE AS
SELECT 
    ID 
    , NAME                           AS NAME
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM WATCH_TYPE;
DROP VIEW SCI_WATCH_TYPE_PARAMETER;
CREATE VIEW SCI_WATCH_TYPE_PARAMETER AS
SELECT 
    ID 
    , NAME                           AS NAME
    , DEFAULTVALUE                   AS DEFAULTVALUE
    , WT_ID                          AS WT_ID
    , DECODE (IS_SUBMIT_PAR, 1, 'TRUE', 0, 'FALSE') AS IS_SUBMIT_PAR
    , DECODE (TYPE, 1, 'CONFIG', 2, 'VALUE', 3, 'INFO') AS TYPE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM WATCH_TYPE_PARAMETER;
DROP VIEW SCI_RESOURCE_TRACE;
CREATE VIEW SCI_RESOURCE_TRACE AS
SELECT 
    R_ID                           AS R_ID
    , TAG                            AS TAG
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , timestamp('1970-01-01-00.00.00') + int(mod(WRITE_TIME, 1125899906842624)/1000) seconds AS WRITE_TIME
    , timestamp('1970-01-01-00.00.00') + int(mod(LAST_WRITE, 1125899906842624)/1000) seconds AS LAST_WRITE
  FROM RESOURCE_TRACE;
UPDATE SUBMITTED_ENTITY SET RAW_PRIORITY = PRIORITY;
