-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXIT_STATE (
    ID                             bigint NOT NULL
    , PREFERENCE                     int8            NOT NULL
    , IS_FINAL                       integer         NOT NULL
    , IS_RESTARTABLE                 integer         NOT NULL
    , IS_UNREACHABLE                 integer         NOT NULL
    , IS_BROKEN                      integer         NOT NULL
    , IS_BATCH_DEFAULT               integer         NOT NULL
    , IS_DEPENDENCY_DEFAULT          integer         NOT NULL
    , ESP_ID                         bigint          NOT NULL
    , ESD_ID                         bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , VALID_FROM                   bigint NOT NULL
    , VALID_TO                     bigint NOT NULL
);
CREATE INDEX PK_EXIT_STATE
ON EXIT_STATE(ID);
CREATE VIEW SCI_C_EXIT_STATE (ID,PREFERENCE,IS_FINAL,IS_RESTARTABLE,IS_UNREACHABLE,IS_BROKEN,IS_BATCH_DEFAULT,IS_DEPENDENCY_DEFAULT,ESP_ID,ESD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PREFERENCE                     AS PREFERENCE
    , DECODE (IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS IS_FINAL
    , DECODE (IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS IS_RESTARTABLE
    , DECODE (IS_UNREACHABLE, 1, 'TRUE', 0, 'FALSE') AS IS_UNREACHABLE
    , DECODE (IS_BROKEN, 1, 'TRUE', 0, 'FALSE') AS IS_BROKEN
    , DECODE (IS_BATCH_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_BATCH_DEFAULT
    , DECODE (IS_DEPENDENCY_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_DEPENDENCY_DEFAULT
    , ESP_ID                         AS ESP_ID
    , ESD_ID                         AS ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM EXIT_STATE
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE (ID,PREFERENCE,IS_FINAL,IS_RESTARTABLE,IS_UNREACHABLE,IS_BROKEN,IS_BATCH_DEFAULT,IS_DEPENDENCY_DEFAULT,ESP_ID,ESD_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS, VALID_FROM, VALID_TO) AS
SELECT 
    ID 
    , PREFERENCE                     AS PREFERENCE
    , DECODE (IS_FINAL, 1, 'TRUE', 0, 'FALSE') AS IS_FINAL
    , DECODE (IS_RESTARTABLE, 1, 'TRUE', 0, 'FALSE') AS IS_RESTARTABLE
    , DECODE (IS_UNREACHABLE, 1, 'TRUE', 0, 'FALSE') AS IS_UNREACHABLE
    , DECODE (IS_BROKEN, 1, 'TRUE', 0, 'FALSE') AS IS_BROKEN
    , DECODE (IS_BATCH_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_BATCH_DEFAULT
    , DECODE (IS_DEPENDENCY_DEFAULT, 1, 'TRUE', 0, 'FALSE') AS IS_DEPENDENCY_DEFAULT
    , ESP_ID                         AS ESP_ID
    , ESD_ID                         AS ESD_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , VALID_FROM
    , VALID_TO
  FROM EXIT_STATE;
